/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.ProfilingUtil;

public class CaptureCPUUsageDataAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(AnActionEvent e2) {
        return ProfilingUtil.isCPUProfiling();
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        try {
            if (!ProfilingUtil.isCPUProfiling()) {
                ProfilingUtil.startCPUProfiling();
            } else {
                String dumpPath = ProfilingUtil.captureCPUSnapshot();
                ProfilingUtil.copySnapshotAndNotify(dumpPath, e2.getProject());
            }
        }
        catch (Exception ex) {
            ProfilingUtil.notifyCapturingError(ex, e2.getProject());
        }
    }

    public void update(AnActionEvent e2) {
        boolean available = ProfilingUtil.hasValidController();
        Presentation presentation = e2.getPresentation();
        presentation.setVisible(available);
        presentation.setEnabled(available);
        presentation.setText(ActionsBundle.message((String)(ProfilingUtil.isCPUProfiling() ? "stop.capture.cpu.usage.data.action.name" : "action.CaptureCPUUsageData.text"), (Object[])new Object[0]));
        super.update(e2);
    }
}

