/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.ProfilingUtil;
import org.jetbrains.annotations.NotNull;

public class CaptureMemorySnapshotAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/CaptureMemorySnapshotAction", "update"));
        }
        boolean available = ProfilingUtil.canCaptureMemorySnapshot();
        e2.getPresentation().setEnabledAndVisible(available);
    }

    public void actionPerformed(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/CaptureMemorySnapshotAction", "actionPerformed"));
        }
        ProgressManager.getInstance().run((Task)new Task.Modal(e2.getProject(), CommonBundle.message((String)"profiling.capture.snapshot.progress", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/CaptureMemorySnapshotAction$1", "run"));
                }
                try {
                    String dumpPath = ProfilingUtil.captureMemorySnapshot();
                    ProfilingUtil.copySnapshotAndNotify(dumpPath, this.getProject());
                }
                catch (ProcessCanceledException dumpPath) {
                }
                catch (Exception e2) {
                    ProfilingUtil.notifyCapturingError(e2, this.getProject());
                }
            }
        });
    }
}

