/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.TabbedContentImpl;
import com.intellij.util.ContentsUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentUtilEx
extends ContentsUtil {
    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, boolean select) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (contentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        ContentUtilEx.addTabbedContent(manager, contentComponent, groupPrefix, tabName, select, null);
    }

    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, boolean select, @Nullable Disposable childDisposable) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (contentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/util/ContentUtilEx", "addTabbedContent"));
        }
        if (PropertiesComponent.getInstance().getBoolean("tabbed.toolwindow.expanded." + groupPrefix)) {
            Content content2 = ContentFactory.SERVICE.getInstance().createContent(contentComponent, ContentUtilEx.getFullName(groupPrefix, tabName), true);
            content2.putUserData(Content.TABBED_CONTENT_KEY, (Object)Boolean.TRUE);
            content2.putUserData(Content.TAB_GROUP_NAME_KEY, (Object)groupPrefix);
            for (Content c2 : manager.getContents()) {
                if (c2.getComponent() != contentComponent) continue;
                if (select) {
                    manager.setSelectedContent(c2);
                }
                return;
            }
            ContentUtilEx.addContent((ContentManager)manager, (Content)content2, (boolean)select);
            ContentUtilEx.registerDisposable(content2, childDisposable, contentComponent);
            return;
        }
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent(manager, groupPrefix);
        if (tabbedContent == null) {
            Disposable disposable = Disposer.newDisposable();
            tabbedContent = new TabbedContentImpl(contentComponent, tabName, true, groupPrefix);
            ContentsUtil.addOrReplaceContent((ContentManager)manager, (Content)tabbedContent, (boolean)select);
            Disposer.register((Disposable)tabbedContent, (Disposable)disposable);
        } else {
            for (Pair tab : new ArrayList(tabbedContent.getTabs())) {
                if (!Comparing.equal((Object)tab.second, (Object)contentComponent)) continue;
                tabbedContent.removeContent((JComponent)tab.second);
            }
            if (select) {
                manager.setSelectedContent((Content)tabbedContent, true, true);
            }
            tabbedContent.addContent(contentComponent, tabName, true);
        }
        ContentUtilEx.registerDisposable((Content)tabbedContent, childDisposable, contentComponent);
    }

    private static void registerDisposable(@NotNull Content content2, @Nullable Disposable childDisposable, @NotNull JComponent contentComponent) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/ContentUtilEx", "registerDisposable"));
        }
        if (contentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "registerDisposable"));
        }
        if (childDisposable != null) {
            Disposer.register((Disposable)content2, (Disposable)childDisposable);
            assert (contentComponent.getClientProperty("TabContentDisposable") == null);
            contentComponent.putClientProperty("TabContentDisposable", childDisposable);
            Disposer.register((Disposable)childDisposable, () -> {
                if (contentComponent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "lambda$registerDisposable$0"));
                }
                contentComponent.putClientProperty("TabContentDisposable", null);
            });
        } else {
            Object disposableByKey = contentComponent.getClientProperty("TabContentDisposable");
            if (disposableByKey != null && disposableByKey instanceof Disposable) {
                Disposer.register((Disposable)content2, (Disposable)((Disposable)disposableByKey));
            }
        }
    }

    @Nullable
    public static TabbedContent findTabbedContent(@NotNull ContentManager manager, @NotNull String groupPrefix) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "findTabbedContent"));
        }
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "findTabbedContent"));
        }
        TabbedContent tabbedContent = null;
        for (Content content2 : manager.getContents()) {
            if (!(content2 instanceof TabbedContent) || !content2.getTabName().startsWith(ContentUtilEx.getFullPrefix(groupPrefix))) continue;
            tabbedContent = (TabbedContent)content2;
            break;
        }
        return tabbedContent;
    }

    public static boolean isContentTab(@NotNull Content content2, @NotNull String groupPrefix) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/ContentUtilEx", "isContentTab"));
        }
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "isContentTab"));
        }
        return content2 instanceof TabbedContent && content2.getTabName().startsWith(ContentUtilEx.getFullPrefix(groupPrefix)) || groupPrefix.equals(content2.getUserData(Content.TAB_GROUP_NAME_KEY));
    }

    @NotNull
    public static String getFullName(@NotNull String groupPrefix, @NotNull String tabName) {
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "getFullName"));
        }
        if (tabName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tabName", "com/intellij/util/ContentUtilEx", "getFullName"));
        }
        String string2 = ContentUtilEx.getFullPrefix(groupPrefix) + tabName;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ContentUtilEx", "getFullName"));
        }
        return string2;
    }

    @NotNull
    private static String getFullPrefix(@NotNull String groupPrefix) {
        if (groupPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupPrefix", "com/intellij/util/ContentUtilEx", "getFullPrefix"));
        }
        String string2 = groupPrefix + ": ";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ContentUtilEx", "getFullPrefix"));
        }
        return string2;
    }

    public static boolean selectContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, boolean requestFocus2) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "selectContent"));
        }
        if (contentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentComponent", "com/intellij/util/ContentUtilEx", "selectContent"));
        }
        for (Content content2 : manager.getContents()) {
            if (content2 instanceof TabbedContentImpl) {
                boolean found = ((TabbedContentImpl)content2).findAndSelectContent(contentComponent);
                if (!found) continue;
                manager.setSelectedContent(content2, requestFocus2);
                return true;
            }
            if (!Comparing.equal((Object)content2.getComponent(), (Object)contentComponent)) continue;
            manager.setSelectedContent(content2, requestFocus2);
            return true;
        }
        return false;
    }

    @Nullable
    public static JComponent findContentComponent(@NotNull ContentManager manager, @NotNull Condition<JComponent> condition) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/util/ContentUtilEx", "findContentComponent"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/util/ContentUtilEx", "findContentComponent"));
        }
        for (Content content2 : manager.getContents()) {
            if (content2 instanceof TabbedContentImpl) {
                List<Pair<String, JComponent>> tabs = ((TabbedContentImpl)content2).getTabs();
                for (Pair<String, JComponent> tab : tabs) {
                    if (!condition.value(tab.second)) continue;
                    return (JComponent)tab.second;
                }
                continue;
            }
            if (!condition.value((Object)content2.getComponent())) continue;
            return content2.getComponent();
        }
        return null;
    }

    public static int getSelectedTab(@NotNull TabbedContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/ContentUtilEx", "getSelectedTab"));
        }
        JComponent current = content2.getComponent();
        int index = 0;
        for (Pair tab : content2.getTabs()) {
            if (tab.second == current) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

