/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.Consumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class MergingBackgroundExecutor<T> {
    private final Consumer<T> myConsumer;
    private final ExecutorService myExecutorService;

    public MergingBackgroundExecutor(@NotNull String name, int maxThreads, @NotNull Consumer<T> consumer2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/MergingBackgroundExecutor", "<init>"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/MergingBackgroundExecutor", "<init>"));
        }
        this.myConsumer = consumer2;
        this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)name, (int)maxThreads);
    }

    public void queue(@NotNull T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/MergingBackgroundExecutor", "queue"));
        }
        this.myExecutorService.execute(() -> {
            if (t2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/MergingBackgroundExecutor", "lambda$queue$0"));
            }
            this.myConsumer.consume(t2);
        });
    }

    @NotNull
    public static MergingBackgroundExecutor<Runnable> newRunnableExecutor(@NotNull String name, int maxThreads) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/MergingBackgroundExecutor", "newRunnableExecutor"));
        }
        MergingBackgroundExecutor<Runnable> mergingBackgroundExecutor = new MergingBackgroundExecutor<Runnable>(name, maxThreads, runnable2 -> runnable2.run());
        if (mergingBackgroundExecutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/MergingBackgroundExecutor", "newRunnableExecutor"));
        }
        return mergingBackgroundExecutor;
    }
}

