/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.SystemProperties;
import com.yourkit.api.Controller;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilingUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.ProfilingUtil");
    private static final NotificationGroup GROUP = new NotificationGroup("Profiling", NotificationDisplayType.BALLOON, false);
    private static final boolean ourAllocationsEnabled;
    private static Controller ourController;
    private static boolean ourCPUProfiling;

    public static void reinitialize() {
        try {
            ourController = new Controller();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static boolean hasValidController() {
        return ourController != null;
    }

    public static void startCPUProfiling() {
        boolean tracingEnabled = Boolean.getBoolean("profile.trace");
        ProfilingUtil.startCPUProfiling(tracingEnabled);
    }

    public static void startCPUProfiling(boolean withCounts) {
        if (ProfilingUtil.hasValidController()) {
            try {
                if (withCounts) {
                    ourController.startCPUTracing(null);
                } else {
                    ourController.startCPUSampling(null);
                }
                ourCPUProfiling = true;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        } else {
            LOG.warn("ProfilingUtil is disabled, add -agentlib:yjpagent to the command line");
        }
    }

    public static String captureCPUSnapshot() {
        if (ProfilingUtil.hasValidController()) {
            try {
                String dumpPath = ourController.captureSnapshot(0L);
                ourController.stopCPUProfiling();
                LOG.info("CPU snapshot is generated at " + dumpPath);
                ourCPUProfiling = false;
                return dumpPath;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }

    public static boolean canCaptureMemorySnapshot() {
        boolean forceYourKit = Boolean.getBoolean("profile.yourkit");
        return !forceYourKit && MemoryDumpHelper.memoryDumpAvailable() || ProfilingUtil.hasValidController();
    }

    public static String captureMemorySnapshot() {
        boolean forceYourKit = Boolean.getBoolean("profile.yourkit");
        if (!forceYourKit && MemoryDumpHelper.memoryDumpAvailable()) {
            try {
                File tempFile = FileUtil.createTempFile((String)"heapDump.", (String)".hprof");
                FileUtil.delete((File)tempFile);
                String dumpPath = tempFile.getPath();
                MemoryDumpHelper.captureMemoryDump((String)dumpPath);
                return dumpPath;
            }
            catch (Exception e2) {
                if (!ProfilingUtil.hasValidController()) {
                    throw new RuntimeException(e2);
                }
                LOG.debug((Throwable)e2);
            }
        }
        if (ProfilingUtil.hasValidController()) {
            try {
                return ourController.captureMemorySnapshot();
            }
            catch (Exception e3) {
                throw new RuntimeException(e3);
            }
        }
        LOG.warn("ProfilingUtil is disabled, add -agentlib:yjpagent to the command line");
        return null;
    }

    public static boolean canCaptureAllocations() {
        return ProfilingUtil.hasValidController() && ourAllocationsEnabled;
    }

    public static void startRecordAllocations() {
        if (ProfilingUtil.canCaptureAllocations()) {
            try {
                ourController.startAllocationRecording("exactStacks,sizeLimit=4096,recordEach=1");
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    public static String stopRecordAllocations() {
        if (ProfilingUtil.canCaptureAllocations()) {
            try {
                String dumpPath = ourController.captureMemorySnapshot();
                ourController.stopAllocationRecording();
                return dumpPath;
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
        return null;
    }

    public static void stopCPUProfiling() {
        if (ProfilingUtil.hasValidController()) {
            try {
                ourController.stopCPUProfiling();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    @NotNull
    public static String formatSnapshotName() {
        String buildNumber = ApplicationInfo.getInstance().getBuild().asString();
        String userName = SystemProperties.getUserName();
        String snapshotDate = new SimpleDateFormat("dd.MM.yyyy_HH.mm.ss").format(new Date());
        String string2 = buildNumber + '_' + userName + '_' + snapshotDate;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ProfilingUtil", "formatSnapshotName"));
        }
        return string2;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static File compressSnapshot(@NotNull String dumpFilePath, @NotNull String snapshotName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copySnapshotAndNotify(@Nullable String dumpPath, @Nullable Project project2) throws IOException {
        if (dumpPath == null) {
            return;
        }
        File snapshot = ProfilingUtil.compressSnapshot(dumpPath, ProfilingUtil.formatSnapshotName());
        if (snapshot == null) {
            return;
        }
        LOG.info("CPU snapshot is moved to " + snapshot.getAbsolutePath());
        String url = "file://" + snapshot.getAbsolutePath();
        String text2 = CommonBundle.message((String)"profiling.capture.snapshot.success", (Object[])new Object[]{snapshot.getName(), url, ShowFilePathAction.getFileManagerName()});
        GROUP.createNotification("", text2, NotificationType.INFORMATION, ShowFilePathAction.FILE_SELECTING_LISTENER).notify(project2);
    }

    public static void notifyCapturingError(@NotNull Throwable t2, @Nullable Project project2) {
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/ProfilingUtil", "notifyCapturingError"));
        }
        LOG.warn(t2);
        String text2 = CommonBundle.message((String)"profiling.capture.snapshot.error", (Object[])new Object[]{t2.getMessage()});
        GROUP.createNotification(text2, NotificationType.ERROR).notify(project2);
    }

    public static boolean isCPUProfiling() {
        return ourCPUProfiling;
    }

    static {
        Controller controller = null;
        boolean noAllocations = false;
        try {
            for (String arg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!arg.startsWith("-agentlib:yjpagent") && (!arg.startsWith("-agentpath:") || !arg.contains("yjpagent"))) continue;
                controller = new Controller();
                noAllocations = arg.contains("disablealloc") || arg.contains("disableall");
                break;
            }
            if (controller == null) {
                LOG.warn("Profiling agent is not enabled. Add -agentlib:yjpagent to idea.vmoptions if necessary to profile IDEA.");
            }
        }
        catch (Throwable t2) {
            LOG.warn("YourKit controller initialization failed", t2);
        }
        ourController = controller;
        ourAllocationsEnabled = !noAllocations;
    }
}

