/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.IOException;
import java.io.OutputStream;

public class ScrambledOutputStream
extends OutputStream {
    static final int MASK = 170;
    private final OutputStream myOriginalStream;

    public ScrambledOutputStream(OutputStream originalStream) {
        this.myOriginalStream = originalStream;
    }

    @Override
    public void write(int b2) throws IOException {
        this.myOriginalStream.write(b2 ^ 0xAA);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        byte[] newBytes = new byte[len];
        for (int i2 = 0; i2 < len; ++i2) {
            newBytes[i2] = (byte)(b2[off + i2] ^ 0xAA);
        }
        this.myOriginalStream.write(newBytes, 0, len);
    }

    @Override
    public void flush() throws IOException {
        this.myOriginalStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.myOriginalStream.close();
    }
}

