/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.SequentialTask;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SequentialModalProgressTask
extends Task.Modal {
    private static final Logger LOG = Logger.getInstance((String)("#" + SequentialModalProgressTask.class.getName()));
    private static final long DEFAULT_MIN_ITERATION_MIN_TIME = 500L;
    private long myMinIterationTime;
    private final String myTitle;
    private ProgressIndicator myIndicator;
    private SequentialTask myTask;

    public SequentialModalProgressTask(@Nullable Project project2, @NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/SequentialModalProgressTask", "<init>"));
        }
        this(project2, title, true);
    }

    public SequentialModalProgressTask(@Nullable Project project2, @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/SequentialModalProgressTask", "<init>"));
        }
        super(project2, title, canBeCancelled);
        this.myMinIterationTime = 500L;
        this.myTitle = title;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/SequentialModalProgressTask", "run"));
        }
        try {
            this.doRun(indicator);
        }
        catch (Exception e2) {
            LOG.info("Unexpected exception occurred during processing sequential task '" + this.myTitle + "'", (Throwable)e2);
        }
        finally {
            indicator.stop();
        }
    }

    public void doRun(@NotNull ProgressIndicator indicator) throws InvocationTargetException, InterruptedException {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/SequentialModalProgressTask", "doRun"));
        }
        SequentialTask task2 = this.myTask;
        if (task2 == null) {
            return;
        }
        this.myIndicator = indicator;
        indicator.setIndeterminate(false);
        this.prepare(task2);
        while (!task2.isDone()) {
            if (indicator.isCanceled()) {
                task2.stop();
                break;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                long start2 = System.currentTimeMillis();
                try {
                    while (!task2.isDone() && System.currentTimeMillis() - start2 < this.myMinIterationTime) {
                        task2.iteration();
                    }
                }
                catch (RuntimeException e2) {
                    task2.stop();
                    throw e2;
                }
            });
        }
    }

    public void setMinIterationTime(long minIterationTime) {
        this.myMinIterationTime = minIterationTime;
    }

    public void setTask(@Nullable SequentialTask task2) {
        this.myTask = task2;
    }

    public ProgressIndicator getIndicator() {
        return this.myIndicator;
    }

    protected void prepare(@NotNull SequentialTask task2) {
        if (task2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/SequentialModalProgressTask", "prepare"));
        }
        task2.prepare();
    }

    public static abstract class Adapter
    extends SequentialModalProgressTask
    implements SequentialTask {
        public Adapter(@Nullable Project project2, @NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/SequentialModalProgressTask$Adapter", "<init>"));
            }
            super(project2, title);
            this.setTask(this);
        }

        public Adapter(@Nullable Project project2, @NotNull String title, boolean canBeCancelled) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/SequentialModalProgressTask$Adapter", "<init>"));
            }
            super(project2, title, canBeCancelled);
        }

        public void prepare() {
        }

        public void stop() {
        }
    }
}

