/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.Couple;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class UriUtil {
    public static final CharMatcher PARAM_CHAR_MATCHER = CharMatcher.anyOf((CharSequence)"?#;");
    public static final CharMatcher SLASH_MATCHER = CharMatcher.is((char)'/');

    private UriUtil() {
    }

    @NotNull
    public static String trimTrailingSlashes(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/UriUtil", "trimTrailingSlashes"));
        }
        String string2 = SLASH_MATCHER.trimTrailingFrom((CharSequence)url);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UriUtil", "trimTrailingSlashes"));
        }
        return string2;
    }

    @NotNull
    public static String trimLeadingSlashes(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/UriUtil", "trimLeadingSlashes"));
        }
        String string2 = SLASH_MATCHER.trimLeadingFrom((CharSequence)url);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UriUtil", "trimLeadingSlashes"));
        }
        return string2;
    }

    public static String trimParameters(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/UriUtil", "trimParameters"));
        }
        int end = PARAM_CHAR_MATCHER.indexIn((CharSequence)url);
        return end != -1 ? url.substring(0, end) : url;
    }

    @NotNull
    public static Couple<String> splitScheme(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/util/UriUtil", "splitScheme"));
        }
        ArrayList list2 = Lists.newArrayList((Iterable)Splitter.on((String)"://").limit(2).split((CharSequence)url));
        if (list2.size() == 1) {
            Couple couple = Couple.of((Object)"", list2.get(0));
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UriUtil", "splitScheme"));
            }
            return couple;
        }
        Couple couple = Couple.of(list2.get(0), list2.get(1));
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/UriUtil", "splitScheme"));
        }
        return couple;
    }
}

