/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.text.UniqueNameGenerator;
import org.jetbrains.annotations.NotNull;

public class DownloadableFileDescriptionImpl
implements DownloadableFileDescription {
    private final String myFileName;
    private final String myFileExtension;
    private final String myDownloadUrl;

    public DownloadableFileDescriptionImpl(@NotNull String downloadUrl, @NotNull String fileName, @NotNull String fileExtension) {
        if (downloadUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadUrl", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "<init>"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "<init>"));
        }
        if (fileExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileExtension", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "<init>"));
        }
        this.myFileName = fileName;
        this.myFileExtension = fileExtension.length() > 0 && !fileExtension.startsWith(".") ? "." + fileExtension : fileExtension;
        this.myDownloadUrl = downloadUrl;
    }

    @NotNull
    public String getDownloadUrl() {
        String string2 = this.myDownloadUrl;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "getDownloadUrl"));
        }
        return string2;
    }

    @NotNull
    public String getPresentableFileName() {
        String string2 = this.myFileName + this.myFileExtension;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "getPresentableFileName"));
        }
        return string2;
    }

    @NotNull
    public String getPresentableDownloadUrl() {
        String string2 = this.myDownloadUrl;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "getPresentableDownloadUrl"));
        }
        return string2;
    }

    @NotNull
    public String getDefaultFileName() {
        String string2 = this.generateFileName((Condition<String>)Conditions.alwaysTrue());
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "getDefaultFileName"));
        }
        return string2;
    }

    @NotNull
    public String generateFileName(@NotNull Condition<String> validator) {
        if (validator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validator", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "generateFileName"));
        }
        String string2 = UniqueNameGenerator.generateUniqueName((String)"", (String)this.myFileName, (String)this.myFileExtension, (String)"_", (String)"", validator);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/download/impl/DownloadableFileDescriptionImpl", "generateFileName"));
        }
        return string2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        DownloadableFileDescriptionImpl that = (DownloadableFileDescriptionImpl)o2;
        return this.myDownloadUrl.equals(that.myDownloadUrl);
    }

    public int hashCode() {
        return this.myDownloadUrl.hashCode();
    }
}

