/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.io.DataExternalizer;
import org.jetbrains.annotations.NotNull;

class PsiFileGistImpl<Data>
implements PsiFileGist<Data> {
    private static final ModificationTracker ourReindexTracker = () -> ((GistManagerImpl)GistManager.getInstance()).getReindexCount();
    private final VirtualFileGist<Data> myPersistence;
    private final VirtualFileGist.GistCalculator<Data> myCalculator;
    private final Key<CachedValue<Data>> myCacheKey;

    PsiFileGistImpl(@NotNull String id, int version, @NotNull DataExternalizer<Data> externalizer, @NotNull NullableFunction<PsiFile, Data> calculator) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/util/gist/PsiFileGistImpl", "<init>"));
        }
        if (externalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalizer", "com/intellij/util/gist/PsiFileGistImpl", "<init>"));
        }
        if (calculator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculator", "com/intellij/util/gist/PsiFileGistImpl", "<init>"));
        }
        this.myCalculator = (project2, file2) -> {
            if (calculator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "calculator", "com/intellij/util/gist/PsiFileGistImpl", "lambda$new$1"));
            }
            PsiFile psiFile = PsiFileGistImpl.getPsiFile(project2, file2);
            return psiFile == null ? null : calculator.fun((Object)psiFile);
        };
        this.myPersistence = GistManager.getInstance().newVirtualFileGist(id, version, externalizer, this.myCalculator);
        this.myCacheKey = Key.create((String)("PsiFileGist " + id));
    }

    public Data getFileData(@NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/gist/PsiFileGistImpl", "getFileData"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (PsiFileGistImpl.shouldUseMemoryStorage(file2)) {
            return (Data)CachedValuesManager.getManager((Project)file2.getProject()).getCachedValue((UserDataHolder)file2, this.myCacheKey, () -> {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/gist/PsiFileGistImpl", "lambda$getFileData$2"));
                }
                Object data = this.myCalculator.calcData(file2.getProject(), file2.getViewProvider().getVirtualFile());
                return CachedValueProvider.Result.create((Object)data, (Object[])new Object[]{file2, ourReindexTracker});
            }, false);
        }
        file2.putUserData(this.myCacheKey, null);
        return (Data)this.myPersistence.getFileData(file2.getProject(), file2.getVirtualFile());
    }

    private static boolean shouldUseMemoryStorage(PsiFile file2) {
        if (!(file2.getVirtualFile() instanceof NewVirtualFile)) {
            return true;
        }
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)file2.getProject());
        Document document = pdm.getCachedDocument(file2);
        return document != null && (pdm.isUncommited(document) || FileDocumentManager.getInstance().isDocumentUnsaved(document));
    }

    private static PsiFile getPsiFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/gist/PsiFileGistImpl", "getPsiFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/gist/PsiFileGistImpl", "getPsiFile"));
        }
        PsiFile psi = PsiManager.getInstance((Project)project2).findFile(file2);
        if (psi == null || !(psi instanceof PsiFileImpl) || ((PsiFileImpl)psi).isContentsLoaded()) {
            return psi;
        }
        FileType fileType = file2.getFileType();
        if (!(fileType instanceof LanguageFileType)) {
            return null;
        }
        return FileContentImpl.createFileFromText(project2, psi.getViewProvider().getContents(), (LanguageFileType)fileType, file2, file2.getName());
    }
}

