/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Chunk;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.impl.CycleFinder;
import com.intellij.util.graph.impl.KShortestPathsFinder;
import com.intellij.util.graph.impl.ShortestPathFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GraphAlgorithmsImpl
extends GraphAlgorithms {
    public <Node> List<Node> findShortestPath(@NotNull Graph<Node> graph, @NotNull Node start2, @NotNull Node finish) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findShortestPath"));
        }
        if (start2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findShortestPath"));
        }
        if (finish == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finish", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findShortestPath"));
        }
        return new ShortestPathFinder<Node>(graph).findPath(start2, finish);
    }

    @NotNull
    public <Node> List<List<Node>> findKShortestPaths(@NotNull Graph<Node> graph, @NotNull Node start2, @NotNull Node finish, int k2, @NotNull ProgressIndicator progressIndicator) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findKShortestPaths"));
        }
        if (start2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findKShortestPaths"));
        }
        if (finish == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finish", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findKShortestPaths"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findKShortestPaths"));
        }
        List<List<Node>> list2 = new KShortestPathsFinder<Node>(graph, start2, finish, progressIndicator).findShortestPaths(k2);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findKShortestPaths"));
        }
        return list2;
    }

    @NotNull
    public <Node> Set<List<Node>> findCycles(@NotNull Graph<Node> graph, @NotNull Node node) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findCycles"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findCycles"));
        }
        Set<List<Node>> set2 = new CycleFinder<Node>(graph).getNodeCycles(node);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "findCycles"));
        }
        return set2;
    }

    @NotNull
    public <Node> Graph<Node> invertEdgeDirections(final @NotNull Graph<Node> graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "invertEdgeDirections"));
        }
        Graph graph2 = new Graph<Node>(){

            public Collection<Node> getNodes() {
                return graph.getNodes();
            }

            public Iterator<Node> getIn(Node n2) {
                return graph.getOut(n2);
            }

            public Iterator<Node> getOut(Node n2) {
                return graph.getIn(n2);
            }
        };
        if (graph2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "invertEdgeDirections"));
        }
        return graph2;
    }

    @NotNull
    public <Node> Graph<Chunk<Node>> computeSCCGraph(final @NotNull Graph<Node> graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "computeSCCGraph"));
        }
        DFSTBuilder builder = new DFSTBuilder(graph);
        Collection components = builder.getComponents();
        final ArrayList<Chunk> chunks = new ArrayList<Chunk>(components.size());
        final LinkedHashMap nodeToChunkMap = new LinkedHashMap();
        for (Collection component : components) {
            LinkedHashSet chunkNodes = new LinkedHashSet();
            Chunk chunk = new Chunk(chunkNodes);
            chunks.add(chunk);
            for (Object node : component) {
                chunkNodes.add(node);
                nodeToChunkMap.put(node, chunk);
            }
        }
        Graph graph2 = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Chunk<Node>>(){

            public Collection<Chunk<Node>> getNodes() {
                return chunks;
            }

            public Iterator<Chunk<Node>> getIn(Chunk<Node> chunk) {
                Set chunkNodes = chunk.getNodes();
                LinkedHashSet ins = new LinkedHashSet();
                for (Object node : chunkNodes) {
                    Iterator nodeIns = graph.getIn(node);
                    while (nodeIns.hasNext()) {
                        Object in = nodeIns.next();
                        if (chunk.containsNode(in)) continue;
                        ins.add(nodeToChunkMap.get(in));
                    }
                }
                return ins.iterator();
            }
        }));
        if (graph2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "computeSCCGraph"));
        }
        return graph2;
    }

    public <Node> void collectOutsRecursively(@NotNull Graph<Node> graph, Node start2, Set<Node> set2) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "collectOutsRecursively"));
        }
        if (!set2.add(start2)) {
            return;
        }
        Iterator iterator2 = graph.getOut(start2);
        while (iterator2.hasNext()) {
            Object node = iterator2.next();
            this.collectOutsRecursively(graph, node, set2);
        }
    }

    @NotNull
    public <Node> Collection<Chunk<Node>> computeStronglyConnectedComponents(@NotNull Graph<Node> graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "computeStronglyConnectedComponents"));
        }
        Collection collection = this.computeSCCGraph(graph).getNodes();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "computeStronglyConnectedComponents"));
        }
        return collection;
    }

    @NotNull
    public <Node> List<List<Node>> removePathsWithCycles(@NotNull List<List<Node>> paths) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "removePathsWithCycles"));
        }
        ArrayList<List<Node>> result2 = new ArrayList<List<Node>>();
        for (List<Node> path : paths) {
            if (GraphAlgorithmsImpl.containsCycle(path)) continue;
            result2.add(path);
        }
        ArrayList<List<Node>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/graph/impl/GraphAlgorithmsImpl", "removePathsWithCycles"));
        }
        return arrayList;
    }

    private static boolean containsCycle(List<?> path) {
        return new HashSet(path).size() != path.size();
    }
}

