/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import org.jetbrains.annotations.NotNull;

class GraphEdge<Node> {
    private final Node myStart;
    private final Node myFinish;
    private final int myDelta;

    GraphEdge(@NotNull Node start2, @NotNull Node finish, int delta) {
        if (start2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/util/graph/impl/GraphEdge", "<init>"));
        }
        if (finish == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finish", "com/intellij/util/graph/impl/GraphEdge", "<init>"));
        }
        this.myStart = start2;
        this.myFinish = finish;
        this.myDelta = delta;
    }

    public Node getStart() {
        return this.myStart;
    }

    public Node getFinish() {
        return this.myFinish;
    }

    public int getDelta() {
        return this.myDelta;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        GraphEdge edge = (GraphEdge)o2;
        return this.myFinish.equals(edge.myFinish) && this.myStart.equals(edge.myStart);
    }

    public int hashCode() {
        return 31 * this.myStart.hashCode() + this.myFinish.hashCode();
    }
}

