/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.AppTopics;
import com.intellij.history.LocalHistory;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.lang.FileASTNode;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.GistManagerImpl;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.ContentHashesSupport;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DeletedVirtualFileStub;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexedFilesListener;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PerIndexDocumentVersionMap;
import com.intellij.util.indexing.ProjectFilesCondition;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.SilentProgressIndicator;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.StorageGuard;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateTask;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.VfsEventsMerger;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedIndexImpl
extends FileBasedIndex {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileBasedIndexImpl");
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    private static final NotificationGroup NOTIFICATIONS = new NotificationGroup("Indexing", NotificationDisplayType.BALLOON, false);
    private final List<ID<?, ?>> myIndicesForDirectories;
    private final Map<ID<?, ?>, DocumentUpdateTask> myUnsavedDataUpdateTasks;
    private final Set<ID<?, ?>> myNotRequiringContentIndices;
    private final Set<ID<?, ?>> myRequiringContentIndices;
    private final Set<ID<?, ?>> myPsiDependentIndices;
    private final Set<FileType> myNoLimitCheckTypes;
    private final PerIndexDocumentVersionMap myLastIndexedDocStamps;
    @NotNull
    private final ChangedFilesCollector myChangedFilesCollector;
    private final List<IndexableFileSet> myIndexableSets;
    private final Map<IndexableFileSet, Project> myIndexableSetToProjectMap;
    private final MessageBusConnection myConnection;
    private final FileDocumentManager myFileDocumentManager;
    private final FileTypeManagerImpl myFileTypeManager;
    private final Set<ID<?, ?>> myUpToDateIndicesForUnsavedOrTransactedDocuments;
    private volatile SmartFMap<Document, PsiFile> myTransactionMap;
    private final boolean myIsUnitTestMode;
    @Nullable
    private ScheduledFuture<?> myFlushingFuture;
    private volatile int myLocalModCount;
    private volatile int myFilesModCount;
    private final AtomicInteger myUpdatingFiles;
    private final Set<Project> myProjectsBeingUpdated;
    private final IndexAccessValidator myAccessValidator;
    private volatile boolean myInitialized;
    private Future<IndexConfiguration> myStateFuture;
    private volatile IndexConfiguration myState;
    private final AtomicBoolean myShutdownPerformed;
    private static final ThreadLocal<Integer> myUpToDateCheckState = new ThreadLocal();
    private final ThreadLocal<Boolean> myReentrancyGuard;
    private static final Key<SoftReference<ProjectIndexableFilesFilter>> ourProjectFilesSetKey = Key.create((String)"projectFiles");
    private final Lock myCalcIndexableFilesLock;
    private static final Key<WeakReference<FileContentImpl>> ourFileContentKey = Key.create((String)"unsaved.document.index.content");
    private final StorageGuard myStorageLock;
    private volatile boolean myPreviousDataBufferingState;
    private final Object myBufferingStateUpdateLock;
    static final Key<Boolean> ourPhysicalContentKey = Key.create((String)"physical.content.flag");
    private final VirtualFileUpdateTask myForceUpdateTask;
    private final AtomicInteger myForceUpdateRequests;
    private final Lock myReadLock;
    private final Lock myWriteLock;

    private IndexConfiguration getState() {
        IndexConfiguration state;
        if (!this.myInitialized) {
            LOG.error("Unexpected initialization problem");
        }
        if ((state = this.myState) == null) {
            try {
                this.myState = state = this.myStateFuture.get();
            }
            catch (Throwable t2) {
                throw new RuntimeException(t2);
            }
        }
        return state;
    }

    public FileBasedIndexImpl(VirtualFileManager vfManager, FileDocumentManager fdm, FileTypeManagerImpl fileTypeManager, @NotNull MessageBus bus) {
        if (bus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/util/indexing/FileBasedIndexImpl", "<init>"));
        }
        this.myIndicesForDirectories = new SmartList();
        this.myUnsavedDataUpdateTasks = new THashMap();
        this.myNotRequiringContentIndices = new THashSet();
        this.myRequiringContentIndices = new THashSet();
        this.myPsiDependentIndices = new THashSet();
        this.myNoLimitCheckTypes = new THashSet();
        this.myLastIndexedDocStamps = new PerIndexDocumentVersionMap();
        this.myIndexableSets = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myIndexableSetToProjectMap = new THashMap();
        this.myUpToDateIndicesForUnsavedOrTransactedDocuments = ContainerUtil.newConcurrentSet();
        this.myTransactionMap = SmartFMap.emptyMap();
        this.myUpdatingFiles = new AtomicInteger();
        this.myProjectsBeingUpdated = ContainerUtil.newConcurrentSet();
        this.myAccessValidator = new IndexAccessValidator();
        this.myShutdownPerformed = new AtomicBoolean(false);
        this.myReentrancyGuard = ThreadLocal.withInitial(() -> Boolean.FALSE);
        this.myCalcIndexableFilesLock = new ReentrantLock();
        this.myStorageLock = new StorageGuard();
        this.myBufferingStateUpdateLock = new Object();
        this.myForceUpdateTask = new VirtualFileUpdateTask();
        this.myForceUpdateRequests = new AtomicInteger();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.myReadLock = lock.readLock();
        this.myWriteLock = lock.writeLock();
        this.myFileDocumentManager = fdm;
        this.myFileTypeManager = fileTypeManager;
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        MessageBusConnection connection = bus.connect();
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/util/indexing/FileBasedIndexImpl$1", "transactionStarted"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$1", "transactionStarted"));
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.plus((Object)doc, (Object)file2);
                FileBasedIndexImpl.this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
            }

            @Override
            public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/util/indexing/FileBasedIndexImpl$1", "transactionCompleted"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$1", "transactionCompleted"));
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.minus((Object)doc);
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){
            @Nullable
            private Map<FileType, Set<String>> myTypeToExtensionMap;

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/FileBasedIndexImpl$2", "beforeFileTypesChanged"));
                }
                FileBasedIndexImpl.cleanupProcessedFlag();
                this.myTypeToExtensionMap = new THashMap();
                for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                    this.myTypeToExtensionMap.put(type, this.getExtensions(type));
                }
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/util/indexing/FileBasedIndexImpl$2", "fileTypesChanged"));
                }
                Map<FileType, Set<String>> oldExtensions = this.myTypeToExtensionMap;
                this.myTypeToExtensionMap = null;
                if (oldExtensions != null) {
                    THashMap newExtensions = new THashMap();
                    for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                        newExtensions.put(type, this.getExtensions(type));
                    }
                    if (!newExtensions.keySet().containsAll(oldExtensions.keySet())) {
                        this.rebuildAllIndices();
                        return;
                    }
                    for (Map.Entry entry : oldExtensions.entrySet()) {
                        FileType fileType = (FileType)entry.getKey();
                        Set strings = (Set)entry.getValue();
                        if (((Set)newExtensions.get(fileType)).containsAll(strings)) continue;
                        this.rebuildAllIndices();
                        return;
                    }
                }
            }

            @NotNull
            private Set<String> getExtensions(@NotNull FileType type) {
                if (type == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/indexing/FileBasedIndexImpl$2", "getExtensions"));
                }
                THashSet set2 = new THashSet();
                for (FileNameMatcher matcher : FileBasedIndexImpl.this.myFileTypeManager.getAssociations(type)) {
                    set2.add(matcher.getPresentableString());
                }
                THashSet tHashSet = set2;
                if (tHashSet == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$2", "getExtensions"));
                }
                return tHashSet;
            }

            private void rebuildAllIndices() {
                FileBasedIndexImpl.this.waitUntilIndicesAreInitialized();
                IndexingStamp.flushCaches();
                for (ID<?, ?> indexId : FileBasedIndexImpl.this.getState().getIndexIDs()) {
                    try {
                        FileBasedIndexImpl.this.clearIndex(indexId);
                    }
                    catch (StorageException e2) {
                        LOG.info((Throwable)e2);
                    }
                }
                FileBasedIndexImpl.scheduleIndexRebuild("File type change");
            }
        });
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$3", "fileContentReloaded"));
                }
                if (document == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/indexing/FileBasedIndexImpl$3", "fileContentReloaded"));
                }
                FileBasedIndexImpl.this.cleanupMemoryStorage();
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndexImpl.this.cleanupMemoryStorage();
            }
        });
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new ApplicationAdapter(){

            public void writeActionStarted(@NotNull Object action2) {
                if (action2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/util/indexing/FileBasedIndexImpl$4", "writeActionStarted"));
                }
                FileBasedIndexImpl.this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
            }
        });
        this.myChangedFilesCollector = new ChangedFilesCollector();
        this.myConnection = connection;
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this.myChangedFilesCollector);
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file2, @Nullable FileType fileType) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "isProjectOrWorkspaceFile"));
        }
        return ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2, (FileType)fileType);
    }

    static boolean belongsToScope(VirtualFile file2, VirtualFile restrictedTo, GlobalSearchScope filter2) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return false;
        }
        return (restrictedTo == null || Comparing.equal((Object)file2, (Object)restrictedTo)) && (filter2 == null || restrictedTo != null || filter2.accept(file2));
    }

    public void requestReindex(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "requestReindex"));
        }
        ((GistManagerImpl)GistManager.getInstance()).invalidateData();
        this.myChangedFilesCollector.invalidateIndicesRecursively(file2, true);
        if (this.myInitialized) {
            this.myChangedFilesCollector.ensureUpToDateAsync();
        }
    }

    public void initComponent() {
        long started = System.nanoTime();
        FileBasedIndexExtension[] extensions = (FileBasedIndexExtension[])Extensions.getExtensions((ExtensionPointName)FileBasedIndexExtension.EXTENSION_POINT_NAME);
        LOG.info("Index exts enumerated:" + (System.nanoTime() - started) / 1000000L);
        started = System.nanoTime();
        this.myStateFuture = IndexInfrastructure.submitGenesisTask(new FileIndexDataInitialization(extensions));
        LOG.info("Index scheduled:" + (System.nanoTime() - started) / 1000000L);
        if (!IndexInfrastructure.ourDoAsyncIndicesInitialization) {
            this.waitUntilIndicesAreInitialized();
        }
    }

    private void waitUntilIndicesAreInitialized() {
        try {
            this.myStateFuture.get();
        }
        catch (Throwable t2) {
            LOG.error(t2);
        }
    }

    private static <K, V> boolean registerIndexer(@NotNull FileBasedIndexExtension<K, V> extension, IndexConfiguration state) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/util/indexing/FileBasedIndexImpl", "registerIndexer"));
        }
        ID name = extension.getName();
        int version = extension.getVersion();
        File versionFile = IndexInfrastructure.getVersionFile(name);
        boolean versionFileExisted = versionFile.exists();
        boolean versionChanged = false;
        if (IndexingStamp.versionDiffers(versionFile, version)) {
            if (versionFileExisted) {
                versionChanged = true;
                LOG.info("Version has changed for index " + name + ". The index will be rebuilt.");
            }
            if (extension.hasSnapshotMapping() && versionChanged) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
            }
            File rootDir = IndexInfrastructure.getIndexRootDir(name);
            if (versionFileExisted) {
                FileUtil.deleteWithRenaming((File)rootDir);
            }
            IndexingStamp.rewriteVersion(versionFile, version);
        }
        FileBasedIndexImpl.initIndexStorage(extension, version, versionFile, state);
        return versionChanged;
    }

    private static <K, V> void initIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension, int version, @NotNull File versionFile, IndexConfiguration state) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/util/indexing/FileBasedIndexImpl", "initIndexStorage"));
        }
        if (versionFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionFile", "com/intellij/util/indexing/FileBasedIndexImpl", "initIndexStorage"));
        }
        VfsAwareMapIndexStorage storage2 = null;
        ID name = extension.getName();
        boolean contentHashesEnumeratorOk = false;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                if (extension.hasSnapshotMapping()) {
                    ContentHashesSupport.initContentHashesEnumerator();
                    contentHashesEnumeratorOk = true;
                }
                storage2 = new VfsAwareMapIndexStorage(IndexInfrastructure.getStorageFile(name), extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getCacheSize(), extension.keyIsUniqueForIndexedFile(), extension.traceKeyHashToVirtualFileMapping());
                FileBasedIndex.InputFilter inputFilter = extension.getInputFilter();
                THashSet addedTypes = new THashSet();
                if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
                    ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing(arg_0 -> FileBasedIndexImpl.lambda$initIndexStorage$0((Set)addedTypes, arg_0));
                }
                state.registerIndex(name, FileBasedIndexImpl.createIndex(extension, new MemoryIndexStorage(storage2, name)), file2 -> file2 instanceof VirtualFileWithId && inputFilter.acceptInput(file2), version, (Collection<FileType>)addedTypes);
                break;
            }
            catch (Exception e2) {
                LOG.info((Throwable)e2);
                boolean instantiatedStorage = storage2 != null;
                try {
                    if (storage2 != null) {
                        storage2.close();
                    }
                    storage2 = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(name));
                if (extension.hasSnapshotMapping() && (!contentHashesEnumeratorOk || instantiatedStorage)) {
                    FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
                }
                IndexingStamp.rewriteVersion(versionFile, version);
                continue;
            }
        }
    }

    private static void saveRegisteredIndicesAndDropUnregisteredOnes(@NotNull Collection<ID<?, ?>> ids) {
        Throwable throwable;
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/util/indexing/FileBasedIndexImpl", "saveRegisteredIndicesAndDropUnregisteredOnes"));
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        File registeredIndicesFile = new File(PathManager.getIndexRoot(), "registered");
        THashSet indicesToDrop = new THashSet();
        try {
            throwable = null;
            try (Iterator in = new DataInputStream(new BufferedInputStream(new FileInputStream(registeredIndicesFile)));){
                int size = ((DataInputStream)((Object)in)).readInt();
                for (int idx = 0; idx < size; ++idx) {
                    indicesToDrop.add(IOUtil.readString((DataInput)((Object)in)));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException in) {
            // empty catch block
        }
        for (ID<?, ?> key : ids) {
            indicesToDrop.remove(key.toString());
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + StringUtil.join((Collection)indicesToDrop, (String)","));
            for (String s2 : indicesToDrop) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(ID.create((String)s2)));
            }
        }
        FileUtil.createIfDoesntExist((File)registeredIndicesFile);
        try {
            throwable = null;
            try (DataOutputStream os = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(registeredIndicesFile)));){
                os.writeInt(ids.size());
                for (ID<?, ?> id : ids) {
                    IOUtil.writeString((String)id.toString(), (DataOutput)os);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static <K, V> UpdatableIndex<K, V, FileContent> createIndex(@NotNull FileBasedIndexExtension<K, V> extension, @NotNull MemoryIndexStorage<K, V> storage2) throws StorageException, IOException {
        VfsAwareMapReduceIndex index;
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndex"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndex"));
        }
        if (extension instanceof CustomImplementationFileBasedIndexExtension) {
            UpdatableIndex custom = ((CustomImplementationFileBasedIndexExtension)extension).createIndexImplementation(extension, storage2);
            if (!(custom instanceof VfsAwareMapReduceIndex)) {
                UpdatableIndex updatableIndex = custom;
                if (updatableIndex == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndex"));
                }
                return updatableIndex;
            }
            index = (VfsAwareMapReduceIndex)custom;
        } else {
            index = new VfsAwareMapReduceIndex(extension, storage2);
        }
        VfsAwareMapReduceIndex vfsAwareMapReduceIndex = index;
        if (vfsAwareMapReduceIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "createIndex"));
        }
        return vfsAwareMapReduceIndex;
    }

    public void disposeComponent() {
        this.performShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        this.waitUntilIndicesAreInitialized();
        try {
            if (this.myFlushingFuture != null) {
                this.myFlushingFuture.cancel(false);
                this.myFlushingFuture = null;
            }
        }
        finally {
            LOG.info("START INDEX SHUTDOWN");
            try {
                for (VirtualFile file2 : this.myChangedFilesCollector.getAllFilesToUpdate()) {
                    if (file2.isValid()) continue;
                    this.removeDataFromIndicesForFile(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2)));
                }
                IndexingStamp.flushCaches();
                IndexConfiguration state = this.getState();
                for (ID<?, ?> indexId : state.getIndexIDs()) {
                    UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
                    assert (index != null);
                    if (!RebuildStatus.isOk(indexId)) {
                        index.clear();
                    }
                    index.dispose();
                }
                ContentHashesSupport.flushContentHashes();
                SharedIndicesData.flushData();
                this.myConnection.disconnect();
            }
            catch (Throwable e2) {
                LOG.error("Problems during index shutdown", e2);
            }
            LOG.info("END INDEX SHUTDOWN");
        }
    }

    private void removeDataFromIndicesForFile(int fileId) {
        List<ID<?, ?>> states = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        if (!states.isEmpty()) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.removeFileDataFromIndices(states, fileId));
        }
    }

    private void removeFileDataFromIndices(@NotNull Collection<ID<?, ?>> affectedIndices, int inputId) {
        if (affectedIndices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedIndices", "com/intellij/util/indexing/FileBasedIndexImpl", "removeFileDataFromIndices"));
        }
        Throwable unexpectedError = null;
        for (ID<?, ?> indexId : affectedIndices) {
            try {
                this.updateSingleIndex(indexId, null, inputId, null);
            }
            catch (ProcessCanceledException pce) {
                LOG.error((Throwable)pce);
            }
            catch (Throwable e2) {
                LOG.info(e2);
                if (unexpectedError != null) continue;
                unexpectedError = e2;
            }
        }
        IndexingStamp.flushCache(inputId);
        if (unexpectedError != null) {
            LOG.error(unexpectedError);
        }
    }

    private void flushAllIndices(long modCount) {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            return;
        }
        IndexingStamp.flushCaches();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : new ArrayList(state.getIndexIDs())) {
            if (HeavyProcessLatch.INSTANCE.isRunning() || modCount != (long)this.myLocalModCount) {
                return;
            }
            try {
                UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
                if (index == null) continue;
                index.flush();
            }
            catch (StorageException e2) {
                LOG.info((Throwable)e2);
                this.requestRebuild(indexId);
            }
        }
        ContentHashesSupport.flushContentHashes();
        SharedIndicesData.flushData();
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "getAllKeys"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexImpl", "getAllKeys"));
        }
        THashSet allKeys = new THashSet();
        this.processAllKeys(indexId, Processors.cancelableCollectProcessor((Collection)allKeys), project2);
        THashSet tHashSet = allKeys;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getAllKeys"));
        }
        return tHashSet;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor2, @Nullable Project project2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        return this.processAllKeys(indexId, processor2, (GlobalSearchScope)(project2 == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project2)), null);
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllKeys"));
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex<K, ?, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            this.ensureUpToDate(indexId, scope.getProject(), scope);
            return index.processAllKeys(processor2, scope, idFilter);
        }
        catch (StorageException e2) {
            this.scheduleRebuild(indexId, e2);
        }
        catch (RuntimeException e3) {
            Throwable cause = e3.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e3;
        }
        return false;
    }

    public static void disableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        myUpToDateCheckState.set(currentValue == null ? 1 : currentValue + 1);
    }

    public static void enableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        if (currentValue != null) {
            int newValue = currentValue - 1;
            if (newValue != 0) {
                myUpToDateCheckState.set(newValue);
            } else {
                myUpToDateCheckState.remove();
            }
        }
    }

    private static boolean isUpToDateCheckEnabled() {
        Integer value2 = myUpToDateCheckState.get();
        return value2 == null || value2 == 0;
    }

    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project2, @Nullable GlobalSearchScope filter2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "ensureUpToDate"));
        }
        this.ensureUpToDate(indexId, project2, filter2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project2, @Nullable GlobalSearchScope filter2, @Nullable VirtualFile restrictedFile) {
        block12: {
            if (indexId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "ensureUpToDate"));
            }
            ProgressManager.checkCanceled();
            this.myChangedFilesCollector.ensureUpToDate();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.needsFileContentLoading(indexId)) {
                return;
            }
            if (filter2 == GlobalSearchScope.EMPTY_SCOPE) {
                return;
            }
            if (ActionUtil.isDumbMode((Project)project2)) {
                FileBasedIndexImpl.handleDumbMode(project2);
            }
            NoAccessDuringPsiEvents.checkCallContext();
            if (this.myReentrancyGuard.get().booleanValue()) {
                return;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) break block12;
                try {
                    if (!RebuildStatus.isOk(indexId)) {
                        throw new ProcessCanceledException();
                    }
                    this.forceUpdate(project2, filter2, restrictedFile);
                    this.indexUnsavedDocuments(indexId, project2, filter2, restrictedFile);
                }
                catch (RuntimeException e2) {
                    Throwable cause = e2.getCause();
                    if (cause instanceof StorageException || cause instanceof IOException) {
                        this.scheduleRebuild(indexId, e2);
                        break block12;
                    }
                    throw e2;
                }
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
    }

    private static void handleDumbMode(@Nullable Project project2) {
        BackgroundableProcessIndicator indicator;
        ProgressIndicator progressIndicator;
        ProgressManager.checkCanceled();
        if (project2 != null && (progressIndicator = ProgressManager.getInstance().getProgressIndicator()) instanceof BackgroundableProcessIndicator && (indicator = (BackgroundableProcessIndicator)progressIndicator).getDumbModeAction() == DumbModeAction.WAIT) {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            DumbService.getInstance((Project)project2).waitForSmartMode();
            return;
        }
        throw new IndexNotReadyException(project2 == null ? null : DumbServiceImpl.getInstance(project2).getDumbModeStartTrace());
    }

    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter2) {
        Iterator virtualFileIterator;
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "getValues"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/util/indexing/FileBasedIndexImpl", "getValues"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "getValues"));
        }
        VirtualFile restrictToFile = null;
        if (filter2 instanceof Iterable && (virtualFileIterator = ((Iterable)filter2).iterator()).hasNext()) {
            VirtualFile restrictToFileCandidate = (VirtualFile)virtualFileIterator.next();
            if (!virtualFileIterator.hasNext()) {
                restrictToFile = restrictToFileCandidate;
            }
        }
        SmartList values = new SmartList();
        FileBasedIndex.ValueProcessor processor2 = (arg_0, arg_1) -> FileBasedIndexImpl.lambda$getValues$4((List)values, arg_0, arg_1);
        if (restrictToFile != null) {
            this.processValuesInOneFile(indexId, dataKey, restrictToFile, processor2, filter2);
        } else {
            this.processValuesInScope(indexId, dataKey, true, filter2, null, processor2);
        }
        SmartList smartList = values;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getValues"));
        }
        return smartList;
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "getContainingFiles"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/util/indexing/FileBasedIndexImpl", "getContainingFiles"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "getContainingFiles"));
        }
        THashSet files2 = new THashSet();
        this.processValuesInScope(indexId, dataKey, false, filter2, null, (arg_0, arg_1) -> FileBasedIndexImpl.lambda$getContainingFiles$5((Set)files2, arg_0, arg_1));
        THashSet tHashSet = files2;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getContainingFiles"));
        }
        return tHashSet;
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<V> processor2, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        return this.processValues(indexId, dataKey, inFile, processor2, filter2, null);
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<V> processor2, @NotNull GlobalSearchScope filter2, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "processValues"));
        }
        return inFile != null ? this.processValuesInOneFile(indexId, dataKey, inFile, processor2, filter2) : this.processValuesInScope(indexId, dataKey, false, filter2, idFilter, processor2);
    }

    public <K, V> long getIndexModificationStamp(ID<K, V> indexId, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexImpl", "getIndexModificationStamp"));
        }
        UpdatableIndex<K, V, FileContent> index = this.getState().getIndex(indexId);
        if (index instanceof MapReduceIndex) {
            this.ensureUpToDate(indexId, project2, GlobalSearchScope.allScope((Project)project2));
            return ((MapReduceIndex)index).getModificationStamp();
        }
        return -1L;
    }

    public <K, V> boolean processAllValues(@NotNull ID<K, V> indexId, @NotNull K key, @NotNull Project project2, @NotNull IdValueProcessor<V> processor2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllValues"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllValues"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllValues"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "processAllValues"));
        }
        return this.processValueIterator(indexId, key, null, GlobalSearchScope.allScope((Project)project2), valueIt -> {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$processAllValues$6"));
            }
            while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    if (processor2.process(inputIdsIterator.next(), value2)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <K, V, R> R processExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter2, @NotNull ThrowableConvertor<UpdatableIndex<K, V, FileContent>, R, StorageException> computable) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processExceptions"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "processExceptions"));
        }
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/util/indexing/FileBasedIndexImpl", "processExceptions"));
        }
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex<K, V, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return null;
            }
            Project project2 = filter2.getProject();
            this.ensureUpToDate(indexId, project2, filter2, restrictToFile);
            this.myAccessValidator.checkAccessingIndexDuringOtherIndexProcessing(indexId);
            try {
                index.getReadLock().lock();
                this.myAccessValidator.startedProcessingActivityForIndex(indexId);
                Object object = computable.convert(index);
                return (R)object;
            }
            finally {
                this.myAccessValidator.stoppedProcessingActivityForIndex(indexId);
                index.getReadLock().unlock();
            }
        }
        catch (StorageException | AssertionError e2) {
            this.scheduleRebuild(indexId, (Throwable)e2);
            return null;
        }
        catch (RuntimeException e3) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e3);
            if (cause == null) throw e3;
            this.scheduleRebuild(indexId, cause);
            return null;
        }
    }

    private <K, V> boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile restrictToFile, @NotNull FileBasedIndex.ValueProcessor<V> processor2, @NotNull GlobalSearchScope scope) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesInOneFile"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesInOneFile"));
        }
        if (restrictToFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictToFile", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesInOneFile"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesInOneFile"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesInOneFile"));
        }
        if (!(restrictToFile instanceof VirtualFileWithId)) {
            return true;
        }
        int restrictedFileId = FileBasedIndexImpl.getFileId((VirtualFile)restrictToFile);
        return this.processValueIterator(indexId, dataKey, restrictToFile, scope, valueIt -> {
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$processValuesInOneFile$7"));
            }
            if (restrictToFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictToFile", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$processValuesInOneFile$7"));
            }
            while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                if (!valueIt.getValueAssociationPredicate().contains(restrictedFileId) || processor2.process(restrictToFile, value2)) continue;
                return false;
            }
            return true;
        });
    }

    private <K, V> boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<V> processor2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesInScope"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesInScope"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "processValuesInScope"));
        }
        PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        IdFilter filter2 = idFilter != null ? idFilter : this.projectIndexableFiles(scope.getProject());
        return this.processValueIterator(indexId, dataKey, null, scope, valueIt -> {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$processValuesInScope$8"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$processValuesInScope$8"));
            }
            block0: while (valueIt.hasNext()) {
                Object value2 = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    VirtualFile file2;
                    int id = inputIdsIterator.next();
                    if (filter2 != null && !filter2.containsFileId(id) || (file2 = IndexInfrastructure.findFileByIdIfCached(fs, id)) == null || !scope.accept(file2)) continue;
                    if (!processor2.process(file2, value2)) {
                        return false;
                    }
                    if (!ensureValueProcessedOnce) continue;
                    continue block0;
                }
            }
            return true;
        });
    }

    private <K, V> boolean processValueIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull Processor<InvertedIndexValueIterator<V>> valueProcessor) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processValueIterator"));
        }
        if (dataKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/util/indexing/FileBasedIndexImpl", "processValueIterator"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/util/indexing/FileBasedIndexImpl", "processValueIterator"));
        }
        if (valueProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueProcessor", "com/intellij/util/indexing/FileBasedIndexImpl", "processValueIterator"));
        }
        Boolean result2 = (Boolean)this.processExceptions(indexId, restrictToFile, scope, index -> {
            if (valueProcessor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueProcessor", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$processValueIterator$9"));
            }
            if (dataKey == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKey", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$processValueIterator$9"));
            }
            return valueProcessor.process((Object)((InvertedIndexValueIterator)index.getData(dataKey).getValueIterator()));
        });
        return result2 == null || result2 != false;
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<V> valueChecker, @NotNull Processor<VirtualFile> processor2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "processFilesContainingAllKeys"));
        }
        if (dataKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKeys", "com/intellij/util/indexing/FileBasedIndexImpl", "processFilesContainingAllKeys"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "processFilesContainingAllKeys"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "processFilesContainingAllKeys"));
        }
        ProjectIndexableFilesFilter filesSet = this.projectIndexableFiles(filter2.getProject());
        TIntHashSet set2 = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter2, valueChecker, filesSet);
        return set2 != null && FileBasedIndexImpl.processVirtualFiles(set2, filter2, processor2);
    }

    void filesUpdateEnumerationFinished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        this.myChangedFilesCollector.ensureUpToDate();
        this.myTransactionMap = SmartFMap.emptyMap();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            MapReduceIndex index = (MapReduceIndex)state.getIndex(indexId);
            assert (index != null);
            MemoryIndexStorage memStorage = (MemoryIndexStorage)index.getStorage();
            index.getWriteLock().lock();
            try {
                memStorage.clearCaches();
            }
            finally {
                index.getWriteLock().unlock();
            }
        }
    }

    public IndexedFilesListener getChangedFilesCollector() {
        return this.myChangedFilesCollector;
    }

    void filesUpdateStarted(Project project2) {
        this.myChangedFilesCollector.ensureUpToDate();
        this.myProjectsBeingUpdated.add(project2);
        ++this.myFilesModCount;
    }

    void filesUpdateFinished(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexImpl", "filesUpdateFinished"));
        }
        this.myProjectsBeingUpdated.remove(project2);
        ++this.myFilesModCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project project2) {
        if (project2 == null || this.myUpdatingFiles.get() > 0) {
            return null;
        }
        if (this.myProjectsBeingUpdated.contains(project2)) {
            return null;
        }
        SoftReference reference = (SoftReference)project2.getUserData(ourProjectFilesSetKey);
        ProjectIndexableFilesFilter data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference));
        if (data != null && data.myModificationCount == this.myFilesModCount) {
            return data;
        }
        if (this.myCalcIndexableFilesLock.tryLock()) {
            try {
                reference = (SoftReference)project2.getUserData(ourProjectFilesSetKey);
                data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference));
                if (data != null && data.myModificationCount == this.myFilesModCount) {
                    ProjectIndexableFilesFilter projectIndexableFilesFilter = data;
                    return projectIndexableFilesFilter;
                }
                long start2 = System.currentTimeMillis();
                TIntArrayList filesSet = new TIntArrayList();
                this.iterateIndexableFiles(fileOrDir -> {
                    ProgressManager.checkCanceled();
                    filesSet.add(((VirtualFileWithId)fileOrDir).getId());
                    return true;
                }, project2, (ProgressIndicator)SilentProgressIndicator.create());
                ProjectIndexableFilesFilter filter2 = new ProjectIndexableFilesFilter(filesSet, this.myFilesModCount);
                project2.putUserData(ourProjectFilesSetKey, new SoftReference<ProjectIndexableFilesFilter>(filter2));
                long finish = System.currentTimeMillis();
                LOG.debug(filesSet.size() + " files iterated in " + (finish - start2) + " ms");
                ProjectIndexableFilesFilter projectIndexableFilesFilter = filter2;
                return projectIndexableFilesFilter;
            }
            finally {
                this.myCalcIndexableFilesLock.unlock();
            }
        }
        return null;
    }

    @Nullable
    private <K, V> TIntHashSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<V> valueChecker, @Nullable ProjectIndexableFilesFilter projectFilesFilter) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "collectFileIdsContainingAllKeys"));
        }
        if (dataKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKeys", "com/intellij/util/indexing/FileBasedIndexImpl", "collectFileIdsContainingAllKeys"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "collectFileIdsContainingAllKeys"));
        }
        ThrowableConvertor convertor = index -> {
            if (dataKeys == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKeys", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$collectFileIdsContainingAllKeys$12"));
            }
            return InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)index, (Collection)dataKeys, __ -> {
                ProgressManager.checkCanceled();
                return true;
            }, (Condition)valueChecker, projectFilesFilter == null ? null : projectFilesFilter::containsFileId);
        };
        return (TIntHashSet)this.processExceptions(indexId, null, filter2, convertor);
    }

    private static boolean processVirtualFiles(@NotNull TIntHashSet ids, @NotNull GlobalSearchScope filter2, @NotNull Processor<VirtualFile> processor2) {
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/util/indexing/FileBasedIndexImpl", "processVirtualFiles"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "processVirtualFiles"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "processVirtualFiles"));
        }
        PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        return ids.forEach(id -> {
            if (filter2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$processVirtualFiles$13"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$processVirtualFiles$13"));
            }
            ProgressManager.checkCanceled();
            VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id);
            if (file2 != null && filter2.accept(file2)) {
                return processor2.process((Object)file2);
            }
            return true;
        });
    }

    @Nullable
    public static Throwable getCauseToRebuildIndex(@NotNull RuntimeException e2) {
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/indexing/FileBasedIndexImpl", "getCauseToRebuildIndex"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (e2 instanceof IndexOutOfBoundsException) {
            return e2;
        }
        Throwable cause = e2.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<K> dataKeys, @NotNull Processor<VirtualFile> processor2, @NotNull GlobalSearchScope filter2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesWithKey"));
        }
        if (dataKeys == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataKeys", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesWithKey"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesWithKey"));
        }
        if (filter2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesWithKey"));
        }
        return this.processFilesContainingAllKeys(indexId, dataKeys, filter2, null, processor2);
    }

    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e2) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "scheduleRebuild"));
        }
        if (e2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/indexing/FileBasedIndexImpl", "scheduleRebuild"));
        }
        this.requestRebuild(indexId, new Throwable(e2));
    }

    private static void scheduleIndexRebuild(String reason) {
        LOG.info("scheduleIndexRebuild, reason: " + reason);
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DumbService.getInstance((Project)project2).queueTask((DumbModeTask)new UnindexedFilesUpdater(project2));
        }
    }

    void clearIndicesIfNecessary() {
        this.waitUntilIndicesAreInitialized();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            try {
                RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<StorageException>)((ThrowableRunnable)() -> this.getIndex(indexId).clear()));
            }
            catch (StorageException e2) {
                this.requestRebuild(indexId);
                LOG.error((Throwable)e2);
            }
        }
    }

    private void clearIndex(@NotNull ID<?, ?> indexId) throws StorageException {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "clearIndex"));
        }
        this.advanceIndexVersion(indexId);
        UpdatableIndex<?, ?, FileContent> index = this.myState.getIndex(indexId);
        assert (index != null) : "Index with key " + indexId + " not found or not registered properly";
        index.clear();
    }

    private void advanceIndexVersion(ID<?, ?> indexId) {
        try {
            IndexingStamp.rewriteVersion(IndexInfrastructure.getVersionFile(indexId), this.myState.getIndexVersion(indexId));
        }
        catch (IOException e2) {
            LOG.error((Throwable)e2);
        }
    }

    @NotNull
    private Set<Document> getUnsavedDocuments() {
        Document[] documents = this.myFileDocumentManager.getUnsavedDocuments();
        if (documents.length == 0) {
            Set<Document> set2 = Collections.emptySet();
            if (set2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getUnsavedDocuments"));
            }
            return set2;
        }
        if (documents.length == 1) {
            Set<Document> set3 = Collections.singleton(documents[0]);
            if (set3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getUnsavedDocuments"));
            }
            return set3;
        }
        THashSet tHashSet = new THashSet(Arrays.asList(documents));
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getUnsavedDocuments"));
        }
        return tHashSet;
    }

    @NotNull
    private Set<Document> getTransactedDocuments() {
        Set set2 = this.myTransactionMap.keySet();
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getTransactedDocuments"));
        }
        return set2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexUnsavedDocuments(@NotNull ID<?, ?> indexId, @Nullable Project project2, GlobalSearchScope filter2, VirtualFile restrictedFile) {
        List documentsToProcessForProject;
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "indexUnsavedDocuments"));
        }
        if (this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId)) {
            return;
        }
        THashSet documents = this.getUnsavedDocuments();
        boolean psiBasedIndex = this.myPsiDependentIndices.contains(indexId);
        if (psiBasedIndex) {
            Set<Document> transactedDocuments = this.getTransactedDocuments();
            if (documents.isEmpty()) {
                documents = transactedDocuments;
            } else if (!transactedDocuments.isEmpty()) {
                documents = new THashSet(documents);
                documents.addAll(transactedDocuments);
            }
        }
        if (!documents.isEmpty() && !(documentsToProcessForProject = ContainerUtil.filter(documents, document -> FileBasedIndexImpl.belongsToScope(this.myFileDocumentManager.getFile(document), restrictedFile, filter2))).isEmpty()) {
            StorageGuard.StorageModeExitHandler guard = this.setDataBufferingEnabled(true);
            try {
                boolean processedAll;
                DocumentUpdateTask task2 = this.myUnsavedDataUpdateTasks.get(indexId);
                assert (task2 != null) : "Task for unsaved data indexing was not initialized for index " + indexId;
                boolean bl = processedAll = task2.processAll(documentsToProcessForProject, project2) && documentsToProcessForProject.size() == documents.size();
                if (processedAll && !this.hasActiveTransactions()) {
                    ProgressManager.checkCanceled();
                    this.myUpToDateIndicesForUnsavedOrTransactedDocuments.add(indexId);
                }
            }
            finally {
                guard.leave();
            }
        }
    }

    private boolean hasActiveTransactions() {
        return !this.myTransactionMap.isEmpty();
    }

    private boolean indexUnsavedDocument(@NotNull Document document, @NotNull ID<?, ?> requestedIndexId, Project project2, @NotNull VirtualFile vFile) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/indexing/FileBasedIndexImpl", "indexUnsavedDocument"));
        }
        if (requestedIndexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedIndexId", "com/intellij/util/indexing/FileBasedIndexImpl", "indexUnsavedDocument"));
        }
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/util/indexing/FileBasedIndexImpl", "indexUnsavedDocument"));
        }
        PsiFile dominantContentFile = project2 == null ? null : FileBasedIndexImpl.findLatestKnownPsiForUncomittedDocument(document, project2);
        DocumentContent content2 = dominantContentFile != null && dominantContentFile.getViewProvider().getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
        boolean psiBasedIndex = this.myPsiDependentIndices.contains(requestedIndexId);
        long currentDocStamp = psiBasedIndex ? PsiDocumentManager.getInstance((Project)project2).getLastCommittedStamp(document) : content2.getModificationStamp();
        long previousDocStamp = this.myLastIndexedDocStamps.get(document, requestedIndexId);
        if (previousDocStamp == currentDocStamp) {
            return false;
        }
        CharSequence contentText = content2.getText();
        this.myFileTypeManager.freezeFileTypeTemporarilyIn(vFile, () -> {
            void previousDocStamp;
            if (vFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$indexUnsavedDocument$15"));
            }
            if (requestedIndexId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestedIndexId", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$indexUnsavedDocument$15"));
            }
            if (document == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$indexUnsavedDocument$15"));
            }
            if (!this.isTooLarge(vFile, contentText.length()) && this.getAffectedIndexCandidates(vFile).contains(requestedIndexId) && this.getInputFilter(requestedIndexId).acceptInput(vFile)) {
                FileContentImpl newFc;
                WeakReference previousContentRef = (WeakReference)document.getUserData(ourFileContentKey);
                FileContentImpl previousContent = (FileContentImpl)((Object)((Object)com.intellij.reference.SoftReference.dereference((Reference)previousContentRef)));
                if (previousContent != null && previousContent.getStamp() == currentDocStamp) {
                    newFc = previousContent;
                } else {
                    newFc = new FileContentImpl(vFile, contentText, vFile.getCharset(), currentDocStamp);
                    document.putUserData(ourFileContentKey, new WeakReference<FileContentImpl>(newFc));
                }
                FileBasedIndexImpl.initFileContent(newFc, project2, dominantContentFile);
                newFc.ensureThreadSafeLighterAST();
                if (content2 instanceof AuthenticContent) {
                    newFc.putUserData(PlatformIdTableBuilding.EDITOR_HIGHLIGHTER, EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document));
                }
                int inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)vFile));
                try {
                    this.getIndex(requestedIndexId).update(inputId, (Object)newFc).compute();
                }
                finally {
                    FileBasedIndexImpl.cleanFileContent(newFc, dominantContentFile);
                }
            }
            long previousState = this.myLastIndexedDocStamps.set(document, requestedIndexId, currentDocStamp);
            assert (previousState == previousDocStamp);
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private StorageGuard.StorageModeExitHandler setDataBufferingEnabled(boolean enabled) {
        StorageGuard.StorageModeExitHandler storageModeExitHandler = this.myStorageLock.enter(enabled);
        if (this.myPreviousDataBufferingState != enabled) {
            Object object = this.myBufferingStateUpdateLock;
            synchronized (object) {
                if (this.myPreviousDataBufferingState != enabled) {
                    IndexConfiguration state = this.getState();
                    for (ID<?, ?> indexId : state.getIndexIDs()) {
                        MapReduceIndex index = (MapReduceIndex)state.getIndex(indexId);
                        assert (index != null);
                        ((MemoryIndexStorage)index.getStorage()).setBufferingEnabled(enabled);
                    }
                    this.myPreviousDataBufferingState = enabled;
                }
            }
        }
        StorageGuard.StorageModeExitHandler storageModeExitHandler2 = storageModeExitHandler;
        if (storageModeExitHandler2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "setDataBufferingEnabled"));
        }
        return storageModeExitHandler2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupMemoryStorage() {
        this.myLastIndexedDocStamps.clear();
        this.waitUntilIndicesAreInitialized();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            MapReduceIndex index = (MapReduceIndex)state.getIndex(indexId);
            assert (index != null);
            MemoryIndexStorage memStorage = (MemoryIndexStorage)index.getStorage();
            index.getWriteLock().lock();
            try {
                memStorage.clearMemoryMap();
            }
            finally {
                index.getWriteLock().unlock();
            }
            memStorage.fireMemoryStorageCleared();
        }
    }

    public void requestRebuild(@NotNull ID<?, ?> indexId, Throwable throwable) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "requestRebuild"));
        }
        FileBasedIndexImpl.cleanupProcessedFlag();
        if (RebuildStatus.requestRebuild(indexId)) {
            String message2 = "Rebuild requested for index " + indexId;
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() && app.isReadAccessAllowed() && !app.isDispatchThread()) {
                LOG.error(message2, throwable);
            } else {
                LOG.info(message2, throwable);
            }
            FileBasedIndexImpl.cleanupProcessedFlag();
            if (!this.myInitialized) {
                return;
            }
            this.advanceIndexVersion(indexId);
            Runnable rebuildRunnable = () -> FileBasedIndexImpl.scheduleIndexRebuild("checkRebuild");
            if (this.myIsUnitTestMode) {
                rebuildRunnable.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)app, rebuildRunnable);
            }
        }
    }

    public <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        return this.getState().getIndex(indexId);
    }

    private FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "getInputFilter"));
        }
        if (!this.myInitialized) {
            this.waitUntilIndicesAreInitialized();
        }
        return this.getState().getInputFilter(indexId);
    }

    int getChangedFileCount() {
        return this.myChangedFilesCollector.getChangedFileCount();
    }

    @NotNull
    Collection<VirtualFile> getFilesToUpdate(Project project2) {
        List list2 = ContainerUtil.findAll(this.myChangedFilesCollector.getAllFilesToUpdate(), virtualFile -> {
            if (virtualFile instanceof DeletedVirtualFileStub) {
                return true;
            }
            for (IndexableFileSet set2 : this.myIndexableSets) {
                Project proj = this.myIndexableSetToProjectMap.get(set2);
                if (proj != null && !proj.equals(project2) || !set2.isInSet(virtualFile)) continue;
                return true;
            }
            return false;
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getFilesToUpdate"));
        }
        return list2;
    }

    public boolean isFileUpToDate(VirtualFile file2) {
        return !this.myChangedFilesCollector.isScheduledForUpdate(file2);
    }

    void processRefreshedFile(@Nullable Project project2, @NotNull com.intellij.ide.caches.FileContent fileContent) {
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/util/indexing/FileBasedIndexImpl", "processRefreshedFile"));
        }
        VirtualFile file2 = fileContent.getVirtualFile();
        if (this.myChangedFilesCollector.isScheduledForUpdate(file2)) {
            this.indexFileContent(project2, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFileContent(@Nullable Project project2, @NotNull com.intellij.ide.caches.FileContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/indexing/FileBasedIndexImpl", "indexFileContent"));
        }
        VirtualFile file2 = content2.getVirtualFile();
        int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
        try {
            if (file2.isValid() && content2.getTimeStamp() != file2.getTimeStamp()) {
                content2 = new com.intellij.ide.caches.FileContent(file2);
            }
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.removeDataFromIndicesForFile(fileId);
                if (file2 instanceof DeletedVirtualFileStub && ((DeletedVirtualFileStub)file2).isResurrected()) {
                    this.doIndexFileContent(project2, new com.intellij.ide.caches.FileContent(((DeletedVirtualFileStub)file2).getOriginalFile()));
                }
            } else {
                this.doIndexFileContent(project2, content2);
            }
        }
        finally {
            IndexingStamp.flushCache(fileId);
        }
        this.myChangedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
    }

    private void doIndexFileContent(@Nullable Project project2, @NotNull com.intellij.ide.caches.FileContent content2) {
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/indexing/FileBasedIndexImpl", "doIndexFileContent"));
        }
        VirtualFile file2 = content2.getVirtualFile();
        FileType fileType = file2.getFileType();
        Project finalProject = project2 == null ? ProjectUtil.guessProjectForFile((VirtualFile)file2) : project2;
        this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, () -> {
            if (content2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/indexing/FileBasedIndexImpl", "lambda$doIndexFileContent$18"));
            }
            PsiFile psiFile = null;
            FileContentImpl fc2 = null;
            int inputId = -1;
            List<ID<?, ?>> affectedIndexCandidates = this.getAffectedIndexCandidates(file2);
            int size = affectedIndexCandidates.size();
            for (int i2 = 0; i2 < size; ++i2) {
                ID<?, ?> indexId = affectedIndexCandidates.get(i2);
                if (!this.shouldIndexFile(file2, indexId)) continue;
                if (fc2 == null) {
                    byte[] currentBytes;
                    try {
                        currentBytes = content2.getBytes();
                    }
                    catch (IOException e2) {
                        currentBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
                    }
                    fc2 = new FileContentImpl(file2, currentBytes);
                    if (IdIndex.ourSnapshotMappingsEnabled) {
                        FileType substituteFileType = SubstitutedFileType.substituteFileType(file2, fileType, finalProject);
                        byte[] hash = fileType.isBinary() ? ContentHashesSupport.calcContentHash(currentBytes, substituteFileType) : ContentHashesSupport.calcContentHashWithFileType(currentBytes, fc2.getCharset(), substituteFileType);
                        fc2.setHash(hash);
                    }
                    psiFile = (PsiFile)content2.getUserData(IndexingDataKeys.PSI_FILE);
                    FileBasedIndexImpl.initFileContent(fc2, finalProject, psiFile);
                    inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)file2));
                }
                try {
                    ProgressManager.checkCanceled();
                    this.updateSingleIndex(indexId, file2, inputId, fc2);
                    continue;
                }
                catch (ProcessCanceledException e3) {
                    FileBasedIndexImpl.cleanFileContent(fc2, psiFile);
                    throw e3;
                }
            }
            if (psiFile != null) {
                psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
            }
        });
    }

    public boolean isIndexingCandidate(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "isIndexingCandidate"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "isIndexingCandidate"));
        }
        return !this.isTooLarge(file2) && this.getAffectedIndexCandidates(file2).contains(indexId);
    }

    @NotNull
    private List<ID<?, ?>> getAffectedIndexCandidates(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "getAffectedIndexCandidates"));
        }
        if (file2.isDirectory()) {
            List<Object> list2 = FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, null) ? Collections.emptyList() : this.myIndicesForDirectories;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getAffectedIndexCandidates"));
            }
            return list2;
        }
        FileType fileType = file2.getFileType();
        if (FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, fileType)) {
            List<ID<?, ?>> list3 = Collections.emptyList();
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getAffectedIndexCandidates"));
            }
            return list3;
        }
        List<ID<?, ?>> list4 = this.getState().getFileTypesForIndex(fileType);
        if (list4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "getAffectedIndexCandidates"));
        }
        return list4;
    }

    private static void cleanFileContent(@NotNull FileContentImpl fc2, PsiFile psiFile) {
        if (fc2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fc", "com/intellij/util/indexing/FileBasedIndexImpl", "cleanFileContent"));
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
        }
        fc2.putUserData(IndexingDataKeys.PSI_FILE, null);
    }

    private static void initFileContent(@NotNull FileContentImpl fc2, Project project2, PsiFile psiFile) {
        if (fc2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fc", "com/intellij/util/indexing/FileBasedIndexImpl", "initFileContent"));
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
            fc2.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
        }
        fc2.putUserData(IndexingDataKeys.PROJECT, project2);
    }

    private void updateSingleIndex(@NotNull ID<?, ?> indexId, VirtualFile file2, int inputId, @Nullable FileContent currentFC) {
        boolean hasContent;
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "updateSingleIndex"));
        }
        if (!RebuildStatus.isOk(indexId) && !this.myIsUnitTestMode) {
            return;
        }
        ++this.myLocalModCount;
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        assert (index != null);
        boolean bl = hasContent = currentFC != null;
        if (hasContent && currentFC.getUserData(ourPhysicalContentKey) == null) {
            currentFC.putUserData(ourPhysicalContentKey, (Object)Boolean.TRUE);
        }
        boolean updateCalculated = false;
        try {
            Computable update2 = index.update(inputId, currentFC);
            updateCalculated = true;
            this.scheduleUpdate(indexId, (Computable<Boolean>)update2, file2, inputId, hasContent);
        }
        catch (RuntimeException exception) {
            Throwable causeToRebuildIndex = FileBasedIndexImpl.getCauseToRebuildIndex(exception);
            if (causeToRebuildIndex != null && (updateCalculated || causeToRebuildIndex instanceof IOException)) {
                this.requestRebuild(indexId, exception);
                return;
            }
            throw exception;
        }
    }

    private void forceUpdate(@Nullable Project project2, @Nullable GlobalSearchScope filter2, @Nullable VirtualFile restrictedTo) {
        Collection<VirtualFile> allFilesToUpdate = this.myChangedFilesCollector.getAllFilesToUpdate();
        if (!allFilesToUpdate.isEmpty()) {
            boolean includeFilesFromOtherProjects = restrictedTo == null && (this.myForceUpdateRequests.incrementAndGet() & 0x3F) == 0;
            List virtualFilesToBeUpdatedForProject = ContainerUtil.filter(allFilesToUpdate, (Condition)new ProjectFilesCondition(this.projectIndexableFiles(project2), filter2, restrictedTo, includeFilesFromOtherProjects));
            if (!virtualFilesToBeUpdatedForProject.isEmpty()) {
                this.myForceUpdateTask.processAll(virtualFilesToBeUpdatedForProject, project2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUpdate(@NotNull ID<?, ?> indexId, Computable<Boolean> update2, VirtualFile file2, int inputId, boolean hasContent) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "scheduleUpdate"));
        }
        if (this.updateWithBufferingEnabled(update2)) {
            this.myReadLock.lock();
            try {
                this.indexedStampUpdate(indexId, file2, inputId, hasContent);
            }
            finally {
                this.myReadLock.unlock();
            }
        }
    }

    private void indexedStampUpdate(@NotNull ID<?, ?> indexId, @Nullable VirtualFile file2, int fileId, boolean hasContent) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "indexedStampUpdate"));
        }
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        if (hasContent) {
            index.setIndexedStateForFile(fileId, file2);
        } else {
            index.resetIndexedStateForFile(fileId);
        }
        if (this.myNotRequiringContentIndices.contains(indexId)) {
            IndexingStamp.flushCache(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateWithBufferingEnabled(@NotNull Computable<Boolean> update2) {
        if (update2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/intellij/util/indexing/FileBasedIndexImpl", "updateWithBufferingEnabled"));
        }
        StorageGuard.StorageModeExitHandler lock = this.setDataBufferingEnabled(false);
        try {
            boolean bl = (Boolean)update2.compute();
            return bl;
        }
        finally {
            lock.leave();
        }
    }

    private boolean needsFileContentLoading(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "needsFileContentLoading"));
        }
        return !this.myNotRequiringContentIndices.contains(indexId);
    }

    @Nullable
    private IndexableFileSet getIndexableSetForFile(VirtualFile file2) {
        for (IndexableFileSet set2 : this.myIndexableSets) {
            if (!set2.isInSet(file2)) continue;
            return set2;
        }
        return null;
    }

    private void doInvalidateIndicesForFile(int fileId, @NotNull VirtualFile file2, boolean contentChanged) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "doInvalidateIndicesForFile"));
        }
        this.waitUntilIndicesAreInitialized();
        FileBasedIndexImpl.cleanProcessedFlag(file2);
        IndexingStamp.flushCache(fileId);
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        if (!contentChanged) {
            for (ID<?, ?> indexId : nontrivialFileIndexedStates) {
                if (!this.myNotRequiringContentIndices.contains(indexId)) continue;
                this.updateSingleIndex(indexId, null, fileId, null);
            }
            this.myChangedFilesCollector.removeScheduledFileFromUpdate(file2);
        }
        Collection fileIndexedStatesToUpdate = ContainerUtil.intersection(nontrivialFileIndexedStates, this.myRequiringContentIndices);
        if (contentChanged) {
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                int size = nontrivialFileIndexedStates.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    ID<?, ?> indexId = nontrivialFileIndexedStates.get(i2);
                    if (!this.needsFileContentLoading(indexId)) continue;
                    this.getIndex(indexId).resetIndexedStateForFile(fileId);
                }
                this.clearUpToDateStateForPsiIndicesOfUnsavedDocuments(file2);
                if (file2.isValid() && !this.isTooLarge(file2)) {
                    this.myChangedFilesCollector.scheduleForUpdate(file2);
                }
            }
        } else if (!fileIndexedStatesToUpdate.isEmpty()) {
            this.myChangedFilesCollector.scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
        }
        IndexingStamp.flushCache(fileId);
    }

    private void scheduleFileForIndexing(int fileId, VirtualFile file2, boolean contentChange) {
        boolean fileIsDirectory = file2.isDirectory();
        if (!contentChange) {
            FileContentImpl fileContent = null;
            for (ID<?, ?> indexId : fileIsDirectory ? this.myIndicesForDirectories : this.myNotRequiringContentIndices) {
                if (!this.getInputFilter(indexId).acceptInput(file2)) continue;
                if (fileContent == null) {
                    fileContent = new FileContentImpl(file2);
                    if (fileId < 0) {
                        fileId = -fileId;
                    }
                }
                this.updateSingleIndex(indexId, file2, fileId, fileContent);
            }
        }
        if (!fileIsDirectory) {
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.myChangedFilesCollector.removeScheduledFileFromUpdate(file2);
            } else {
                int finalFileId = fileId;
                this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, () -> {
                    List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(file2);
                    boolean scheduleForUpdate = false;
                    int size = candidates.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        ID<?, ?> indexId = candidates.get(i2);
                        if (!this.needsFileContentLoading(indexId) || !this.getInputFilter(indexId).acceptInput(file2)) continue;
                        this.getIndex(indexId).resetIndexedStateForFile(finalFileId);
                        scheduleForUpdate = true;
                    }
                    if (scheduleForUpdate) {
                        IndexingStamp.flushCache(finalFileId);
                        this.myChangedFilesCollector.scheduleForUpdate(file2);
                    }
                    if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
                        this.clearUpToDateStateForPsiIndicesOfUnsavedDocuments(file2);
                    }
                });
            }
        }
    }

    private boolean clearUpToDateStateForPsiIndicesOfUnsavedDocuments(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "clearUpToDateStateForPsiIndicesOfUnsavedDocuments"));
        }
        Document document = this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null && this.myFileDocumentManager.isDocumentUnsaved(document)) {
            if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
                for (ID<?, ?> psiBackedIndex : this.myPsiDependentIndices) {
                    this.myUpToDateIndicesForUnsavedOrTransactedDocuments.remove(psiBackedIndex);
                }
            }
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
            return true;
        }
        return false;
    }

    static int getIdMaskingNonIdBasedFile(VirtualFile file2) {
        return file2 instanceof VirtualFileWithId ? ((VirtualFileWithId)file2).getId() : 0;
    }

    private boolean shouldIndexFile(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "shouldIndexFile"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/FileBasedIndexImpl", "shouldIndexFile"));
        }
        return this.getInputFilter(indexId).acceptInput(file2) && (FileBasedIndexImpl.isMock(file2) || !this.getIndex(indexId).isIndexedStateForFile(((NewVirtualFile)file2).getId(), file2));
    }

    static boolean isMock(VirtualFile file2) {
        return !(file2 instanceof NewVirtualFile);
    }

    private boolean isTooLarge(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "isTooLarge"));
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2)) {
            return !this.myNoLimitCheckTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
        }
        return false;
    }

    private boolean isTooLarge(@NotNull VirtualFile file2, long contentSize) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "isTooLarge"));
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2, contentSize)) {
            return !this.myNoLimitCheckTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2, contentSize);
        }
        return false;
    }

    @NotNull
    CollectingContentIterator createContentIterator(@Nullable ProgressIndicator indicator) {
        UnindexedFilesFinder unindexedFilesFinder = new UnindexedFilesFinder(indicator);
        if (unindexedFilesFinder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "createContentIterator"));
        }
        return unindexedFilesFinder;
    }

    public void registerIndexableSet(@NotNull IndexableFileSet set2, @Nullable Project project2) {
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/util/indexing/FileBasedIndexImpl", "registerIndexableSet"));
        }
        this.myIndexableSets.add(set2);
        this.myIndexableSetToProjectMap.put(set2, project2);
        if (project2 != null) {
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).addTreeChangePreprocessor(event -> {
                PsiFile file2;
                if (event.isGenericChange() && event.getCode() == PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED && (file2 = event.getFile()) != null) {
                    this.waitUntilIndicesAreInitialized();
                    VirtualFile virtualFile = file2.getVirtualFile();
                    if (!this.clearUpToDateStateForPsiIndicesOfUnsavedDocuments(virtualFile) && virtualFile instanceof VirtualFileWithId) {
                        int fileId = ((VirtualFileWithId)virtualFile).getId();
                        boolean wasIndexed = false;
                        List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(virtualFile);
                        for (ID<?, ?> psiBackedIndex : this.myPsiDependentIndices) {
                            if (!candidates.contains(psiBackedIndex) || !this.getInputFilter(psiBackedIndex).acceptInput(virtualFile)) continue;
                            this.getIndex(psiBackedIndex).resetIndexedStateForFile(fileId);
                            wasIndexed = true;
                        }
                        if (wasIndexed) {
                            this.myChangedFilesCollector.scheduleForUpdate(virtualFile);
                            IndexingStamp.flushCache(fileId);
                        }
                    }
                }
            });
        }
    }

    public void removeIndexableSet(@NotNull IndexableFileSet set2) {
        if (set2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/util/indexing/FileBasedIndexImpl", "removeIndexableSet"));
        }
        if (!this.myIndexableSetToProjectMap.containsKey(set2)) {
            return;
        }
        this.myIndexableSets.remove(set2);
        this.myIndexableSetToProjectMap.remove(set2);
        for (VirtualFile file2 : this.myChangedFilesCollector.getAllFilesToUpdate()) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            if (!file2.isValid()) {
                this.removeDataFromIndicesForFile(fileId);
                this.myChangedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
                continue;
            }
            if (this.getIndexableSetForFile(file2) != null) continue;
            this.myChangedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
        }
        IndexingStamp.flushCaches();
    }

    public VirtualFile findFileById(Project project2, int id) {
        return IndexInfrastructure.findFileById((PersistentFS)ManagingFS.getInstance(), id);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(@NotNull Document doc, @NotNull Project project2) {
        if (doc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "doc", "com/intellij/util/indexing/FileBasedIndexImpl", "findLatestKnownPsiForUncomittedDocument"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexImpl", "findLatestKnownPsiForUncomittedDocument"));
        }
        return PsiDocumentManager.getInstance((Project)project2).getCachedPsiFile(doc);
    }

    private static void cleanupProcessedFlag() {
        VirtualFile[] roots;
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots()) {
            FileBasedIndexImpl.cleanProcessedFlag(root);
        }
    }

    private static void cleanProcessedFlag(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl", "cleanProcessedFlag"));
        }
        if (!(file2 instanceof VirtualFileSystemEntry)) {
            return;
        }
        VirtualFileSystemEntry nvf = (VirtualFileSystemEntry)file2;
        if (file2.isDirectory()) {
            nvf.setFileIndexed(false);
            for (VirtualFile child : nvf.getCachedChildren()) {
                FileBasedIndexImpl.cleanProcessedFlag(child);
            }
        } else {
            nvf.setFileIndexed(false);
        }
    }

    public void iterateIndexableFilesConcurrently(@NotNull ContentIterator processor2, @NotNull Project project2, ProgressIndicator indicator) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "iterateIndexableFilesConcurrently"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexImpl", "iterateIndexableFilesConcurrently"));
        }
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(FileBasedIndexImpl.collectScanRootRunnables(processor2, project2, indicator));
    }

    public void iterateIndexableFiles(@NotNull ContentIterator processor2, @NotNull Project project2, ProgressIndicator indicator) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "iterateIndexableFiles"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexImpl", "iterateIndexableFiles"));
        }
        for (Runnable r2 : FileBasedIndexImpl.collectScanRootRunnables(processor2, project2, indicator)) {
            r2.run();
        }
    }

    @NotNull
    private static List<Runnable> collectScanRootRunnables(@NotNull ContentIterator processor2, @NotNull Project project2, ProgressIndicator indicator) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/util/indexing/FileBasedIndexImpl", "collectScanRootRunnables"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/indexing/FileBasedIndexImpl", "collectScanRootRunnables"));
        }
        FileBasedIndexScanRunnableCollector collector = FileBasedIndexScanRunnableCollector.getInstance(project2);
        List<Runnable> list2 = collector.collectScanRootRunnables(processor2, indicator);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl", "collectScanRootRunnables"));
        }
        return list2;
    }

    private static /* synthetic */ boolean lambda$getContainingFiles$5(Set files2, VirtualFile file2, Object value2) {
        files2.add(file2);
        return true;
    }

    private static /* synthetic */ boolean lambda$getValues$4(List values, VirtualFile file2, Object value2) {
        values.add(value2);
        return true;
    }

    private static /* synthetic */ void lambda$initIndexStorage$0(Set addedTypes, FileType type) {
        if (type != null) {
            addedTypes.add(type);
        }
    }

    private class FileIndexDataInitialization
    extends IndexInfrastructure.DataInitialization<IndexConfiguration> {
        private final IndexConfiguration state = new IndexConfiguration();
        private final AtomicBoolean versionChanged = new AtomicBoolean();
        private boolean currentVersionCorrupted;
        private SerializationManagerEx mySerializationManagerEx;

        FileIndexDataInitialization(FileBasedIndexExtension[] extensions) {
            for (FileBasedIndexExtension extension : extensions) {
                ID name = extension.getName();
                RebuildStatus.registerIndex(name);
                FileBasedIndexImpl.this.myUnsavedDataUpdateTasks.put(name, new DocumentUpdateTask(name));
                if (!extension.dependsOnFileContent()) {
                    if (extension.indexDirectories()) {
                        FileBasedIndexImpl.this.myIndicesForDirectories.add(name);
                    }
                    FileBasedIndexImpl.this.myNotRequiringContentIndices.add(name);
                } else {
                    FileBasedIndexImpl.this.myRequiringContentIndices.add(name);
                }
                if (extension instanceof PsiDependentIndex) {
                    FileBasedIndexImpl.this.myPsiDependentIndices.add(name);
                }
                FileBasedIndexImpl.this.myNoLimitCheckTypes.addAll(extension.getFileTypesWithSizeLimitNotApplicable());
                this.addNestedInitializationTask(() -> {
                    try {
                        this.versionChanged.compareAndSet(false, FileBasedIndexImpl.registerIndexer(extension, this.state));
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (Throwable t2) {
                        PluginManager.handleComponentError(t2, extension.getClass().getName(), null);
                    }
                });
            }
        }

        @Override
        protected void prepare() {
            this.mySerializationManagerEx = SerializationManagerEx.getInstanceEx();
            File indexRoot = PathManager.getIndexRoot();
            File corruptionMarker = new File(indexRoot, FileBasedIndexImpl.CORRUPTION_MARKER_NAME);
            this.currentVersionCorrupted = corruptionMarker.exists();
            if (this.currentVersionCorrupted) {
                FileUtil.deleteWithRenaming((File)indexRoot);
                indexRoot.mkdirs();
                this.mySerializationManagerEx.reinitializeNameStorage();
                ID.reinitializeDiskStorage();
            }
            FileUtil.delete((File)corruptionMarker);
        }

        @Override
        protected void onThrowable(Throwable t2) {
            LOG.error(t2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IndexConfiguration finish() {
            IndexConfiguration indexConfiguration;
            try {
                this.state.finalizeFileTypeMappingForIndices();
                String rebuildNotification = null;
                if (this.currentVersionCorrupted) {
                    rebuildNotification = "Index files on disk are corrupted. Indices will be rebuilt.";
                } else if (this.versionChanged.get()) {
                    rebuildNotification = "Index file format has changed for some indices. These indices will be rebuilt.";
                }
                if (rebuildNotification != null && !ApplicationManager.getApplication().isHeadlessEnvironment() && Registry.is((String)"ide.showIndexRebuildMessage")) {
                    NOTIFICATIONS.createNotification("Index Rebuild", rebuildNotification, NotificationType.INFORMATION, null).notify(null);
                }
                this.state.freeze();
                FileBasedIndexImpl.this.myState = this.state;
                for (ID<?, ?> indexId : this.state.getIndexIDs()) {
                    try {
                        RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<StorageException>)((ThrowableRunnable)() -> FileBasedIndexImpl.this.clearIndex(indexId)));
                    }
                    catch (StorageException e2) {
                        FileBasedIndexImpl.this.requestRebuild(indexId);
                        LOG.error((Throwable)e2);
                    }
                }
                FileBasedIndexImpl.this.registerIndexableSet(new AdditionalIndexableFileSet(), null);
                indexConfiguration = this.state;
            }
            catch (Throwable throwable) {
                ShutDownTracker.getInstance().registerShutdownTask(() -> FileBasedIndexImpl.this.performShutdown());
                FileBasedIndexImpl.saveRegisteredIndicesAndDropUnregisteredOnes(this.state.getIndexIDs());
                FileBasedIndexImpl.this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
                    private int lastModCount;

                    @Override
                    public void run() {
                        FileIndexDataInitialization.this.mySerializationManagerEx.flushNameStorage();
                        if (this.lastModCount == FileBasedIndexImpl.this.myLocalModCount) {
                            FileBasedIndexImpl.this.flushAllIndices(this.lastModCount);
                        }
                        this.lastModCount = FileBasedIndexImpl.this.myLocalModCount;
                    }
                });
                FileBasedIndexImpl.this.myInitialized = true;
                FileBasedIndexImpl.this.myChangedFilesCollector.ensureUpToDateAsync();
                throw throwable;
            }
            ShutDownTracker.getInstance().registerShutdownTask(() -> FileBasedIndexImpl.this.performShutdown());
            FileBasedIndexImpl.saveRegisteredIndicesAndDropUnregisteredOnes(this.state.getIndexIDs());
            FileBasedIndexImpl.this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new /* invalid duplicate definition of identical inner class */);
            FileBasedIndexImpl.this.myInitialized = true;
            FileBasedIndexImpl.this.myChangedFilesCollector.ensureUpToDateAsync();
            return indexConfiguration;
        }
    }

    private final class DocumentUpdateTask
    extends UpdateTask<Document> {
        private final ID<?, ?> myIndexId;

        DocumentUpdateTask(ID<?, ?> indexId) {
            this.myIndexId = indexId;
        }

        @Override
        void doProcess(Document document, Project project2) {
            FileBasedIndexImpl.this.indexUnsavedDocument(document, this.myIndexId, project2, FileBasedIndexImpl.this.myFileDocumentManager.getFile(document));
        }
    }

    private class UnindexedFilesFinder
    implements CollectingContentIterator {
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        @Nullable
        private final ProgressIndicator myProgressIndicator;

        private UnindexedFilesFinder(ProgressIndicator indicator) {
            this.myProgressIndicator = indicator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public List<VirtualFile> getFiles() {
            List<VirtualFile> files2;
            List<VirtualFile> list2 = this.myFiles;
            synchronized (list2) {
                files2 = this.myFiles;
            }
            BitSet usedFileIds = new BitSet(files2.size());
            ArrayList<VirtualFile> localFileSystemFiles = new ArrayList<VirtualFile>(files2.size() / 2);
            ArrayList<VirtualFile> archiveFiles = new ArrayList<VirtualFile>(files2.size() / 2);
            for (VirtualFile file2 : files2) {
                int fileId = ((VirtualFileWithId)file2).getId();
                if (fileId > 0) {
                    if (usedFileIds.get(fileId)) continue;
                    usedFileIds.set(fileId);
                }
                if (file2.getFileSystem() instanceof LocalFileSystem) {
                    localFileSystemFiles.add(file2);
                    continue;
                }
                archiveFiles.add(file2);
            }
            localFileSystemFiles.addAll(archiveFiles);
            ArrayList<VirtualFile> arrayList = localFileSystemFiles;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$UnindexedFilesFinder", "getFiles"));
            }
            return arrayList;
        }

        public boolean processFile(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$UnindexedFilesFinder", "processFile"));
            }
            if (!file2.isValid()) {
                return true;
            }
            if (file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed()) {
                return true;
            }
            if (!(file2 instanceof VirtualFileWithId)) {
                return true;
            }
            FileBasedIndexImpl.this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, () -> {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$UnindexedFilesFinder", "lambda$processFile$0"));
                }
                boolean oldStuff = true;
                if (file2.isDirectory() || !FileBasedIndexImpl.this.isTooLarge(file2)) {
                    List affectedIndexCandidates = FileBasedIndexImpl.this.getAffectedIndexCandidates(file2);
                    int size = affectedIndexCandidates.size();
                    for (int i2 = 0; i2 < size; ++i2) {
                        ID indexId = (ID)affectedIndexCandidates.get(i2);
                        try {
                            if (!FileBasedIndexImpl.this.needsFileContentLoading(indexId) || !FileBasedIndexImpl.this.shouldIndexFile(file2, indexId)) continue;
                            List<VirtualFile> list2 = this.myFiles;
                            synchronized (list2) {
                                this.myFiles.add(file2);
                            }
                            oldStuff = false;
                            break;
                        }
                        catch (RuntimeException e2) {
                            Throwable cause = e2.getCause();
                            if (cause instanceof IOException || cause instanceof StorageException) {
                                LOG.info((Throwable)e2);
                                FileBasedIndexImpl.this.requestRebuild(indexId);
                                continue;
                            }
                            throw e2;
                        }
                    }
                }
                FileContentImpl fileContent = null;
                int inputId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
                for (ID indexId : FileBasedIndexImpl.this.myNotRequiringContentIndices) {
                    if (!FileBasedIndexImpl.this.shouldIndexFile(file2, indexId)) continue;
                    oldStuff = false;
                    if (fileContent == null) {
                        fileContent = new FileContentImpl(file2);
                    }
                    FileBasedIndexImpl.this.updateSingleIndex(indexId, file2, inputId, fileContent);
                }
                IndexingStamp.flushCache(inputId);
                if (oldStuff && file2 instanceof VirtualFileSystemEntry) {
                    ((VirtualFileSystemEntry)file2).setFileIndexed(true);
                }
            });
            if (this.myProgressIndicator != null && file2.isDirectory()) {
                this.myProgressIndicator.checkCanceled();
                this.myProgressIndicator.setText("Scanning files to index");
            }
            return true;
        }
    }

    private final class ChangedFilesCollector
    extends IndexedFilesListener {
        private final ConcurrentIntObjectMap<VirtualFile> myFilesToUpdate = ContainerUtil.createConcurrentIntObjectMap();
        private final VfsEventsMerger myVfsEventsMerger = new VfsEventsMerger();
        private final Phaser myWorkersFinishedSync = new Phaser(){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                return false;
            }
        };
        private final ExecutorService myVfsEventsExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"vfs event processor", (int)1);
        private final AtomicInteger myScheduledVfsEventsWorkers = new AtomicInteger();

        private ChangedFilesCollector() {
        }

        @Override
        protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "buildIndicesForFileRecursively"));
            }
            FileBasedIndexImpl.cleanProcessedFlag(file2);
            if (!contentChange) {
                FileBasedIndexImpl.this.myUpdatingFiles.incrementAndGet();
            }
            super.buildIndicesForFileRecursively(file2, contentChange);
            IndexingStamp.flushCaches();
            if (!contentChange && FileBasedIndexImpl.this.myUpdatingFiles.decrementAndGet() == 0) {
                ++FileBasedIndexImpl.this.myFilesModCount;
            }
        }

        @Override
        protected void iterateIndexableFiles(VirtualFile file2, ContentIterator iterator2) {
            for (IndexableFileSet set2 : FileBasedIndexImpl.this.myIndexableSets) {
                if (!set2.isInSet(file2)) continue;
                set2.iterateIndexableFilesIn(file2, iterator2);
            }
        }

        @Override
        protected void buildIndicesForFile(VirtualFile file2, boolean contentChange) {
            int fileId = FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2);
            this.myVfsEventsMerger.recordFileEvent(fileId, file2, contentChange);
        }

        @Override
        protected void doInvalidateIndicesForFile(VirtualFile file2, boolean contentChange) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            this.myVfsEventsMerger.recordBeforeFileEvent(fileId, file2, contentChange);
        }

        void scheduleForUpdate(VirtualFile file2) {
            IndexableFileSet setForFile;
            if (!(file2 instanceof DeletedVirtualFileStub) && (setForFile = FileBasedIndexImpl.this.getIndexableSetForFile(file2)) == null) {
                return;
            }
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.put(fileId, (Object)file2);
            if (previousVirtualFile instanceof DeletedVirtualFileStub && !previousVirtualFile.equals(file2)) {
                assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
                ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(true);
                this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
            }
        }

        private void removeScheduledFileFromUpdate(VirtualFile file2) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.remove(fileId);
            if (previousVirtualFile instanceof DeletedVirtualFileStub) {
                assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
                ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(false);
                this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
            }
        }

        private void removeFileIdFromFilesScheduledForUpdate(int fileId) {
            this.myFilesToUpdate.remove(fileId);
        }

        Collection<VirtualFile> getAllFilesToUpdate() {
            this.ensureUpToDate();
            if (this.myFilesToUpdate.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<VirtualFile>(this.myFilesToUpdate.values());
        }

        @Override
        public void before(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "before"));
            }
            for (VFileEvent vFileEvent : events) {
                if (!this.memoryStorageCleaningNeeded(vFileEvent)) continue;
                FileBasedIndexImpl.this.cleanupMemoryStorage();
                break;
            }
            super.before(events);
        }

        private boolean memoryStorageCleaningNeeded(VFileEvent event) {
            Object requestor = event.getRequestor();
            return requestor instanceof FileDocumentManager || requestor instanceof PsiManager || requestor == LocalHistory.VFS_EVENT_REQUESTOR;
        }

        @Override
        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/indexing/FileBasedIndexImpl$ChangedFilesCollector", "after"));
            }
            super.after(events);
            if (FileBasedIndexImpl.this.myInitialized) {
                this.ensureUpToDateAsync();
            }
        }

        boolean isScheduledForUpdate(VirtualFile file2) {
            return this.myFilesToUpdate.containsKey(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2)));
        }

        public void ensureUpToDate() {
            FileBasedIndexImpl.this.waitUntilIndicesAreInitialized();
            ApplicationManager.getApplication().runReadAction(this::processFilesInReadAction);
        }

        void ensureUpToDateAsync() {
            if (this.myVfsEventsMerger.getApproximateChangesCount() >= 20 && this.myScheduledVfsEventsWorkers.get() == 0 && !PowerSaveMode.isEnabled()) {
                this.myScheduledVfsEventsWorkers.incrementAndGet();
                this.myVfsEventsExecutor.submit(this::processFilesInReadActionWithYieldingToWriteAction);
            }
        }

        int getChangedFileCount() {
            return this.myVfsEventsMerger.getApproximateChangesCount() + this.myFilesToUpdate.size();
        }

        private void processFilesInReadAction() {
            assert (ApplicationManager.getApplication().isReadAccessAllowed());
            this.myWorkersFinishedSync.register();
            int phase = this.myWorkersFinishedSync.getPhase();
            try {
                this.myVfsEventsMerger.processChanges(info -> {
                    FileBasedIndexImpl.this.myWriteLock.lock();
                    try {
                        ProgressManager.getInstance().executeNonCancelableSection(() -> {
                            int fileId = info.getFileId();
                            VirtualFile file2 = info.getFile();
                            if (info.isBeforeContentChanged()) {
                                FileBasedIndexImpl.this.doInvalidateIndicesForFile(fileId, file2, true);
                            }
                            if (info.isContentChanged()) {
                                FileBasedIndexImpl.this.scheduleFileForIndexing(fileId, file2, true);
                            }
                            if (info.isFileRemoved()) {
                                FileBasedIndexImpl.this.doInvalidateIndicesForFile(fileId, file2, false);
                            }
                            if (info.isFileAdded()) {
                                FileBasedIndexImpl.this.scheduleFileForIndexing(fileId, file2, false);
                            }
                        });
                    }
                    finally {
                        FileBasedIndexImpl.this.myWriteLock.unlock();
                    }
                    return true;
                });
            }
            finally {
                this.myWorkersFinishedSync.arriveAndDeregister();
            }
            this.myWorkersFinishedSync.awaitAdvance(phase);
        }

        private void processFilesInReadActionWithYieldingToWriteAction() {
            try {
                while (this.myVfsEventsMerger.hasChanges()) {
                    ProgressManager.getInstance().runInReadActionWithWriteActionPriority(this::processFilesInReadAction);
                }
            }
            finally {
                this.myScheduledVfsEventsWorkers.decrementAndGet();
            }
        }
    }

    private class VirtualFileUpdateTask
    extends UpdateTask<VirtualFile> {
        private VirtualFileUpdateTask() {
        }

        @Override
        void doProcess(VirtualFile item, Project project2) {
            FileBasedIndexImpl.this.processRefreshedFile(project2, new com.intellij.ide.caches.FileContent(item));
        }
    }

    private static class PsiContent
    implements DocumentContent {
        private final Document myDocument;
        private final PsiFile myFile;

        private PsiContent(Document document, PsiFile file2) {
            this.myDocument = document;
            this.myFile = file2;
        }

        @Override
        public CharSequence getText() {
            if (this.myFile.getViewProvider().getModificationStamp() != this.myDocument.getModificationStamp()) {
                FileASTNode node = this.myFile.getNode();
                assert (node != null);
                return node.getChars();
            }
            return this.myDocument.getImmutableCharSequence();
        }

        @Override
        public long getModificationStamp() {
            return this.myFile.getViewProvider().getModificationStamp();
        }
    }

    private static class AuthenticContent
    implements DocumentContent {
        private final Document myDocument;

        private AuthenticContent(Document document) {
            this.myDocument = document;
        }

        @Override
        public CharSequence getText() {
            return this.myDocument.getImmutableCharSequence();
        }

        @Override
        public long getModificationStamp() {
            return this.myDocument.getModificationStamp();
        }
    }

    private static interface DocumentContent {
        public CharSequence getText();

        public long getModificationStamp();
    }

    public static final class ProjectIndexableFilesFilter
    extends IdFilter {
        private static final int SHIFT = 6;
        private static final int MASK = 63;
        private final long[] myBitMask;
        private final int myModificationCount;
        private final int myMinId;
        private final int myMaxId;

        private ProjectIndexableFilesFilter(@NotNull TIntArrayList set2, int modificationCount) {
            if (set2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/util/indexing/FileBasedIndexImpl$ProjectIndexableFilesFilter", "<init>"));
            }
            this.myModificationCount = modificationCount;
            int[] minMax = new int[2];
            if (!set2.isEmpty()) {
                minMax[0] = minMax[1] = set2.get(0);
            }
            set2.forEach(value2 -> {
                if (value2 < 0) {
                    value2 = -value2;
                }
                minMax[0] = Math.min(minMax[0], value2);
                minMax[1] = Math.max(minMax[1], value2);
                return true;
            });
            this.myMaxId = minMax[1];
            this.myMinId = minMax[0];
            this.myBitMask = new long[(this.myMaxId - this.myMinId >> 6) + 1];
            set2.forEach(value2 -> {
                if (value2 < 0) {
                    value2 = -value2;
                }
                int n2 = (value2 -= this.myMinId) >> 6;
                this.myBitMask[n2] = this.myBitMask[n2] | 1L << (value2 & 0x3F);
                return true;
            });
        }

        public boolean containsFileId(int id) {
            if (id < this.myMinId) {
                return false;
            }
            if (id > this.myMaxId) {
                return false;
            }
            return (this.myBitMask[(id -= this.myMinId) >> 6] & 1L << (id & 0x3F)) != 0L;
        }
    }

    @FunctionalInterface
    public static interface IdValueProcessor<V> {
        public boolean process(int var1, V var2);
    }
}

