/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.indexing.ID;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PerIndexDocumentVersionMap {
    private static final int INVALID_STAMP = -1;
    private volatile int mapVersion;
    private static final Key<List<IdVersionInfo>> KEY = Key.create((String)"UnsavedDocIdVersionInfo");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long set(@NotNull Document document, @NotNull ID<?, ?> indexId, long value2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/indexing/PerIndexDocumentVersionMap", "set"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/PerIndexDocumentVersionMap", "set"));
        }
        List list2 = (List)document.getUserData(KEY);
        if (list2 == null) {
            list2 = (List)((UserDataHolderEx)document).putUserDataIfAbsent(KEY, new ArrayList());
        }
        List list3 = list2;
        synchronized (list3) {
            for (IdVersionInfo info : list2) {
                if (info.id != indexId) continue;
                long old = info.docVersion;
                if (info.mapVersion != this.mapVersion) {
                    old = -1L;
                    info.mapVersion = this.mapVersion;
                }
                info.docVersion = value2;
                return old;
            }
            list2.add(new IdVersionInfo(indexId, value2, this.mapVersion));
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get(@NotNull Document document, @NotNull ID<?, ?> indexId) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/indexing/PerIndexDocumentVersionMap", "get"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/PerIndexDocumentVersionMap", "get"));
        }
        List list2 = (List)document.getUserData(KEY);
        if (list2 == null) {
            return -1L;
        }
        List list3 = list2;
        synchronized (list3) {
            for (IdVersionInfo info : list2) {
                if (info.id != indexId) continue;
                long old = info.docVersion;
                if (info.mapVersion != this.mapVersion) {
                    return -1L;
                }
                return old;
            }
            return -1L;
        }
    }

    public void clearForDocument(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/util/indexing/PerIndexDocumentVersionMap", "clearForDocument"));
        }
        document.putUserData(KEY, new ArrayList());
    }

    public void clear() {
        ++this.mapVersion;
    }

    private static class IdVersionInfo {
        private final ID<?, ?> id;
        private int mapVersion;
        private long docVersion;

        /*
         * WARNING - void declaration
         */
        private IdVersionInfo(@NotNull ID<?, ?> id, long docVersion, int n2) {
            void mapVersion;
            if (id == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/util/indexing/PerIndexDocumentVersionMap$IdVersionInfo", "<init>"));
            }
            this.docVersion = docVersion;
            this.mapVersion = mapVersion;
            this.id = id;
        }
    }
}

