/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntLongProcedure;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SharedIndicesData {
    private static final TIntIntHashMap ourRegisteredIndices = new TIntIntHashMap();
    private static IndexedStateMap ourSharedFileInputs;
    private static IndexedStateMap ourSharedFileContentIndependentInputs;
    private static IndexedStateMap ourSharedContentInputs;
    static final boolean ourFileSharedIndicesEnabled;
    static final boolean DO_CHECKS;
    private static final Logger LOG;
    private static final int CONTENTLESS = 1;
    private static final int CONTENTFUL = 2;

    public static void init() {
    }

    public static <Key, Value, Input> void registerIndex(ID<Key, Value> indexId, IndexExtension<Key, Value, Input> extension) {
        if (extension instanceof FileBasedIndexExtension) {
            boolean dependsOnFileContent = ((FileBasedIndexExtension)extension).dependsOnFileContent();
            ourRegisteredIndices.put(indexId.getUniqueId(), dependsOnFileContent ? 2 : 1);
        }
    }

    public static void flushData() {
        if (!ourFileSharedIndicesEnabled) {
            return;
        }
        ourSharedFileInputs.force();
        ourSharedContentInputs.force();
        ourSharedFileContentIndependentInputs.force();
    }

    public static void beforeSomeIndexVersionInvalidation() {
        SharedIndicesData.flushData();
    }

    public static boolean canReadIndexValueWithoutExtraBlocking(int contentId) {
        return !ourSharedContentInputs.isBusyReading();
    }

    private static void writeIndexValue(int indexUniqueId, long indexCreationStamp, byte[] indexValue, int indexValueOffset, int indexValueLength, DataOutput compactedOutput) throws IOException {
        DataInputOutputUtil.writeINT((DataOutput)compactedOutput, (int)indexValueLength);
        DataInputOutputUtil.writeINT((DataOutput)compactedOutput, (int)indexUniqueId);
        DataInputOutputUtil.writeTIME((DataOutput)compactedOutput, (long)indexCreationStamp);
        if (indexValue != null) {
            assert (indexValueLength > 0);
            compactedOutput.write(indexValue, indexValueOffset, indexValueLength);
        } else assert (indexValueLength == 0);
    }

    @Nullable
    public static <Key, Value> Value recallFileData(int id, ID<Key, ?> indexId, DataExternalizer<Value> externalizer) throws IOException {
        int type = ourRegisteredIndices.get(indexId.getUniqueId());
        if (type == 0) {
            return null;
        }
        IndexedStateMap states = type == 1 ? ourSharedFileContentIndependentInputs : ourSharedFileInputs;
        return SharedIndicesData.doRecallData(id, indexId, externalizer, states);
    }

    @Nullable
    public static <Key, Value> Value recallContentData(int id, ID<Key, ?> indexId, DataExternalizer<Value> externalizer) throws IOException {
        return SharedIndicesData.doRecallData(id, indexId, externalizer, ourSharedContentInputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <Key, Value> Value doRecallData(int id, ID<Key, ?> indexId, DataExternalizer<Value> externalizer, IndexedStateMap states) throws IOException {
        FileAccessorCache.Handle stateHandle = states.myStateCache.get(id);
        IndexedState indexedState = (IndexedState)stateHandle.get();
        try {
            DataInputStream in = indexedState.readIndexedState(indexId);
            if (in == null) {
                Value Value2 = null;
                return Value2;
            }
            Object object = externalizer.read((DataInput)in);
            return (Value)object;
        }
        finally {
            stateHandle.release();
        }
    }

    public static <Key, Value> void associateFileData(int id, ID<Key, ?> indexId, Value keys, DataExternalizer<Value> externalizer) throws IOException {
        int type = ourRegisteredIndices.get(indexId.getUniqueId());
        if (type == 0) {
            return;
        }
        boolean contentlessIndex = type == 1;
        SharedIndicesData.doAssociateData(id, indexId, keys, externalizer, contentlessIndex ? ourSharedFileContentIndependentInputs : ourSharedFileInputs);
    }

    public static <Key, Value> void associateContentData(int id, ID<Key, ?> indexId, Value keys, DataExternalizer<Value> externalizer) throws IOException {
        SharedIndicesData.doAssociateData(id, indexId, keys, externalizer, ourSharedContentInputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <Key, Value> void doAssociateData(int id, final ID<Key, ?> indexId, Value keys, DataExternalizer<Value> externalizer, IndexedStateMap index) throws IOException {
        BufferExposingByteArrayOutputStream savedKeysData;
        if (keys != null) {
            savedKeysData = new BufferExposingByteArrayOutputStream();
            externalizer.save((DataOutput)new DataOutputStream((OutputStream)savedKeysData), keys);
        } else {
            savedKeysData = null;
        }
        final FileAccessorCache.Handle stateHandle = index.myStateCache.getIfCached(id);
        try {
            index.appendData(id, new PersistentHashMap.ValueDataAppender(){

                public void append(DataOutput out) throws IOException {
                    IndexedState indexedState;
                    byte[] internalBuffer = null;
                    int size = 0;
                    if (savedKeysData != null) {
                        internalBuffer = savedKeysData.getInternalBuffer();
                        size = savedKeysData.size();
                    }
                    long indexCreationStamp = IndexingStamp.getIndexCreationStamp(indexId);
                    SharedIndicesData.writeIndexValue(indexId.getUniqueId(), indexCreationStamp, internalBuffer, 0, size, out);
                    IndexedState indexedState2 = indexedState = stateHandle != null ? (IndexedState)stateHandle.get() : null;
                    if (indexedState != null) {
                        indexedState.appendIndexedState(indexId, indexCreationStamp, internalBuffer, size);
                    }
                }
            });
        }
        finally {
            if (stateHandle != null) {
                stateHandle.release();
            }
        }
    }

    static {
        ourFileSharedIndicesEnabled = SystemProperties.getBooleanProperty((String)"idea.shared.input.index.enabled", (boolean)false);
        DO_CHECKS = ourFileSharedIndicesEnabled && SystemProperties.getBooleanProperty((String)"idea.shared.input.index.checked", (boolean)false);
        LOG = Logger.getInstance((String)"#com.intellij.util.indexing.impl.MapReduceIndex");
        if (ourFileSharedIndicesEnabled) {
            try {
                ourSharedFileInputs = IndexedStateMap.createMap(new File(PathManager.getIndexRoot(), "file_inputs.data"));
                ourSharedFileContentIndependentInputs = IndexedStateMap.createMap(new File(PathManager.getIndexRoot(), "file_inputs_content_independent.data"));
                ourSharedContentInputs = IndexedStateMap.createMap(new File(IndexInfrastructure.getPersistentIndexRoot(), "content_inputs.data"));
                ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                    @Override
                    public void run() {
                        this.close(ourSharedFileInputs);
                        this.close(ourSharedFileContentIndependentInputs);
                        this.close(ourSharedContentInputs);
                    }

                    private void close(IndexedStateMap index) {
                        try {
                            index.close();
                        }
                        catch (IOException ex) {
                            LOG.error((Throwable)ex);
                        }
                    }
                });
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class IndexedStateCache
    extends FileAccessorCache<Integer, IndexedState> {
        private final IndexedStateMap myStorage;

        IndexedStateCache(int protectedQueueSize, int probationalQueueSize, IndexedStateMap storage2) {
            super(protectedQueueSize, probationalQueueSize);
            this.myStorage = storage2;
        }

        protected IndexedState createAccessor(Integer key) throws IOException {
            return new IndexedState(key, this.myStorage);
        }

        protected void disposeAccessor(IndexedState fileAccessor) throws IOException {
            fileAccessor.flush();
        }
    }

    static class IndexedState {
        private final int fileOrContentId;
        private final PersistentHashMap<Integer, byte[]> storage;
        private byte[] values;
        private TIntLongHashMap indexId2Offset;
        private TIntObjectHashMap<byte[]> indexId2NewState;
        private boolean compactNecessary;

        IndexedState(int fileOrContentId, PersistentHashMap<Integer, byte[]> storage2) throws IOException {
            this.fileOrContentId = fileOrContentId;
            this.storage = storage2;
            byte[] bytes = (byte[])storage2.get((Object)fileOrContentId);
            if (bytes == null) {
                return;
            }
            DataInputStream stream = new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes));
            boolean compactNecessary = false;
            TIntLongHashMap stateMap = null;
            while (stream.available() > 0) {
                int chunkSize = DataInputOutputUtil.readINT((DataInput)stream);
                int chunkIndexId = DataInputOutputUtil.readINT((DataInput)stream);
                long chunkIndexTimeStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                int currentOffset = bytes.length - stream.available();
                ID chunkIndexID = ID.findById((int)chunkIndexId);
                if (chunkIndexID != null && chunkIndexTimeStamp == IndexingStamp.getIndexCreationStamp(chunkIndexID)) {
                    if (chunkSize != 0) {
                        if (stateMap == null) {
                            stateMap = new TIntLongHashMap();
                        }
                        stateMap.put(chunkIndexId, (long)currentOffset << 32 | (long)chunkSize);
                    } else if (stateMap != null) {
                        stateMap.remove(chunkIndexId);
                        compactNecessary = true;
                    }
                } else {
                    compactNecessary = true;
                }
                stream.skipBytes(chunkSize);
            }
            this.values = bytes;
            this.compactNecessary = compactNecessary;
            this.indexId2Offset = stateMap;
        }

        synchronized void flush() throws IOException {
            if (this.compactNecessary) {
                boolean result2;
                UnsyncByteArrayOutputStream compactedOutputStream = new UnsyncByteArrayOutputStream(this.values.length);
                DataOutputStream compactedOutput = new DataOutputStream((OutputStream)compactedOutputStream);
                Ref ioExceptionRef = new Ref();
                boolean bl = result2 = this.indexId2NewState == null || this.indexId2NewState.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<byte[]>((DataOutput)compactedOutput, ioExceptionRef){
                    final /* synthetic */ DataOutput val$compactedOutput;
                    final /* synthetic */ Ref val$ioExceptionRef;
                    {
                        this.val$compactedOutput = dataOutput;
                        this.val$ioExceptionRef = ref;
                    }

                    public boolean execute(int indexUniqueId, byte[] indexValue) {
                        try {
                            long indexCreationStamp = IndexingStamp.getIndexCreationStamp(ID.findById((int)indexUniqueId));
                            SharedIndicesData.writeIndexValue(indexUniqueId, indexCreationStamp, indexValue, 0, indexValue.length, this.val$compactedOutput);
                            return true;
                        }
                        catch (IOException ex) {
                            this.val$ioExceptionRef.set((Object)ex);
                            return false;
                        }
                    }
                });
                if (!result2) {
                    throw (IOException)ioExceptionRef.get();
                }
                boolean bl2 = result2 = this.indexId2Offset == null || this.indexId2Offset.forEachEntry(new TIntLongProcedure((DataOutput)compactedOutput, ioExceptionRef){
                    final /* synthetic */ DataOutput val$compactedOutput;
                    final /* synthetic */ Ref val$ioExceptionRef;
                    {
                        this.val$compactedOutput = dataOutput;
                        this.val$ioExceptionRef = ref;
                    }

                    public boolean execute(int chunkIndexId, long chunkOffsetAndSize) {
                        try {
                            int chunkOffset = (int)(chunkOffsetAndSize >> 32);
                            int chunkSize = (int)chunkOffsetAndSize;
                            SharedIndicesData.writeIndexValue(chunkIndexId, IndexingStamp.getIndexCreationStamp(ID.findById((int)chunkIndexId)), values, chunkOffset, chunkSize, this.val$compactedOutput);
                            return true;
                        }
                        catch (IOException e2) {
                            this.val$ioExceptionRef.set((Object)e2);
                            return false;
                        }
                    }
                });
                if (!result2) {
                    throw (IOException)ioExceptionRef.get();
                }
                if (compactedOutputStream.size() > 0) {
                    this.storage.put((Object)this.fileOrContentId, (Object)compactedOutputStream.toByteArray());
                } else {
                    this.storage.remove((Object)this.fileOrContentId);
                }
            }
        }

        synchronized void appendIndexedState(ID<?, ?> indexId, long timestamp, byte[] buffer, int size) {
            int indexUniqueId = indexId.getUniqueId();
            if (this.indexId2Offset != null) {
                this.indexId2Offset.remove(indexUniqueId);
            }
            if (buffer == null) {
                if (this.indexId2NewState != null) {
                    this.indexId2NewState.remove(indexUniqueId);
                }
            } else {
                if (this.indexId2NewState == null) {
                    this.indexId2NewState = new TIntObjectHashMap();
                }
                this.indexId2NewState.put(indexUniqueId, (Object)Arrays.copyOf(buffer, size));
            }
        }

        @Nullable
        synchronized DataInputStream readIndexedState(ID<?, ?> indexId) {
            int indexUniqueId = indexId.getUniqueId();
            int offset = 0;
            int length = 0;
            byte[] bytes = null;
            if (this.indexId2NewState != null) {
                bytes = (byte[])this.indexId2NewState.get(indexUniqueId);
                offset = 0;
                int n2 = length = bytes != null ? bytes.length : 0;
            }
            if (bytes == null) {
                if (this.values == null || this.indexId2Offset == null || !this.indexId2Offset.contains(indexUniqueId)) {
                    return null;
                }
                bytes = this.values;
                long offsetAndSize = this.indexId2Offset.get(indexUniqueId);
                offset = (int)(offsetAndSize >> 32);
                length = (int)offsetAndSize;
            }
            return new DataInputStream((InputStream)new UnsyncByteArrayInputStream(bytes, offset, offset + length));
        }
    }

    private static class IndexedStateMap
    extends PersistentHashMap<Integer, byte[]> {
        final IndexedStateCache myStateCache;

        public IndexedStateMap(@NotNull File file2) throws IOException {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/SharedIndicesData$IndexedStateMap", "<init>"));
            }
            super(file2, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<byte[]>(){

                public void save(@NotNull DataOutput out, byte[] value2) throws IOException {
                    if (out == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/indexing/SharedIndicesData$IndexedStateMap$1", "save"));
                    }
                    out.write(value2);
                }

                public byte[] read(@NotNull DataInput in) throws IOException {
                    if (in == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/indexing/SharedIndicesData$IndexedStateMap$1", "read"));
                    }
                    int available = ((InputStream)((Object)in)).available();
                    byte[] result2 = new byte[available];
                    in.readFully(result2);
                    return result2;
                }
            });
            this.myStateCache = new IndexedStateCache(200, 100, this);
        }

        protected void doDropMemoryCaches() {
            if (this.myStateCache != null) {
                this.myStateCache.clear();
            }
            super.doDropMemoryCaches();
        }

        protected void doForce() {
            if (this.myStateCache != null) {
                this.myStateCache.clear();
            }
            super.doForce();
        }

        static IndexedStateMap createMap(File indexFile) throws IOException {
            return (IndexedStateMap)((Object)IOUtil.openCleanOrResetBroken(() -> new IndexedStateMap(indexFile), (File)indexFile));
        }
    }
}

