/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.google.common.net.InetAddresses;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.BootstrapUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.ide.PooledThreadExecutor;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u008c\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\u001aF\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u0019H\u0002\u001a>\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u001a \u0010\u001f\u001a\u00020 2\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020 \u001a\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0002H\u0002\u001a\u0006\u0010%\u001a\u00020\u0013\u001a&\u0010&\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010\u00012\b\b\u0002\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020 H\u0007\u001a\u000e\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+\u001a\u001c\u0010,\u001a\u00020 2\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\u0006\u0010-\u001a\u00020\u0019\u001a2\u0010.\u001a\u00020/*\u0002002#\b\u0004\u00101\u001a\u001d\u0012\u0013\u0012\u001100\u00a2\u0006\f\b3\u0012\b\b4\u0012\u0004\b\b(5\u0012\u0004\u0012\u00020/02H\u0086\b\u001a\n\u00106\u001a\u00020/*\u00020\f\u001aB\u00107\u001a\u0004\u0018\u00010\f*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\u0010\b\u0002\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bH\u0007\u001a#\u00108\u001a\u00020\u0013*\u00020\u00132\u0014\b\u0004\u00109\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020/02H\u0086\b\u001a \u0010:\u001a\u00020 *\u00020\u00052\b\b\u0002\u0010!\u001a\u00020 2\b\b\u0002\u0010\"\u001a\u00020 H\u0007\u001a\n\u0010;\u001a\u00020 *\u00020\u0005\u001a\n\u0010<\u001a\u00020 *\u00020\u0005\u001a\u0012\u0010=\u001a\n >*\u0004\u0018\u00010\u00010\u0001*\u00020?\u001a&\u0010@\u001a\u0002HA\"\u0004\b\u0000\u0010A*\u00020?2\f\u00109\u001a\b\u0012\u0004\u0012\u0002HA0BH\u0086\b\u00a2\u0006\u0002\u0010C\u001a\n\u0010D\u001a\u00020/*\u00020E\u001a\u0012\u0010F\u001a\u00020\u0019*\u00020?2\u0006\u0010G\u001a\u00020H\"\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\"\u0017\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006I"}, d2={"host", "", "Lcom/intellij/util/Url;", "getHost", "(Lcom/intellij/util/Url;)Ljava/lang/String;", "Lio/netty/handler/codec/http/HttpRequest;", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "origin", "getOrigin", "referrer", "getReferrer", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "userAgent", "getUserAgent", "connectNio", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "remoteAddress", "Ljava/net/InetSocketAddress;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "_attemptCount", "doConnect", "isLocalHost", "", "onlyAnyOrLoopback", "hostsOnly", "isTrustedChromeExtension", "url", "oioClientBootstrap", "parseAndCheckIsLocalHost", "uri", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "sleep", "time", "addChannelListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "future", "closeAndShutdownEventLoop", "connect", "handler", "task", "isLocalOrigin", "isRegularBrowser", "isWriteFromBrowserWithoutOrigin", "readUtf8", "kotlin.jvm.PlatformType", "Lio/netty/buffer/ByteBuf;", "releaseIfError", "T", "Lkotlin/Function0;", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "shutdownIfOio", "Lio/netty/channel/EventLoop;", "writeUtf8", "data", "", "platform-impl"})
public final class NettyKt {
    @NotNull
    public static final Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
        return bootstrap2;
    }

    @NotNull
    public static final Bootstrap handler(@NotNull Bootstrap $receiver, @NotNull Function1<? super Channel, Unit> task2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task2, (String)"task");
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(task2){
            final /* synthetic */ Function1 $task;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
        return $receiver;
    }

    @NotNull
    public static final ServerBootstrap serverBootstrap(@NotNull EventLoopGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(group).channel(group instanceof NioEventLoopGroup ? NioServerSocketChannel.class : OioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ServerBootstrap serverBootstrap = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)serverBootstrap, (String)"bootstrap");
        return serverBootstrap;
    }

    public static final void addChannelListener(@NotNull ChannelFuture $receiver, @NotNull Function1<? super ChannelFuture, Unit> listener2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(listener2){
            final /* synthetic */ Function1 $listener;

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                this.$listener.invoke((Object)channelFuture);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public static final void shutdownIfOio(@NotNull EventLoop $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof OioEventLoopGroup) {
            EventLoop eventLoop = $receiver;
            if (eventLoop == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.netty.channel.oio.OioEventLoopGroup");
            }
            ((OioEventLoopGroup)eventLoop).shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(@NotNull Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        EventLoop eventLoop = $receiver.eventLoop();
        try {
            $receiver.close().awaitUninterruptibly();
        }
        finally {
            NettyKt.shutdownIfOio(eventLoop);
        }
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(@NotNull Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition condition = stopCondition;
            if (condition == null) {
                Condition condition2 = Conditions.alwaysFalse();
                condition = condition2;
                Intrinsics.checkExpressionValueIsNotNull((Object)condition2, (String)"Conditions.alwaysFalse<Void>()");
            }
            return NettyKt.doConnect($receiver, remoteAddress, promise2, maxAttemptCount, condition);
        }
        catch (Throwable e2) {
            block3: {
                AsyncPromise<?> asyncPromise = promise2;
                if (asyncPromise == null) break block3;
                asyncPromise.setError(e2);
            }
            return null;
        }
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Channel connect$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, AsyncPromise asyncPromise, int n2, Condition condition, int n3, Object object) {
        if ((n3 & 2) != 0) {
            asyncPromise = null;
        }
        if ((n3 & 4) != 0) {
            n2 = 20;
        }
        if ((n3 & 8) != 0) {
            condition = null;
        }
        return NettyKt.connect(bootstrap, inetSocketAddress, asyncPromise, n2, (Condition<Void>)condition);
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(@NotNull Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount) {
        return NettyKt.connect$default($receiver, remoteAddress, promise2, maxAttemptCount, null, 8, null);
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(@NotNull Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2) {
        return NettyKt.connect$default($receiver, remoteAddress, promise2, 0, null, 12, null);
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(@NotNull Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress) {
        return NettyKt.connect$default($receiver, remoteAddress, null, 0, null, 14, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Channel doConnect(Bootstrap bootstrap, InetSocketAddress remoteAddress, AsyncPromise<?> promise2, int maxAttemptCount, Condition<Void> stopCondition) {
        int attemptCount = 0;
        if (bootstrap.config().group() instanceof NioEventLoopGroup) {
            return NettyKt.connectNio(bootstrap, remoteAddress, promise2, maxAttemptCount, stopCondition, attemptCount);
        }
        bootstrap.validate();
        while (true) {
            try {
                OioSocketChannel channel = new OioSocketChannel(new Socket(remoteAddress.getAddress(), remoteAddress.getPort()));
                BootstrapUtil.initAndRegister((Channel)channel, bootstrap).sync();
                return (Channel)channel;
            }
            catch (IOException e2) {
                if (stopCondition.value(null) || promise2 != null && Intrinsics.areEqual((Object)promise2.getState(), (Object)Promise.State.PENDING) ^ true) {
                    return null;
                }
                if (maxAttemptCount == -1) {
                    if (NettyKt.sleep(promise2, 300)) {
                        return null;
                    }
                    ++attemptCount;
                    continue;
                }
                if (++attemptCount < maxAttemptCount) {
                    if (NettyKt.sleep(promise2, attemptCount * 100)) return null;
                    continue;
                }
                AsyncPromise<?> asyncPromise = promise2;
                if (asyncPromise == null) return null;
                asyncPromise.setError((Throwable)e2);
                return null;
            }
            break;
        }
    }

    private static final Channel connectNio(Bootstrap bootstrap, InetSocketAddress remoteAddress, AsyncPromise<?> promise2, int maxAttemptCount, Condition<Void> stopCondition, int _attemptCount) {
        ChannelFuture future2;
        block8: {
            int attemptCount = _attemptCount;
            while (true) {
                if ((future2 = bootstrap.connect((SocketAddress)remoteAddress).awaitUninterruptibly()).isSuccess()) {
                    if (!future2.channel().isOpen()) continue;
                    return future2.channel();
                }
                if (stopCondition.value(null) || promise2 != null && Intrinsics.areEqual((Object)promise2.getState(), (Object)Promise.State.REJECTED)) {
                    return null;
                }
                if (maxAttemptCount == -1) {
                    if (NettyKt.sleep(promise2, 300)) {
                        return null;
                    }
                    ++attemptCount;
                    continue;
                }
                if (++attemptCount >= maxAttemptCount) break block8;
                if (NettyKt.sleep(promise2, attemptCount * 100)) break;
            }
            return null;
        }
        Throwable cause = future2.cause();
        if (promise2 != null) {
            if (cause == null) {
                promise2.setError("Cannot connect: unknown error");
            } else {
                promise2.setError(cause);
            }
        }
        return null;
    }

    public static final boolean sleep(@Nullable AsyncPromise<?> promise2, int time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException ignored) {
            AsyncPromise<?> asyncPromise = promise2;
            if (asyncPromise != null) {
                asyncPromise.setError("Interrupted");
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static final String getUriScheme(@NotNull Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @Nullable
    public static final String getHost(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
    }

    @Nullable
    public static final String getOrigin(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.ORIGIN);
    }

    @Nullable
    public static final String getReferrer(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.REFERER);
    }

    @Nullable
    public static final String getUserAgent(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.headers().getAsString((CharSequence)HttpHeaderNames.USER_AGENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T releaseIfError(@NotNull ByteBuf $receiver, @NotNull Function0<? extends T> task2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task2, (String)"task");
        try {
            return (T)task2.invoke();
        }
        catch (Exception e2) {
            try {
                $receiver.release();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                throw (Throwable)e2;
            }
        }
    }

    public static final boolean isLocalHost(@NotNull String host, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        if (NetUtils.isLocalhost((String)host)) {
            return true;
        }
        if (onlyAnyOrLoopback && !InetAddresses.isInetAddress((String)host)) {
            return false;
        }
        isLocalHost.1 isLocal$ = isLocalHost.1.INSTANCE;
        try {
            InetAddress address = InetAddress.getByName(host);
            if (!isLocal$.invoke(address)) {
                return false;
            }
            if (hostsOnly && !InetAddresses.isInetAddress((String)host)) {
                InetAddress inetAddress = HostsFileEntriesResolver.DEFAULT.address(host, ResolvedAddressTypes.IPV4_PREFERRED);
                InetAddress it = inetAddress;
                return it != null && isLocalHost.1.INSTANCE.invoke(it);
            }
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public static /* bridge */ /* synthetic */ boolean isLocalHost$default(String string2, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalHost(string2, bl, bl2);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $receiver, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return NettyKt.parseAndCheckIsLocalHost(NettyKt.getOrigin($receiver), onlyAnyOrLoopback, hostsOnly) && NettyKt.parseAndCheckIsLocalHost(NettyKt.getReferrer($receiver), onlyAnyOrLoopback, hostsOnly);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean isLocalOrigin$default(HttpRequest httpRequest, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = true;
        }
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        return NettyKt.isLocalOrigin(httpRequest, bl, bl2);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $receiver, boolean onlyAnyOrLoopback) {
        return NettyKt.isLocalOrigin$default($receiver, onlyAnyOrLoopback, false, 2, null);
    }

    @JvmOverloads
    public static final boolean isLocalOrigin(@NotNull HttpRequest $receiver) {
        return NettyKt.isLocalOrigin$default($receiver, false, false, 3, null);
    }

    private static final boolean isTrustedChromeExtension(Url url) {
        return Intrinsics.areEqual((Object)url.getScheme(), (Object)"chrome-extension") && (Intrinsics.areEqual((Object)url.getAuthority(), (Object)"hmhgeddbohgjknpmjagkdomcpobmllji") || Intrinsics.areEqual((Object)url.getAuthority(), (Object)"offnedcbhjldheanlbojaefbfbllddna"));
    }

    /*
     * WARNING - void declaration
     */
    private static final String getHost(@NotNull Url $receiver) {
        String string2;
        String string3 = $receiver.getAuthority();
        if (string3 != null) {
            String string4;
            String string5 = string3;
            String it = string5;
            int portIndex = StringsKt.indexOf$default((CharSequence)it, (char)':', (int)0, (boolean)false, (int)6, null);
            if (portIndex > 0) {
                String string6 = it;
                int n2 = 0;
                String string7 = string6;
                if (string7 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = string7.substring(n2, portIndex);
                string4 = string8;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                void var2_2;
                string4 = var2_2;
            }
            string2 = string4;
        } else {
            string2 = null;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@Nullable String uri2, boolean onlyAnyOrLoopback, boolean hostsOnly) {
        if (uri2 == null) return true;
        if (Intrinsics.areEqual((Object)uri2, (Object)"about:blank")) {
            return true;
        }
        try {
            Url url = Urls.parse(uri2, false);
            if (url == null) return false;
            Url parsedUri = url;
            String host = NettyKt.getHost(parsedUri);
            if (host == null) return false;
            Url url2 = parsedUri;
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"parsedUri");
            if (NettyKt.isTrustedChromeExtension(url2)) return true;
            if (!NettyKt.isLocalHost(host, onlyAnyOrLoopback, hostsOnly)) return false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ boolean parseAndCheckIsLocalHost$default(String string2, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return NettyKt.parseAndCheckIsLocalHost(string2, bl, bl2);
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@Nullable String uri2, boolean onlyAnyOrLoopback) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri2, onlyAnyOrLoopback, false, 4, null);
    }

    @JvmOverloads
    public static final boolean parseAndCheckIsLocalHost(@Nullable String uri2) {
        return NettyKt.parseAndCheckIsLocalHost$default(uri2, false, false, 6, null);
    }

    public static final boolean isRegularBrowser(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string2 = NettyKt.getUserAgent($receiver);
        return string2 != null ? StringsKt.startsWith$default((String)string2, (String)"Mozilla/5.0", (boolean)false, (int)2, null) : false;
    }

    public static final boolean isWriteFromBrowserWithoutOrigin(@NotNull HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        HttpMethod method2 = $receiver.method();
        CharSequence charSequence = NettyKt.getOrigin($receiver);
        return (charSequence == null || charSequence.length() == 0) && NettyKt.isRegularBrowser($receiver) && (Intrinsics.areEqual((Object)method2, (Object)HttpMethod.POST) || Intrinsics.areEqual((Object)method2, (Object)HttpMethod.PATCH) || Intrinsics.areEqual((Object)method2, (Object)HttpMethod.PUT) || Intrinsics.areEqual((Object)method2, (Object)HttpMethod.DELETE));
    }

    public static final String readUtf8(@NotNull ByteBuf $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.toString(Charsets.UTF_8);
    }

    public static final int writeUtf8(@NotNull ByteBuf $receiver, @NotNull CharSequence data) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return $receiver.writeCharSequence(data, Charsets.UTF_8);
    }
}

