/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.TestFileSystemItem;
import org.jetbrains.annotations.NotNull;

public class TestFileSystemBuilder {
    private final TestFileSystemItem myItem;
    private final TestFileSystemBuilder myParent;

    private TestFileSystemBuilder(TestFileSystemItem item, TestFileSystemBuilder parent) {
        this.myItem = item;
        this.myParent = parent;
    }

    @NotNull
    public TestFileSystemItem build() {
        TestFileSystemBuilder builder = this;
        while (builder.myParent != null) {
            builder = builder.myParent;
        }
        TestFileSystemItem testFileSystemItem = builder.myItem;
        if (testFileSystemItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/TestFileSystemBuilder", "build"));
        }
        return testFileSystemItem;
    }

    @NotNull
    public TestFileSystemBuilder dir(String name) {
        TestFileSystemItem item = new TestFileSystemItem(name, false, true);
        this.myItem.addChild(item);
        TestFileSystemBuilder testFileSystemBuilder = new TestFileSystemBuilder(item, this);
        if (testFileSystemBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/TestFileSystemBuilder", "dir"));
        }
        return testFileSystemBuilder;
    }

    @NotNull
    public TestFileSystemBuilder archive(String name) {
        TestFileSystemItem item = new TestFileSystemItem(name, true, false);
        this.myItem.addChild(item);
        TestFileSystemBuilder testFileSystemBuilder = new TestFileSystemBuilder(item, this);
        if (testFileSystemBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/TestFileSystemBuilder", "archive"));
        }
        return testFileSystemBuilder;
    }

    @NotNull
    public TestFileSystemBuilder file(String name) {
        this.myItem.addChild(new TestFileSystemItem(name, false, false));
        TestFileSystemBuilder testFileSystemBuilder = this;
        if (testFileSystemBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/TestFileSystemBuilder", "file"));
        }
        return testFileSystemBuilder;
    }

    @NotNull
    public TestFileSystemBuilder file(String name, String content2) {
        this.myItem.addChild(new TestFileSystemItem(name, false, false, content2));
        TestFileSystemBuilder testFileSystemBuilder = this;
        if (testFileSystemBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/TestFileSystemBuilder", "file"));
        }
        return testFileSystemBuilder;
    }

    public TestFileSystemBuilder end() {
        return this.myParent;
    }

    @NotNull
    public static TestFileSystemBuilder fs() {
        TestFileSystemBuilder testFileSystemBuilder = new TestFileSystemBuilder(new TestFileSystemItem("root", false, true), null);
        if (testFileSystemBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/TestFileSystemBuilder", "fs"));
        }
        return testFileSystemBuilder;
    }
}

