/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection;

import com.intellij.util.io.socketConnection.ConnectionStatus;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectionState {
    private final String message;
    private final ConnectionStatus status;
    private final HyperlinkListener messageLinkListener;

    public ConnectionState(@NotNull ConnectionStatus status, @Nullable String message2, @Nullable HyperlinkListener messageLinkListener) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/util/io/socketConnection/ConnectionState", "<init>"));
        }
        this.status = status;
        this.message = message2;
        this.messageLinkListener = messageLinkListener;
    }

    public ConnectionState(@NotNull ConnectionStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/util/io/socketConnection/ConnectionState", "<init>"));
        }
        this(status, null, null);
    }

    @NotNull
    public ConnectionStatus getStatus() {
        ConnectionStatus connectionStatus = this.status;
        if (connectionStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/socketConnection/ConnectionState", "getStatus"));
        }
        return connectionStatus;
    }

    @NotNull
    public String getMessage() {
        String string2 = this.message == null ? this.status.getStatusText() : this.message;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/socketConnection/ConnectionState", "getMessage"));
        }
        return string2;
    }

    @Nullable
    public HyperlinkListener getMessageLinkListener() {
        return this.messageLinkListener;
    }
}

