/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.socketConnection.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.socketConnection.AbstractRequest;
import com.intellij.util.io.socketConnection.AbstractResponse;
import com.intellij.util.io.socketConnection.ClientSocketConnection;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.RequestResponseExternalizerFactory;
import com.intellij.util.io.socketConnection.impl.SocketConnectionBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;

public class SocketConnectionImpl<Request extends AbstractRequest, Response extends AbstractResponse>
extends SocketConnectionBase<Request, Response>
implements ClientSocketConnection<Request, Response> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.io.socketConnection.impl.SocketConnectionImpl");
    private static final int MAX_CONNECTION_ATTEMPTS = 60;
    private static final int CONNECTION_ATTEMPT_DELAY = 500;
    private final InetAddress myHost;
    private final int myInitialPort;
    private final int myPortsNumberToTry;

    public SocketConnectionImpl(InetAddress host, int initialPort, int portsNumberToTry, @NotNull RequestResponseExternalizerFactory<Request, Response> requestResponseRequestResponseExternalizerFactory) {
        if (requestResponseRequestResponseExternalizerFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestResponseRequestResponseExternalizerFactory", "com/intellij/util/io/socketConnection/impl/SocketConnectionImpl", "<init>"));
        }
        super(requestResponseRequestResponseExternalizerFactory);
        this.myHost = host;
        this.myInitialPort = initialPort;
        this.myPortsNumberToTry = portsNumberToTry;
    }

    @Override
    public void open() throws IOException {
        Socket socket = this.createSocket();
        this.setPort(socket.getPort());
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.attachToSocket(socket);
            }
            catch (IOException e2) {
                LOG.info((Throwable)e2);
                this.setStatus(ConnectionStatus.CONNECTION_FAILED, "Connection failed: " + e2.getMessage());
            }
        });
    }

    @NotNull
    private Socket createSocket() throws IOException {
        InetAddress host = this.myHost;
        if (host == null) {
            try {
                host = InetAddress.getLocalHost();
            }
            catch (UnknownHostException ignored) {
                host = InetAddress.getLoopbackAddress();
            }
        }
        IOException exc = null;
        for (int i2 = 0; i2 < this.myPortsNumberToTry; ++i2) {
            Socket socket;
            block6: {
                int port = this.myInitialPort + i2;
                try {
                    socket = new Socket(host, port);
                    if (socket != null) break block6;
                }
                catch (IOException e2) {
                    exc = e2;
                    LOG.debug((Throwable)e2);
                    continue;
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/socketConnection/impl/SocketConnectionImpl", "createSocket"));
            }
            return socket;
        }
        throw exc;
    }

    public void connect() {
        this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION, null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            Exception exception = null;
            InetAddress host = this.myHost;
            if (host == null) {
                host = InetAddress.getLoopbackAddress();
            }
            for (int attempt = 0; attempt < 60; ++attempt) {
                for (int i2 = 0; i2 < this.myPortsNumberToTry; ++i2) {
                    Socket socket;
                    try {
                        socket = new Socket(host, this.myInitialPort + i2);
                    }
                    catch (IOException e2) {
                        LOG.debug((Throwable)e2);
                        exception = e2;
                        continue;
                    }
                    this.setPort(socket.getPort());
                    try {
                        this.attachToSocket(socket);
                    }
                    catch (IOException e3) {
                        LOG.info((Throwable)e3);
                    }
                    return;
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e4) {
                    exception = e4;
                    break;
                }
            }
            this.setStatus(ConnectionStatus.CONNECTION_FAILED, exception == null ? "Connection failed" : "Connection failed: " + exception.getMessage());
        });
    }

    @Override
    public void startPolling() {
        this.setStatus(ConnectionStatus.WAITING_FOR_CONNECTION, null);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            this.addThreadToInterrupt();
            try {
                for (int attempt = 0; attempt < 60; ++attempt) {
                    try {
                        this.open();
                        return;
                    }
                    catch (IOException e2) {
                        LOG.debug((Throwable)e2);
                        Thread.sleep(500L);
                        continue;
                    }
                }
                this.setStatus(ConnectionStatus.CONNECTION_FAILED, "Cannot connect to " + (this.myHost != null ? this.myHost : "localhost") + ", the maximum number of connection attempts exceeded");
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.removeThreadToInterrupt();
            }
        });
    }
}

