/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.profiling;

import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class ProfileViewer {
    HashMap<Integer, Ref> map = new HashMap();

    ProfileViewer() {
    }

    public static void main(String[] args) throws IOException {
        new ProfileViewer().run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws IOException {
        ArrayList<String> list2 = new ArrayList<String>();
        File dir = new File("/users/maxmedvedev/work/resolve_info");
        block3: for (File file2 : dir.listFiles()) {
            if (!file2.getName().endsWith(".txt")) continue;
            try (BufferedReader reader = new BufferedReader(new FileReader(file2));){
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        continue block3;
                    }
                    list2.add(line);
                }
            }
        }
        Occurrence root = new Occurrence();
        ArrayDeque<Occurrence> stack = new ArrayDeque<Occurrence>();
        stack.push(root);
        int curSpaces = 0;
        for (String line : list2) {
            int spaces = ProfileViewer.leadingSpaces(line);
            if (curSpaces <= spaces) {
                Occurrence occurrence;
                while (curSpaces < spaces) {
                    occurrence = new Occurrence();
                    ((Occurrence)stack.peek()).addSubOccurrence(occurrence);
                    stack.push(occurrence);
                    curSpaces += 2;
                }
                occurrence = new Occurrence();
                occurrence.setData(line.trim());
                ((Occurrence)stack.peek()).addSubOccurrence(occurrence);
                continue;
            }
            ((Occurrence)stack.pop()).setData(line);
            curSpaces -= 2;
        }
        ArrayList<Ref> refs = new ArrayList<Ref>(this.map.values());
        ContainerUtil.sort(refs, (ref1, ref2) -> ((Ref)ref2).totalTime - ((Ref)ref1).totalTime);
        boolean var = true;
    }

    static int leadingSpaces(String s2) {
        int i2;
        for (i2 = 0; i2 < s2.length() && s2.charAt(i2) == ' '; ++i2) {
        }
        return i2;
    }

    class Occurrence {
        private Ref ref;
        private int time;
        private String type;
        private final List<Occurrence> subOccurrences = new ArrayList<Occurrence>();

        Occurrence() {
        }

        void setData(String line) {
            String[] split = line.split(" :: ");
            assert (split.length == 5) : line;
            try {
                this.type = split[0];
                String filename = split[1];
                String text2 = split[2];
                int hashcode = Integer.parseInt(split[3]);
                this.time = Integer.parseInt(split[4]);
                Ref ref = ProfileViewer.this.map.get(hashcode);
                if (ref == null) {
                    ref = new Ref(text2, hashcode, filename);
                    ProfileViewer.this.map.put(hashcode, ref);
                }
                this.ref = ref;
                ref.addOccurrence(this);
            }
            catch (NumberFormatException e2) {
                throw new NumberFormatException(line);
            }
        }

        Ref getRef() {
            return this.ref;
        }

        int getTime() {
            return this.time;
        }

        void addSubOccurrence(Occurrence o2) {
            this.subOccurrences.add(o2);
        }

        public String toString() {
            return this.time + " (" + (this.ref != null ? this.ref.text : null) + ")";
        }
    }

    private class Ref {
        private final String text;
        private final String fileName;
        private final int hashcode;
        private int totalTime;
        private final List<Occurrence> occurrences = new ArrayList<Occurrence>();

        Ref(String text2, int hashcode, String filename) {
            this.text = text2;
            this.hashcode = hashcode;
            this.fileName = filename;
        }

        void addOccurrence(Occurrence o2) {
            this.occurrences.add(o2);
            this.totalTime += o2.time;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            return obj instanceof Ref && this.hashcode == ((Ref)obj).hashcode;
        }

        public String toString() {
            return this.text + " (" + this.totalTime + ")";
        }
    }
}

