/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.textCompletion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.CharFilter;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValuesCompletionProvider<T>
implements TextCompletionProvider {
    @NotNull
    protected final TextCompletionValueDescriptor<T> myDescriptor;
    @NotNull
    private final List<Character> mySeparators;
    @NotNull
    protected final Collection<? extends T> myValues;
    private final boolean myCaseSensitive;
    @NotNull
    private final InsertHandler<LookupElement> myInsertHandler;

    public ValuesCompletionProvider(@NotNull TextCompletionValueDescriptor<T> descriptor2, @NotNull List<Character> separators, @NotNull Collection<? extends T> values, boolean caseSensitive) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/util/textCompletion/ValuesCompletionProvider", "<init>"));
        }
        if (separators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separators", "com/intellij/util/textCompletion/ValuesCompletionProvider", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/textCompletion/ValuesCompletionProvider", "<init>"));
        }
        this.myInsertHandler = new CompletionCharInsertHandler();
        this.myDescriptor = descriptor2;
        this.mySeparators = separators;
        this.myValues = values;
        this.myCaseSensitive = caseSensitive;
    }

    public ValuesCompletionProvider(@NotNull TextCompletionValueDescriptor<T> presentation, @NotNull Collection<? extends T> values) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/util/textCompletion/ValuesCompletionProvider", "<init>"));
        }
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/textCompletion/ValuesCompletionProvider", "<init>"));
        }
        this(presentation, Collections.emptyList(), values, false);
    }

    @Override
    @Nullable
    public String getAdvertisement() {
        return "";
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text2, int offset) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/textCompletion/ValuesCompletionProvider", "getPrefix"));
        }
        return ValuesCompletionProvider.getPrefix(text2, offset, this.mySeparators);
    }

    @NotNull
    protected static String getPrefix(@NotNull String text2, int offset, @NotNull Collection<Character> separators) {
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/textCompletion/ValuesCompletionProvider", "getPrefix"));
        }
        if (separators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separators", "com/intellij/util/textCompletion/ValuesCompletionProvider", "getPrefix"));
        }
        int index = -1;
        for (char c2 : separators) {
            index = Math.max(text2.lastIndexOf(c2, offset - 1), index);
        }
        String string2 = text2.substring(index + 1, offset);
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/textCompletion/ValuesCompletionProvider", "getPrefix"));
        }
        return string2;
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/textCompletion/ValuesCompletionProvider", "applyPrefixMatcher"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/util/textCompletion/ValuesCompletionProvider", "applyPrefixMatcher"));
        }
        CompletionResultSet resultWithMatcher = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix));
        if (!this.myCaseSensitive) {
            resultWithMatcher = resultWithMatcher.caseInsensitive();
        }
        CompletionResultSet completionResultSet = resultWithMatcher;
        if (completionResultSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/textCompletion/ValuesCompletionProvider", "applyPrefixMatcher"));
        }
        return completionResultSet;
    }

    @Override
    @Nullable
    public CharFilter.Result acceptChar(char c2) {
        if (!this.mySeparators.contains(Character.valueOf(c2))) {
            return CharFilter.Result.ADD_TO_PREFIX;
        }
        return CharFilter.Result.HIDE_LOOKUP;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/textCompletion/ValuesCompletionProvider", "fillCompletionVariants"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/util/textCompletion/ValuesCompletionProvider", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/textCompletion/ValuesCompletionProvider", "fillCompletionVariants"));
        }
        List values = this.getValues(prefix, result2);
        values = ContainerUtil.sorted(values, this.myDescriptor);
        for (Object completionVariant : values) {
            result2.addElement(this.installInsertHandler(this.myDescriptor.createLookupBuilder(completionVariant)));
        }
        result2.stopHere();
    }

    @NotNull
    protected LookupElement installInsertHandler(@NotNull LookupElementBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/util/textCompletion/ValuesCompletionProvider", "installInsertHandler"));
        }
        final InsertHandler handler2 = builder.getInsertHandler();
        if (handler2 == null) {
            LookupElementBuilder lookupElementBuilder = builder.withInsertHandler(this.myInsertHandler);
            if (lookupElementBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/textCompletion/ValuesCompletionProvider", "installInsertHandler"));
            }
            return lookupElementBuilder;
        }
        LookupElementBuilder lookupElementBuilder = builder.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context2, LookupElement item) {
                ValuesCompletionProvider.this.myInsertHandler.handleInsert(context2, item);
                handler2.handleInsert(context2, item);
            }
        });
        if (lookupElementBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/textCompletion/ValuesCompletionProvider", "installInsertHandler"));
        }
        return lookupElementBuilder;
    }

    @NotNull
    protected Collection<? extends T> getValues(@NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/util/textCompletion/ValuesCompletionProvider", "getValues"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/textCompletion/ValuesCompletionProvider", "getValues"));
        }
        Collection<? extends T> collection = this.myValues;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/textCompletion/ValuesCompletionProvider", "getValues"));
        }
        return collection;
    }

    public static class ValuesCompletionProviderDumbAware<T>
    extends ValuesCompletionProvider<T>
    implements DumbAware {
        public ValuesCompletionProviderDumbAware(@NotNull TextCompletionValueDescriptor<T> descriptor2, @NotNull List<Character> separators, @NotNull Collection<? extends T> values, boolean caseSensitive) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/util/textCompletion/ValuesCompletionProvider$ValuesCompletionProviderDumbAware", "<init>"));
            }
            if (separators == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separators", "com/intellij/util/textCompletion/ValuesCompletionProvider$ValuesCompletionProviderDumbAware", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/textCompletion/ValuesCompletionProvider$ValuesCompletionProviderDumbAware", "<init>"));
            }
            super(descriptor2, separators, values, caseSensitive);
        }

        public ValuesCompletionProviderDumbAware(@NotNull TextCompletionValueDescriptor<T> presentation, @NotNull Collection<? extends T> values) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/util/textCompletion/ValuesCompletionProvider$ValuesCompletionProviderDumbAware", "<init>"));
            }
            if (values == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/textCompletion/ValuesCompletionProvider$ValuesCompletionProviderDumbAware", "<init>"));
            }
            super(presentation, values);
        }
    }

    public class CompletionCharInsertHandler
    implements InsertHandler<LookupElement> {
        public void handleInsert(InsertionContext context2, LookupElement item) {
            context2.setAddCompletionChar(ValuesCompletionProvider.this.mySeparators.contains(Character.valueOf(context2.getCompletionChar())));
        }
    }
}

