/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckBoxListModelEditor<T> {
    private final CheckBoxList<T> list;
    private final ToolbarDecorator toolbarDecorator;
    private final Function<T, String> toNameConverter;

    public CheckBoxListModelEditor(@NotNull Function<T, String> toNameConverter, @NotNull String emptyText) {
        if (toNameConverter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toNameConverter", "com/intellij/util/ui/CheckBoxListModelEditor", "<init>"));
        }
        if (emptyText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "emptyText", "com/intellij/util/ui/CheckBoxListModelEditor", "<init>"));
        }
        this.toNameConverter = toNameConverter;
        this.list = new CheckBoxList();
        this.list.setEmptyText(emptyText);
        this.list.setBorder(null);
        this.toolbarDecorator = ToolbarDecorator.createDecorator(this.list);
    }

    @NotNull
    public CheckBoxListModelEditor<T> editAction(@NotNull Function<T, T> consumer2) {
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/ui/CheckBoxListModelEditor", "editAction"));
        }
        final Runnable action2 = () -> {
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/ui/CheckBoxListModelEditor", "lambda$editAction$0"));
            }
            T item = this.getSelectedItem();
            if (item != null) {
                Object newItem = consumer2.fun(item);
                if (newItem != null) {
                    this.list.updateItem(item, newItem, StringUtil.notNullize((String)((String)this.toNameConverter.fun(newItem))));
                }
                this.list.requestFocus();
            }
        };
        this.toolbarDecorator.setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                action2.run();
            }
        });
        EditSourceOnDoubleClickHandler.install(this.list, (Runnable)action2);
        CheckBoxListModelEditor checkBoxListModelEditor = this;
        if (checkBoxListModelEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CheckBoxListModelEditor", "editAction"));
        }
        return checkBoxListModelEditor;
    }

    @NotNull
    public CheckBoxListModelEditor<T> copyAction(final @NotNull Consumer<T> consumer2) {
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/util/ui/CheckBoxListModelEditor", "copyAction"));
        }
        this.toolbarDecorator.addExtraAction((AnActionButton)new ToolbarDecorator.ElementActionButton(IdeBundle.message((String)"button.copy", (Object[])new Object[0]), PlatformIcons.COPY_ICON){

            public void actionPerformed(AnActionEvent e2) {
                int[] indices = CheckBoxListModelEditor.this.list.getSelectedIndices();
                if (indices == null || indices.length == 0) {
                    return;
                }
                for (int index : indices) {
                    Object item = CheckBoxListModelEditor.this.list.getItemAt(index);
                    if (item == null) continue;
                    consumer2.consume(item);
                }
            }
        });
        CheckBoxListModelEditor checkBoxListModelEditor = this;
        if (checkBoxListModelEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CheckBoxListModelEditor", "copyAction"));
        }
        return checkBoxListModelEditor;
    }

    public ToolbarDecorator getToolbar() {
        return this.toolbarDecorator;
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.toolbarDecorator.createPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CheckBoxListModelEditor", "createComponent"));
        }
        return jPanel;
    }

    @NotNull
    public DefaultListModel getModel() {
        DefaultListModel defaultListModel = (DefaultListModel)this.list.getModel();
        if (defaultListModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CheckBoxListModelEditor", "getModel"));
        }
        return defaultListModel;
    }

    public void selectItemByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ui/CheckBoxListModelEditor", "selectItemByName"));
        }
        for (int i2 = 0; i2 < this.list.getItemsCount(); ++i2) {
            Object item = this.list.getItemAt(i2);
            if (item == null || !name.equalsIgnoreCase((String)this.toNameConverter.fun(item))) continue;
            this.list.setSelectedIndex(i2);
        }
    }

    @Nullable
    private T getSelectedItem() {
        int index = this.list.getSelectedIndex();
        return (T)(index == -1 ? null : this.list.getItemAt(index));
    }

    public CheckBoxList<T> getList() {
        return this.list;
    }

    public void reset(@NotNull List<Pair<T, Boolean>> items2) {
        if (items2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/util/ui/CheckBoxListModelEditor", "reset"));
        }
        this.list.clear();
        for (Pair<T, Boolean> item : items2) {
            this.list.addItem(item.first, (String)this.toNameConverter.fun(item.first), ((Boolean)item.second).booleanValue());
        }
    }

    public boolean isModified(@NotNull List<Pair<T, Boolean>> oldItems) {
        if (oldItems == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldItems", "com/intellij/util/ui/CheckBoxListModelEditor", "isModified"));
        }
        if (oldItems.size() != this.list.getItemsCount()) {
            return true;
        }
        for (int i2 = 0; i2 < this.list.getItemsCount(); ++i2) {
            Object item = this.list.getItemAt(i2);
            if (item == null) {
                return true;
            }
            Pair<T, Boolean> oldItem = oldItems.get(i2);
            if (((Boolean)oldItem.second).booleanValue() == this.list.isItemSelected(i2) && oldItem.first.equals(item)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<T> getItems() {
        int count = this.list.getItemsCount();
        ArrayList<Object> result2 = new ArrayList<Object>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            Object item = this.list.getItemAt(i2);
            if (item == null) continue;
            result2.add(item);
        }
        ArrayList<Object> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CheckBoxListModelEditor", "getItems"));
        }
        return arrayList;
    }

    @NotNull
    public List<Pair<T, Boolean>> apply() {
        int count = this.list.getItemsCount();
        ArrayList<Pair<T, Boolean>> result2 = new ArrayList<Pair<T, Boolean>>(count);
        for (int i2 = 0; i2 < count; ++i2) {
            Object item = this.list.getItemAt(i2);
            if (item == null) continue;
            result2.add(Pair.create((Object)item, (Object)this.list.isItemSelected(i2)));
        }
        ArrayList<Pair<T, Boolean>> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/CheckBoxListModelEditor", "apply"));
        }
        return arrayList;
    }
}

