/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class HtmlPanel
extends JEditorPane
implements HyperlinkListener {
    public HtmlPanel() {
        super("text/html", "");
        this.setEditable(false);
        this.setOpaque(false);
        this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.addHyperlinkListener(this);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e2) {
        BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e2);
    }

    @Override
    public String getSelectedText() {
        Document doc = this.getDocument();
        int start2 = this.getSelectionStart();
        int end = this.getSelectionEnd();
        try {
            Position p0 = doc.createPosition(start2);
            Position p1 = doc.createPosition(end);
            StringWriter sw = new StringWriter(p1.getOffset() - p0.getOffset());
            this.getEditorKit().write(sw, doc, p0.getOffset(), p1.getOffset() - p0.getOffset());
            return StringUtil.removeHtmlTags((String)sw.toString());
        }
        catch (IOException | BadLocationException exception) {
            return super.getSelectedText();
        }
    }
}

