/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReloadablePanel<T> {
    private static final String CONTROL_PLACE = "UI.Configuration.Component.Reload.Panel";
    private final AsyncProcessIcon myLoadingVersionIcon = new AsyncProcessIcon("Getting possible values");
    private final JLabel myErrorMessage = new JLabel();
    @Nullable
    private volatile DataProvider<T> myDataProvider;
    @Nullable
    private volatile UpdateStatus myUpdateStatus;
    protected JPanel myActionPanel;

    public ReloadablePanel() {
        this.myErrorMessage.setForeground((Color)JBColor.RED);
        this.createActionPanel();
        this.fillActionPanel();
    }

    private void createActionPanel() {
        this.myActionPanel = new JPanel(new CardLayout());
    }

    public final void setDataProvider(@NotNull DataProvider<T> dataProvider) {
        if (dataProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/util/ui/ReloadablePanel", "setDataProvider"));
        }
        this.myDataProvider = dataProvider;
        Set<T> cachedValues = dataProvider.getCachedValues();
        if (cachedValues != null) {
            this.onUpdateValues(cachedValues);
        }
    }

    protected abstract void doUpdateValues(@NotNull Set<T> var1);

    public abstract T getSelectedValue();

    @NotNull
    public final JLabel getErrorComponent() {
        JLabel jLabel = this.myErrorMessage;
        if (jLabel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ReloadablePanel", "getErrorComponent"));
        }
        return jLabel;
    }

    public final boolean isBackgroundJobRunning() {
        return this.myUpdateStatus == UpdateStatus.UPDATING;
    }

    public final void onUpdateValues(@NotNull Set<T> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/util/ui/ReloadablePanel", "onUpdateValues"));
        }
        this.changeUpdateStatus(UpdateStatus.IDLE);
        this.doUpdateValues(values);
    }

    public final void reloadValuesInBackground() {
        if (this.myUpdateStatus == UpdateStatus.UPDATING) {
            return;
        }
        this.changeUpdateStatus(UpdateStatus.UPDATING);
        this.myErrorMessage.setText(null);
        DataProvider<T> provider = this.myDataProvider;
        assert (provider != null);
        provider.updateValuesAsynchronously();
    }

    private void changeUpdateStatus(@NotNull UpdateStatus status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/util/ui/ReloadablePanel", "changeUpdateStatus"));
        }
        CardLayout cardLayout = (CardLayout)this.myActionPanel.getLayout();
        cardLayout.show(this.myActionPanel, status.name());
        if (status == UpdateStatus.UPDATING) {
            this.myLoadingVersionIcon.resume();
        } else {
            this.myLoadingVersionIcon.suspend();
        }
        this.myUpdateStatus = status;
    }

    protected void fillActionPanel() {
        this.myActionPanel.add((Component)this.createReloadButtonPanel(), UpdateStatus.IDLE.name());
        this.myActionPanel.add((Component)this.createReloadInProgressPanel(), UpdateStatus.UPDATING.name());
        this.changeUpdateStatus(UpdateStatus.IDLE);
    }

    public final void onValuesUpdateError(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/util/ui/ReloadablePanel", "onValuesUpdateError"));
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/util/ui/ReloadablePanel", "lambda$onValuesUpdateError$0"));
            }
            if (this.getSelectedValue() == null) {
                this.myErrorMessage.setText(errorMessage);
            }
            this.changeUpdateStatus(UpdateStatus.IDLE);
        });
    }

    @NotNull
    private JPanel createReloadButtonPanel() {
        ReloadAction reloadAction = new ReloadAction();
        ActionButton reloadButton = new ActionButton(reloadAction, reloadAction.getTemplatePresentation().clone(), CONTROL_PLACE, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        JPanel panel2 = new JPanel(new BorderLayout(0, 0));
        panel2.add((Component)reloadButton, "West");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ReloadablePanel", "createReloadButtonPanel"));
        }
        return jPanel;
    }

    @NotNull
    public abstract JPanel getMainPanel();

    @NotNull
    JPanel getActionPanel() {
        JPanel jPanel = this.myActionPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ReloadablePanel", "getActionPanel"));
        }
        return jPanel;
    }

    @NotNull
    private JPanel createReloadInProgressPanel() {
        JPanel panel2 = new JPanel();
        panel2.add((Component)this.myLoadingVersionIcon);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/ReloadablePanel", "createReloadInProgressPanel"));
        }
        return jPanel;
    }

    private static enum UpdateStatus {
        UPDATING,
        IDLE;

    }

    private final class ReloadAction
    extends AnAction {
        private ReloadAction() {
            super("Reload list", null, AllIcons.Actions.Refresh);
        }

        public void actionPerformed(AnActionEvent e2) {
            ReloadablePanel.this.reloadValuesInBackground();
        }

        public void update(AnActionEvent e2) {
            e2.getPresentation().setEnabled(true);
        }
    }

    public static interface DataProvider<T> {
        @Nullable
        public Set<T> getCachedValues();

        public void updateValuesAsynchronously();
    }
}

