/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.NonExhaustiveEnum;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumConverter<T extends Enum>
extends ResolvingConverter<T> {
    private static final ConcurrentFactoryMap<Class, EnumConverter> ourCache = new ConcurrentFactoryMap<Class, EnumConverter>(){

        @NotNull
        protected EnumConverter create(Class key) {
            EnumConverter enumConverter = new EnumConverter(key);
            if (enumConverter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/EnumConverter$1", "create"));
            }
            return enumConverter;
        }
    };
    private final Class<T> myType;

    private EnumConverter(Class<T> aClass) {
        this.myType = aClass;
    }

    public static <T extends Enum> EnumConverter<T> createEnumConverter(Class<T> aClass) {
        return (EnumConverter)((Object)ourCache.get(aClass));
    }

    private String getStringValue(T anEnum) {
        return NamedEnumUtil.getEnumValueByElement(anEnum);
    }

    public final T fromString(String s2, ConvertContext context2) {
        return (T)(s2 == null ? null : NamedEnumUtil.getEnumElementByValue(this.myType, (String)s2));
    }

    public final String toString(T t2, ConvertContext context2) {
        return t2 == null ? null : this.getStringValue(t2);
    }

    public String getErrorMessage(@Nullable String s2, ConvertContext context2) {
        return CodeInsightBundle.message((String)"error.unknown.enum.value.message", (Object[])new Object[]{s2});
    }

    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context2) {
        XmlTag simpleContent;
        XmlElement element = context2.getXmlElement();
        if (element instanceof XmlTag && (simpleContent = XmlUtil.getSchemaSimpleContent((XmlTag)element)) != null && XmlUtil.collectEnumerationValues(simpleContent, new HashSet<String>())) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/EnumConverter", "getVariants"));
            }
            return list2;
        }
        List<T> list3 = Arrays.asList(this.myType.getEnumConstants());
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/EnumConverter", "getVariants"));
        }
        return list3;
    }

    public boolean isExhaustive() {
        return !ReflectionUtil.isAssignable(NonExhaustiveEnum.class, this.myType);
    }
}

