/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public class DefineAttributeQuickFix
implements LocalQuickFix {
    private final String myAttrName;
    private final String myNamespace;

    public DefineAttributeQuickFix(String attrName) {
        this(attrName, "");
    }

    public DefineAttributeQuickFix(@NotNull String attrName, @NotNull String namespace) {
        if (attrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrName", "com/intellij/util/xml/highlighting/DefineAttributeQuickFix", "<init>"));
        }
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/util/xml/highlighting/DefineAttributeQuickFix", "<init>"));
        }
        this.myAttrName = attrName;
        this.myNamespace = namespace;
    }

    @NotNull
    public String getName() {
        String string2 = "Define " + this.myAttrName + " attribute";
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DefineAttributeQuickFix", "getName"));
        }
        return string2;
    }

    @NotNull
    public String getFamilyName() {
        if ("Define attribute" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/highlighting/DefineAttributeQuickFix", "getFamilyName"));
        }
        return "Define attribute";
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/xml/highlighting/DefineAttributeQuickFix", "applyFix"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/util/xml/highlighting/DefineAttributeQuickFix", "applyFix"));
        }
        XmlTag tag = (XmlTag)descriptor2.getPsiElement();
        XmlAttribute attribute = tag.setAttribute(this.myAttrName, this.myNamespace, "");
        new OpenFileDescriptor(project2, tag.getContainingFile().getVirtualFile(), attribute.getValueElement().getTextRange().getStartOffset() + 1).navigate(true);
    }
}

