/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.presentation.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.ElementPresentationTemplate;
import com.intellij.util.xml.Stubbed;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.ElementPresentationTemplateImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.DomExtensionImpl;
import gnu.trove.THashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDomChildDescriptionImpl
implements AbstractDomChildrenDescription,
Comparable<AbstractDomChildDescriptionImpl> {
    private final Type myType;
    private Map<Class, Annotation> myCustomAnnotations;
    @Nullable
    private Map myUserMap;
    private volatile Ref<ElementPresentationTemplate> myPresentationTemplate = null;
    private volatile Boolean myStubbed;

    @Nullable
    private ElementPresentationTemplate calcPresentationTemplate() {
        Class clazz = ReflectionUtil.getRawType((Type)this.getType());
        Presentation presentation = DomApplicationComponent.getInstance().getInvocationCache(clazz).getClassAnnotation(Presentation.class);
        return presentation == null ? null : new ElementPresentationTemplateImpl(presentation, clazz);
    }

    protected AbstractDomChildDescriptionImpl(Type type) {
        this.myType = type;
    }

    public final void addCustomAnnotation(@NotNull Annotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "addCustomAnnotation"));
        }
        if (this.myCustomAnnotations == null) {
            this.myCustomAnnotations = new THashMap();
        }
        this.myCustomAnnotations.put(annotation.annotationType(), annotation);
    }

    private boolean calcStubbed() {
        return this.myType instanceof Class && DomReflectionUtil.findAnnotationDFS((Class)((Class)this.myType), Stubbed.class) != null || this.getAnnotation(Stubbed.class) != null;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AbstractDomChildDescriptionImpl that = (AbstractDomChildDescriptionImpl)o2;
        if (this.myCustomAnnotations != null ? !this.myCustomAnnotations.equals(that.myCustomAnnotations) : that.myCustomAnnotations != null) {
            return false;
        }
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        return !(this.myUserMap != null ? !this.myUserMap.equals(that.myUserMap) : that.myUserMap != null);
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + (this.myCustomAnnotations != null ? this.myCustomAnnotations.hashCode() : 0);
        result2 = 31 * result2 + (this.myUserMap != null ? this.myUserMap.hashCode() : 0);
        return result2;
    }

    public void setUserMap(Map userMap) {
        this.myUserMap = userMap;
    }

    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)(this.myCustomAnnotations == null ? null : this.myCustomAnnotations.get(annotationClass));
    }

    public <T> T getUserData(Key<T> key) {
        return this.myUserMap == null ? null : (T)this.myUserMap.get(key);
    }

    @NotNull
    public final List<? extends DomElement> getStableValues(@NotNull DomElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getStableValues"));
        }
        List list2 = this.getValues(parent);
        ArrayList<DomElement> result2 = new ArrayList<DomElement>(list2.size());
        DomManager domManager = parent.getManager();
        int i2 = 0;
        while (i2 < list2.size()) {
            int i1 = i2++;
            result2.add(domManager.createStableValue(() -> {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "lambda$getStableValues$0"));
                }
                if (!parent.isValid()) {
                    return null;
                }
                List domElements = this.getValues(parent);
                return domElements.size() > i1 ? (DomElement)domElements.get(i1) : null;
            }));
        }
        ArrayList<DomElement> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getStableValues"));
        }
        return arrayList;
    }

    @NotNull
    public final Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getType"));
        }
        return type;
    }

    @NotNull
    public DomNameStrategy getDomNameStrategy(@NotNull DomElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getDomNameStrategy"));
        }
        DomNameStrategy strategy = DomImplUtil.getDomNameStrategy(ReflectionUtil.getRawType((Type)this.getType()), false);
        DomNameStrategy domNameStrategy = strategy == null ? parent.getNameStrategy() : strategy;
        if (domNameStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/AbstractDomChildDescriptionImpl", "getDomNameStrategy"));
        }
        return domNameStrategy;
    }

    public boolean isValid() {
        return true;
    }

    public void navigate(boolean requestFocus2) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    public ElementPresentationTemplate getPresentationTemplate() {
        Ref ref = this.myPresentationTemplate;
        if (ref == null) {
            this.myPresentationTemplate = ref = Ref.create((Object)this.calcPresentationTemplate());
        }
        return (ElementPresentationTemplate)ref.get();
    }

    @Nullable
    public PsiElement getDeclaration(Project project2) {
        PsiElement element;
        DomElement domDeclaration = this.getDomDeclaration();
        if (domDeclaration != null) {
            DomTarget target = DomTarget.getTarget((DomElement)domDeclaration);
            if (target != null) {
                return PomService.convertToPsi((PsiTarget)target);
            }
            return domDeclaration.getXmlElement();
        }
        DomAnchor anchor = this.getUserData(DomExtensionImpl.KEY_DOM_DECLARATION);
        if (anchor != null) {
            return anchor.getContainingFile();
        }
        SmartPsiElementPointer<?> pointer = this.getUserData(DomExtensionImpl.DECLARING_ELEMENT_KEY);
        if (pointer != null && (element = pointer.getElement()) != null) {
            return element;
        }
        return PomService.convertToPsi((Project)project2, (PomTarget)this);
    }

    public DomElement getDomDeclaration() {
        DomAnchor anchor = this.getUserData(DomExtensionImpl.KEY_DOM_DECLARATION);
        if (anchor != null) {
            return anchor.retrieveDomElement();
        }
        return null;
    }

    public boolean isStubbed() {
        Boolean stubbed = this.myStubbed;
        if (stubbed == null) {
            this.myStubbed = stubbed = Boolean.valueOf(this.calcStubbed());
        }
        return stubbed;
    }
}

