/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomAnchorImpl<T extends DomElement>
implements DomAnchor<T> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.xml.impl.DomAnchorImpl");

    public static <T extends DomElement> DomAnchor<T> createAnchor(@NotNull T t2) {
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/xml/impl/DomAnchorImpl", "createAnchor"));
        }
        return DomAnchorImpl.createAnchor(t2, true);
    }

    public static <T extends DomElement> DomAnchor<T> createAnchor(@NotNull T t2, boolean usePsi) {
        int index;
        XmlElement element;
        if (t2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/util/xml/impl/DomAnchorImpl", "createAnchor"));
        }
        DomInvocationHandler handler2 = DomManagerImpl.getNotNullHandler(t2);
        if (handler2.getStub() != null) {
            return new StubAnchor(handler2);
        }
        if (usePsi && (element = t2.getXmlElement()) != null) {
            return new PsiBasedDomAnchor(PsiAnchor.create((PsiElement)element), element.getProject());
        }
        DomElement parent = t2.getParent();
        if (parent == null) {
            LOG.error("Parent null: " + t2);
        }
        if (parent instanceof DomFileElementImpl) {
            DomFileElementImpl fileElement = (DomFileElementImpl)parent;
            return new RootAnchor(fileElement.getFile(), fileElement.getRootElementClass());
        }
        DomAnchor<DomElement> parentAnchor = DomAnchorImpl.createAnchor(parent);
        String name = t2.getGenericInfo().getElementName(t2);
        AbstractDomChildrenDescription description = t2.getChildDescription();
        List values = description.getValues(parent);
        if (name != null) {
            int i2 = 0;
            for (DomElement value2 : values) {
                if (value2.equals(t2)) {
                    return new NamedAnchor(parentAnchor, description, name, i2);
                }
                if (!name.equals(value2.getGenericInfo().getElementName(value2))) continue;
                ++i2;
            }
        }
        if ((index = values.indexOf(t2)) < 0) {
            DomAnchorImpl.diagnoseNegativeIndex2(t2, parent, description, values);
        }
        return new IndexedAnchor(parentAnchor, description, index);
    }

    private static <T extends DomElement> void diagnoseNegativeIndex2(T t2, DomElement parent, AbstractDomChildrenDescription description, List<? extends DomElement> values) {
        XmlTag parentTag = parent.getXmlTag();
        StringBuilder diag = new StringBuilder("Index<0: description=" + description + "\nparent=" + parent + "\nt=" + t2 + "\nvalues=" + values + "\n");
        int size = values.size();
        for (int i2 = 0; i2 < size; ++i2) {
            DomElement value2 = values.get(i2);
            if (!value2.toString().equals(t2.toString())) continue;
            XmlElement tElement = t2.getXmlElement();
            XmlElement valElement = value2.getXmlElement();
            diag.append(" hasSame, i=" + i2 + "; same=" + (value2 == t2) + ", equal=" + value2.equals(t2) + ", equal2=" + t2.equals(value2) + ", t.physical=" + (tElement == null ? "null" : String.valueOf(tElement.isPhysical())) + ", value.physical=" + (valElement == null ? "null" : String.valueOf(valElement.isPhysical())) + ", sameElements=" + (tElement == value2.getXmlElement()) + "\n");
            if (tElement == null || valElement == null) continue;
            diag.append("  sameFile=" + (tElement.getContainingFile() == valElement.getContainingFile()) + ", sameParent=" + (tElement.getParent() == valElement.getParent()) + "\n");
        }
        if (parentTag != null) {
            diag.append("Parent tag: ").append(parentTag.getName()).append("\n");
            if (t2 instanceof GenericAttributeValue) {
                for (XmlAttribute attribute : parentTag.getAttributes()) {
                    diag.append(", attr: ").append(attribute.getName());
                }
                diag.append("\n");
            } else {
                for (XmlTag tag : parentTag.getSubTags()) {
                    diag.append("\n subtag: ").append(tag.getName());
                }
                diag.append("\n");
            }
        }
        diag.append("Child name: ").append(t2.getXmlElementName()).append(";").append(t2.getXmlElementNamespaceKey());
        LOG.error((Object)diag);
    }

    public PsiElement getPsiElement() {
        T t2 = this.retrieveDomElement();
        return t2 == null ? null : t2.getXmlElement();
    }

    @Nullable
    public abstract T retrieveDomElement();

    @NotNull
    public abstract XmlFile getContainingFile();

    private static class StubAnchor<T extends DomElement>
    implements DomAnchor<T> {
        private final DomInvocationHandler myHandler;

        private StubAnchor(DomInvocationHandler handler2) {
            this.myHandler = handler2;
        }

        @Nullable
        public T retrieveDomElement() {
            return (T)this.myHandler.getProxy();
        }

        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myHandler.getFile();
            if (xmlFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$StubAnchor", "getContainingFile"));
            }
            return xmlFile;
        }

        @Nullable
        public PsiElement getPsiElement() {
            return this.myHandler.getXmlElement();
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            StubAnchor anchor = (StubAnchor)o2;
            return !(this.myHandler != null ? !this.myHandler.equals((Object)anchor.myHandler) : anchor.myHandler != null);
        }

        public int hashCode() {
            return this.myHandler != null ? this.myHandler.hashCode() : 0;
        }
    }

    private static class PsiBasedDomAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final PsiAnchor myAnchor;
        private final Project myProject;

        public PsiBasedDomAnchor(PsiAnchor anchor, Project project2) {
            this.myAnchor = anchor;
            this.myProject = project2;
        }

        @Override
        public T retrieveDomElement() {
            PsiElement psi = this.myAnchor.retrieve();
            if (psi == null) {
                return null;
            }
            if (psi instanceof XmlTag) {
                return (T)DomManager.getDomManager((Project)this.myProject).getDomElement((XmlTag)psi);
            }
            if (psi instanceof XmlAttribute) {
                return (T)DomManager.getDomManager((Project)this.myProject).getDomElement((XmlAttribute)psi);
            }
            return null;
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = (XmlFile)this.myAnchor.getFile();
            if (xmlFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$PsiBasedDomAnchor", "getContainingFile"));
            }
            return xmlFile;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            PsiBasedDomAnchor anchor = (PsiBasedDomAnchor)o2;
            if (this.myAnchor != null ? !this.myAnchor.equals(anchor.myAnchor) : anchor.myAnchor != null) {
                return false;
            }
            return !(this.myProject != null ? !this.myProject.equals(anchor.myProject) : anchor.myProject != null);
        }

        public int hashCode() {
            int result2 = this.myAnchor != null ? this.myAnchor.hashCode() : 0;
            result2 = 31 * result2 + (this.myProject != null ? this.myProject.hashCode() : 0);
            return result2;
        }
    }

    private static class RootAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final XmlFile myFile;
        private final Class<T> myClass;

        private RootAnchor(XmlFile file2, Class<T> aClass) {
            this.myFile = file2;
            this.myClass = aClass;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof RootAnchor)) {
                return false;
            }
            RootAnchor that = (RootAnchor)o2;
            if (this.myClass != null ? !this.myClass.equals(that.myClass) : that.myClass != null) {
                return false;
            }
            return !(this.myFile != null ? !this.myFile.equals(that.myFile) : that.myFile != null);
        }

        public int hashCode() {
            int result2 = this.myFile != null ? this.myFile.hashCode() : 0;
            result2 = 31 * result2 + (this.myClass != null ? this.myClass.hashCode() : 0);
            return result2;
        }

        @Override
        public T retrieveDomElement() {
            DomFileElement fileElement = DomManager.getDomManager((Project)this.myFile.getProject()).getFileElement(this.myFile, this.myClass);
            return (T)(fileElement == null ? null : fileElement.getRootElement());
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myFile;
            if (xmlFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$RootAnchor", "getContainingFile"));
            }
            return xmlFile;
        }
    }

    private static class IndexedAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final DomAnchor myParent;
        private final AbstractDomChildrenDescription myDescr;
        private final int myIndex;

        private IndexedAnchor(DomAnchor parent, AbstractDomChildrenDescription descr, int index) {
            this.myParent = parent;
            this.myDescr = descr;
            this.myIndex = index;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof IndexedAnchor)) {
                return false;
            }
            IndexedAnchor that = (IndexedAnchor)o2;
            if (this.myIndex != that.myIndex) {
                return false;
            }
            if (this.myDescr != null ? !this.myDescr.equals(that.myDescr) : that.myDescr != null) {
                return false;
            }
            return !(this.myParent != null ? !this.myParent.equals(that.myParent) : that.myParent != null);
        }

        public int hashCode() {
            int result2 = this.myParent != null ? this.myParent.hashCode() : 0;
            result2 = 31 * result2 + (this.myDescr != null ? this.myDescr.hashCode() : 0);
            result2 = 31 * result2 + this.myIndex;
            return result2;
        }

        @Override
        public T retrieveDomElement() {
            DomElement parent = this.myParent.retrieveDomElement();
            if (parent == null) {
                return null;
            }
            List list2 = this.myDescr.getValues(parent);
            if (this.myIndex < 0 || this.myIndex >= list2.size()) {
                return null;
            }
            return (T)((DomElement)list2.get(this.myIndex));
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myParent.getContainingFile();
            if (xmlFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$IndexedAnchor", "getContainingFile"));
            }
            return xmlFile;
        }
    }

    private static class NamedAnchor<T extends DomElement>
    extends DomAnchorImpl<T> {
        private final DomAnchor myParent;
        private final AbstractDomChildrenDescription myDescr;
        private final String myName;
        private final int myIndex;

        private NamedAnchor(DomAnchor parent, AbstractDomChildrenDescription descr, String id, int index) {
            this.myParent = parent;
            this.myDescr = descr;
            this.myName = id;
            this.myIndex = index;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof NamedAnchor)) {
                return false;
            }
            NamedAnchor that = (NamedAnchor)o2;
            if (this.myDescr != null ? !this.myDescr.equals(that.myDescr) : that.myDescr != null) {
                return false;
            }
            if (this.myName != null ? !this.myName.equals(that.myName) : that.myName != null) {
                return false;
            }
            if (this.myParent != null ? !this.myParent.equals(that.myParent) : that.myParent != null) {
                return false;
            }
            return this.myIndex == that.myIndex;
        }

        public int hashCode() {
            int result2 = this.myParent != null ? this.myParent.hashCode() : 0;
            result2 = 31 * result2 + (this.myDescr != null ? this.myDescr.hashCode() : 0);
            result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
            result2 = 31 * result2 + this.myIndex;
            return result2;
        }

        @Override
        public T retrieveDomElement() {
            DomElement parent = this.myParent.retrieveDomElement();
            if (parent == null) {
                return null;
            }
            List list2 = this.myDescr.getValues(parent);
            int i2 = 0;
            for (DomElement element : list2) {
                String s2 = element.getGenericInfo().getElementName(element);
                if (!this.myName.equals(s2)) continue;
                if (i2 == this.myIndex) {
                    return (T)element;
                }
                ++i2;
            }
            return null;
        }

        @Override
        @NotNull
        public XmlFile getContainingFile() {
            XmlFile xmlFile = this.myParent.getContainingFile();
            if (xmlFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DomAnchorImpl$NamedAnchor", "getContainingFile"));
            }
            return xmlFile;
        }
    }
}

