/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.LegacyCompletionContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.getters.XmlAttributeValueGetter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.impl.GenericValueReferenceProvider;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;

public class DomCompletionContributor
extends CompletionContributor {
    private final GenericValueReferenceProvider myProvider = new GenericValueReferenceProvider();

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/util/xml/impl/DomCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/xml/impl/DomCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        if (this.domKnowsBetter(parameters, result2)) {
            result2.stopHere();
        }
    }

    private boolean domKnowsBetter(CompletionParameters parameters, CompletionResultSet result2) {
        PsiReference[] references;
        XmlAttributeDescriptor descriptor2;
        XmlAttributeValue element = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlAttributeValue.class);
        if (element == null) {
            return false;
        }
        if (DomCompletionContributor.isSchemaEnumerated((PsiElement)element)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute && (descriptor2 = ((XmlAttribute)parent).getDescriptor()) != null && descriptor2.getDefaultValue() != null && (references = this.myProvider.getReferencesByElement((PsiElement)element, new ProcessingContext())).length > 0) {
            return LegacyCompletionContributor.completeReference(parameters, result2);
        }
        return false;
    }

    public static boolean isSchemaEnumerated(PsiElement element) {
        PsiElement parent;
        XmlTag simpleContent;
        if (element instanceof XmlTag && (simpleContent = XmlUtil.getSchemaSimpleContent((XmlTag)element)) != null && XmlUtil.collectEnumerationValues(simpleContent, (java.util.HashSet<String>)new HashSet())) {
            return true;
        }
        if (element instanceof XmlAttributeValue && (parent = element.getParent()) instanceof XmlAttribute) {
            XmlAttributeDescriptor descriptor2 = ((XmlAttribute)parent).getDescriptor();
            if (descriptor2 != null && descriptor2.isEnumerated()) {
                return true;
            }
            String[] enumeratedValues = XmlAttributeValueGetter.getEnumeratedValues((XmlAttribute)parent);
            if (enumeratedValues.length > 0) {
                String value2;
                String string2 = value2 = descriptor2 == null ? null : descriptor2.getDefaultValue();
                if (value2 == null || enumeratedValues.length != 1 || !value2.equals(enumeratedValues[0])) {
                    return true;
                }
            }
        }
        return false;
    }
}

