/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildInvocationHandler;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomRootInvocationHandler;
import com.intellij.util.xml.impl.FileDescriptionCachedValueProvider;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.IndexedElementInvocationHandler;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import com.intellij.util.xml.reflect.DomChildrenDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStub;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomSemContributor
extends SemContributor {
    private final SemService mySemService;

    public DomSemContributor(SemService semService) {
        this.mySemService = semService;
    }

    public void registerSemProviders(SemRegistrar registrar) {
        registrar.registerSemElementProvider(DomManagerImpl.FILE_DESCRIPTION_KEY, (ElementPattern)XmlPatterns.xmlFile(), xmlFile -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            return new FileDescriptionCachedValueProvider(DomManagerImpl.getDomManager(xmlFile.getProject()), (XmlFile)xmlFile);
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_HANDLER_KEY, (ElementPattern)XmlPatterns.xmlTag().withParent((ElementPattern)XmlPatterns.psiElement((IElementType)XmlElementType.XML_DOCUMENT).withParent((ElementPattern)XmlPatterns.xmlFile())), xmlTag -> {
            DomRootInvocationHandler handler2;
            FileDescriptionCachedValueProvider provider = (FileDescriptionCachedValueProvider)this.mySemService.getSemElement(DomManagerImpl.FILE_DESCRIPTION_KEY, (PsiElement)xmlTag.getContainingFile());
            assert (provider != null);
            DomFileElementImpl element = provider.getFileElement();
            if (element != null && (handler2 = element.getRootHandler()).getXmlTag() == xmlTag) {
                return handler2;
            }
            return null;
        });
        TreeElementPattern nonRootTag = XmlPatterns.xmlTag().withParent(XmlPatterns.or((ElementPattern[])new ElementPattern[]{XmlPatterns.xmlTag(), XmlPatterns.xmlEntityRef().withParent((ElementPattern)XmlPatterns.xmlTag())}));
        registrar.registerSemElementProvider(DomManagerImpl.DOM_INDEXED_HANDLER_KEY, (ElementPattern)nonRootTag, tag -> {
            XmlTag parentTag = PhysicalDomParentStrategy.getParentTag((XmlElement)tag);
            assert (parentTag != null);
            DomInvocationHandler parent = DomSemContributor.getParentDom(parentTag);
            if (parent == null) {
                return null;
            }
            String localName = tag.getLocalName();
            String namespace = tag.getNamespace();
            DomFixedChildDescription description = (DomFixedChildDescription)DomSemContributor.findChildrenDescription(parent.getGenericInfo().getFixedChildrenDescriptions(), tag, parent);
            if (description != null) {
                int totalCount = description.getCount();
                int index = 0;
                XmlTag current = tag;
                while ((current = current.getPrevSibling()) != null) {
                    XmlTag xmlTag;
                    if (!(current instanceof XmlTag) || !localName.equals((xmlTag = current).getLocalName()) || !namespace.equals(xmlTag.getNamespace()) || ++index < totalCount) continue;
                    return null;
                }
                DomManagerImpl myDomManager = parent.getManager();
                return new IndexedElementInvocationHandler(parent.createEvaluatedXmlName(description.getXmlName()), (FixedChildDescriptionImpl)description, index, new PhysicalDomParentStrategy((XmlElement)tag, myDomManager), myDomManager, null);
            }
            return null;
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_COLLECTION_HANDLER_KEY, (ElementPattern)nonRootTag, tag -> {
            XmlTag parentTag = PhysicalDomParentStrategy.getParentTag((XmlElement)tag);
            assert (parentTag != null);
            DomInvocationHandler parent = DomSemContributor.getParentDom(parentTag);
            if (parent == null) {
                return null;
            }
            DomCollectionChildDescription description = (DomCollectionChildDescription)DomSemContributor.findChildrenDescription(parent.getGenericInfo().getCollectionChildrenDescriptions(), tag, parent);
            if (description != null) {
                Object parentStub = parent.getStub();
                if (parentStub != null) {
                    int index = ArrayUtil.indexOf((Object[])parentTag.findSubTags(tag.getName(), tag.getNamespace()), (Object)tag);
                    ElementStub stub2 = ((DomStub)((Object)((Object)parentStub))).getElementStub(tag.getLocalName(), index);
                    if (stub2 != null) {
                        XmlName name = description.getXmlName();
                        EvaluatedXmlNameImpl evaluatedXmlName = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)name, (String)name.getNamespaceKey(), (boolean)true);
                        return new CollectionElementInvocationHandler((EvaluatedXmlName)evaluatedXmlName, (AbstractDomChildDescriptionImpl)description, parent.getManager(), stub2);
                    }
                }
                return new CollectionElementInvocationHandler(description.getType(), (XmlTag)tag, (AbstractCollectionChildDescription)description, parent, null);
            }
            return null;
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_CUSTOM_HANDLER_KEY, (ElementPattern)nonRootTag, (NullableFunction)new NullableFunction<XmlTag, CollectionElementInvocationHandler>(){
            private final RecursionGuard myGuard = RecursionManager.createGuard((String)"customDomParent");

            public CollectionElementInvocationHandler fun(XmlTag tag) {
                if (StringUtil.isEmpty((String)tag.getName())) {
                    return null;
                }
                XmlTag parentTag = PhysicalDomParentStrategy.getParentTag((XmlElement)tag);
                assert (parentTag != null);
                DomInvocationHandler parent = (DomInvocationHandler)((Object)this.myGuard.doPreventingRecursion((Object)tag, true, (Computable)((NullableComputable)() -> DomSemContributor.getParentDom(parentTag))));
                if (parent == null) {
                    return null;
                }
                DomGenericInfoEx info = parent.getGenericInfo();
                List customs = info.getCustomNameChildrenDescription();
                if (customs.isEmpty()) {
                    return null;
                }
                if (DomSemContributor.this.mySemService.getSemElement(DomManagerImpl.DOM_INDEXED_HANDLER_KEY, (PsiElement)tag) == null && DomSemContributor.this.mySemService.getSemElement(DomManagerImpl.DOM_COLLECTION_HANDLER_KEY, (PsiElement)tag) == null) {
                    String localName = tag.getLocalName();
                    XmlFile file2 = parent.getFile();
                    for (DomFixedChildDescription description : info.getFixedChildrenDescriptions()) {
                        XmlName xmlName = description.getXmlName();
                        if (!localName.equals(xmlName.getLocalName()) || !DomImplUtil.isNameSuitable(xmlName, tag, parent, file2)) continue;
                        return null;
                    }
                    for (DomFixedChildDescription description : customs) {
                        if (description.getTagNameDescriptor() == null) continue;
                        AbstractCollectionChildDescription desc = (AbstractCollectionChildDescription)description;
                        Type type = description.getType();
                        return new CollectionElementInvocationHandler(type, tag, desc, parent, null);
                    }
                }
                return null;
            }
        });
        registrar.registerSemElementProvider(DomManagerImpl.DOM_ATTRIBUTE_HANDLER_KEY, (ElementPattern)XmlPatterns.xmlAttribute(), attribute -> {
            DomInvocationHandler handler2;
            XmlTag tag = PhysicalDomParentStrategy.getParentTag((XmlElement)attribute);
            DomInvocationHandler domInvocationHandler = handler2 = tag == null ? null : DomSemContributor.getParentDom(tag);
            if (handler2 == null) {
                return null;
            }
            String localName = attribute.getLocalName();
            Ref result2 = Ref.create(null);
            handler2.getGenericInfo().processAttributeChildrenDescriptions((Processor<AttributeChildDescriptionImpl>)((Processor)description -> {
                EvaluatedXmlName evaluatedXmlName;
                String ns;
                if (description.getXmlName().getLocalName().equals(localName) && ((ns = (evaluatedXmlName = handler2.createEvaluatedXmlName(description.getXmlName())).getNamespace((XmlElement)tag, handler2.getFile())).equals(tag.getNamespace()) && localName.equals(attribute.getName()) || ns.equals(attribute.getNamespace()))) {
                    DomManagerImpl myDomManager = handler2.getManager();
                    AttributeChildInvocationHandler attributeHandler = new AttributeChildInvocationHandler(evaluatedXmlName, (AttributeChildDescriptionImpl)description, myDomManager, new PhysicalDomParentStrategy((XmlElement)attribute, myDomManager), null);
                    result2.set((Object)attributeHandler);
                    return false;
                }
                return true;
            }));
            return (AttributeChildInvocationHandler)((Object)((Object)result2.get()));
        });
    }

    @Nullable
    private static DomInvocationHandler getParentDom(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/util/xml/impl/DomSemContributor", "getParentDom"));
        }
        LinkedHashSet<XmlTag> allParents = new LinkedHashSet<XmlTag>();
        XmlTag each = tag;
        while (each instanceof XmlTag && allParents.add(each)) {
            each = PhysicalDomParentStrategy.getParentTagCandidate((XmlElement)each);
        }
        ArrayList list2 = new ArrayList(allParents);
        Collections.reverse(list2);
        DomManagerImpl manager = DomManagerImpl.getDomManager(tag.getProject());
        for (XmlTag xmlTag : list2) {
            manager.getDomHandler((XmlElement)xmlTag);
        }
        return manager.getDomHandler((XmlElement)tag);
    }

    @Nullable
    private static <T extends DomChildrenDescription> T findChildrenDescription(List<T> descriptions, XmlTag tag, DomInvocationHandler parent) {
        String localName = tag.getLocalName();
        String namespace = null;
        String qName = tag.getName();
        XmlFile file2 = parent.getFile();
        int size = descriptions.size();
        for (int i2 = 0; i2 < size; ++i2) {
            EvaluatedXmlName evaluatedXmlName;
            DomChildrenDescription description = (DomChildrenDescription)descriptions.get(i2);
            XmlName xmlName = description.getXmlName();
            if (!localName.equals(xmlName.getLocalName()) && !qName.equals(xmlName.getLocalName()) || !DomImplUtil.isNameSuitable(evaluatedXmlName = parent.createEvaluatedXmlName(xmlName), localName, qName, namespace == null ? tag.getNamespace() : namespace, file2)) continue;
            return (T)description;
        }
        return null;
    }
}

