/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.DomParentStrategy;
import com.intellij.util.xml.impl.PhysicalDomParentStrategy;
import org.jetbrains.annotations.NotNull;

public class VirtualDomParentStrategy
implements DomParentStrategy {
    private final DomInvocationHandler myParentHandler;
    private long myModCount;
    private final PsiFile myModificationTracker;

    public VirtualDomParentStrategy(@NotNull DomInvocationHandler parentHandler) {
        if (parentHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentHandler", "com/intellij/util/xml/impl/VirtualDomParentStrategy", "<init>"));
        }
        this.myParentHandler = parentHandler;
        this.myModificationTracker = parentHandler.getFile();
        this.myModCount = this.getModCount();
    }

    private long getModCount() {
        return this.myModificationTracker.getModificationStamp();
    }

    @Override
    @NotNull
    public DomInvocationHandler getParentHandler() {
        DomInvocationHandler domInvocationHandler = this.myParentHandler;
        if (domInvocationHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/VirtualDomParentStrategy", "getParentHandler"));
        }
        return domInvocationHandler;
    }

    @Override
    public XmlElement getXmlElement() {
        return null;
    }

    @Override
    @NotNull
    public synchronized DomParentStrategy refreshStrategy(DomInvocationHandler handler2) {
        if (!this.myParentHandler.isValid()) {
            VirtualDomParentStrategy virtualDomParentStrategy = this;
            if (virtualDomParentStrategy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/VirtualDomParentStrategy", "refreshStrategy"));
            }
            return virtualDomParentStrategy;
        }
        long modCount = this.getModCount();
        if (modCount != this.myModCount) {
            XmlElement xmlElement = handler2.recomputeXmlElement(this.myParentHandler);
            if (xmlElement != null) {
                PhysicalDomParentStrategy physicalDomParentStrategy = new PhysicalDomParentStrategy(xmlElement, DomManagerImpl.getDomManager(xmlElement.getProject()));
                if (physicalDomParentStrategy == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/VirtualDomParentStrategy", "refreshStrategy"));
                }
                return physicalDomParentStrategy;
            }
            this.myModCount = modCount;
        }
        VirtualDomParentStrategy virtualDomParentStrategy = this;
        if (virtualDomParentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/VirtualDomParentStrategy", "refreshStrategy"));
        }
        return virtualDomParentStrategy;
    }

    @Override
    @NotNull
    public DomParentStrategy setXmlElement(@NotNull XmlElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xml/impl/VirtualDomParentStrategy", "setXmlElement"));
        }
        PhysicalDomParentStrategy physicalDomParentStrategy = new PhysicalDomParentStrategy(element, DomManagerImpl.getDomManager(element.getProject()));
        if (physicalDomParentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/VirtualDomParentStrategy", "setXmlElement"));
        }
        return physicalDomParentStrategy;
    }

    @Override
    @NotNull
    public synchronized DomParentStrategy clearXmlElement() {
        this.myModCount = this.getModCount();
        VirtualDomParentStrategy virtualDomParentStrategy = this;
        if (virtualDomParentStrategy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/VirtualDomParentStrategy", "clearXmlElement"));
        }
        return virtualDomParentStrategy;
    }

    @Override
    public synchronized String checkValidity() {
        if (this.getModCount() == this.myModCount) {
            return null;
        }
        return "mod count changed";
    }

    @Override
    public XmlFile getContainingFile(DomInvocationHandler handler2) {
        return DomImplUtil.getFile(handler2);
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof VirtualDomParentStrategy)) {
            return false;
        }
        VirtualDomParentStrategy that = (VirtualDomParentStrategy)o2;
        return this.myParentHandler.equals((Object)that.myParentHandler);
    }

    public int hashCode() {
        return this.myParentHandler.hashCode();
    }
}

