/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentClassMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomReflectionUtil;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NonNls;

public class VisitorDescription {
    private final Class<? extends DomElementVisitor> myVisitorClass;
    private final ConcurrentClassMap<Method> myMethods = new ConcurrentClassMap();
    @NonNls
    private static final String VISIT = "visit";

    public VisitorDescription(Class<? extends DomElementVisitor> visitorClass) {
        this.myVisitorClass = visitorClass;
        for (Method method2 : ReflectionUtil.getClassPublicMethods(visitorClass)) {
            String methodName;
            Class<?> domClass;
            Class<?>[] parameterTypes = method2.getParameterTypes();
            if (parameterTypes.length != 1 || !ReflectionUtil.isAssignable(DomElement.class, domClass = parameterTypes[0]) || !VISIT.equals(methodName = method2.getName()) && !methodName.startsWith(VISIT)) continue;
            method2.setAccessible(true);
            this.myMethods.put(domClass, (Object)method2);
        }
    }

    public void acceptElement(DomElementVisitor visitor2, DomElement element) {
        Method method2 = (Method)this.myMethods.get(element.getClass());
        assert (method2 != null) : this.myVisitorClass + " can't accept element of type " + element.getClass();
        DomReflectionUtil.invokeMethod((Method)method2, (Object)visitor2, (Object[])new Object[]{element});
    }
}

