/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.SmartList;
import com.intellij.util.io.StringRef;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.ElementStub;
import com.intellij.xml.util.XmlUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomStub
extends ObjectStubBase<DomStub> {
    protected final StringRef myLocalName;
    private final StringRef myNamespace;
    private DomInvocationHandler myHandler;

    public DomStub(DomStub parent, @NotNull StringRef localName, StringRef namespace) {
        if (localName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localName", "com/intellij/util/xml/stubs/DomStub", "<init>"));
        }
        super((Stub)parent);
        this.myNamespace = namespace;
        if (parent != null) {
            ((ElementStub)parent).addChild(this);
        }
        this.myLocalName = localName;
    }

    @NotNull
    public abstract List<DomStub> getChildrenStubs();

    public String getName() {
        return this.myLocalName.getString();
    }

    @Nullable
    public String getNamespaceKey() {
        return this.myNamespace == null ? null : this.myNamespace.getString();
    }

    public List<DomStub> getChildrenByName(CharSequence name, @Nullable String nsKey) {
        List<DomStub> stubs = this.getChildrenStubs();
        if (stubs.isEmpty()) {
            return Collections.emptyList();
        }
        String s2 = nsKey == null ? "" : nsKey;
        SmartList result2 = new SmartList();
        int size = stubs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            DomStub stub2 = stubs.get(i2);
            if (!XmlUtil.getLocalName(stub2.getName()).equals(name) || !Comparing.equal((String)s2, (String)stub2.getNamespaceKey())) continue;
            result2.add(stub2);
        }
        return result2;
    }

    @Nullable
    public AttributeStub getAttributeStub(XmlName name) {
        List<DomStub> stubs = this.getChildrenStubs();
        if (stubs.isEmpty()) {
            return null;
        }
        int size = stubs.size();
        for (int i2 = 0; i2 < size; ++i2) {
            DomStub stub2 = stubs.get(i2);
            if (!(stub2 instanceof AttributeStub) || !stub2.getName().equals(name.getLocalName())) continue;
            return (AttributeStub)stub2;
        }
        return null;
    }

    @Nullable
    public ElementStub getElementStub(String name, int index) {
        List<DomStub> stubs = this.getChildrenStubs();
        int i2 = 0;
        for (DomStub stub2 : stubs) {
            if (!(stub2 instanceof ElementStub) || !name.equals(stub2.getName()) || i2++ != index) continue;
            return (ElementStub)stub2;
        }
        return null;
    }

    public synchronized DomInvocationHandler getOrCreateHandler(DomChildDescriptionImpl description, DomManagerImpl manager) {
        if (this.myHandler == null) {
            XmlName name = description.getXmlName();
            EvaluatedXmlNameImpl evaluatedXmlName = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)name, (String)name.getNamespaceKey(), (boolean)true);
            this.myHandler = new CollectionElementInvocationHandler((EvaluatedXmlName)evaluatedXmlName, description, manager, (ElementStub)this);
        }
        return this.myHandler;
    }

    public DomInvocationHandler getHandler() {
        return this.myHandler;
    }

    public void setHandler(DomInvocationHandler handler2) {
        this.myHandler = handler2;
    }

    public boolean isCustom() {
        return false;
    }

    public abstract int getIndex();

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || ((Object)((Object)this)).getClass() != o2.getClass()) {
            return false;
        }
        DomStub stub2 = (DomStub)((Object)o2);
        if (stub2.getIndex() != this.getIndex()) {
            return false;
        }
        if (stub2.isCustom() != this.isCustom()) {
            return false;
        }
        return Comparing.strEqual((String)stub2.getName(), (String)this.getName()) && Comparing.strEqual((String)stub2.getNamespaceKey(), (String)this.getNamespaceKey());
    }

    public int hashCode() {
        int result2 = this.myLocalName.hashCode();
        result2 = 31 * result2 + this.myNamespace.hashCode();
        result2 = 31 * result2 + this.getIndex();
        result2 = 31 * result2 + (this.isCustom() ? 1 : 0);
        return result2;
    }
}

