/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.util.SmartList;
import com.intellij.util.io.StringRef;
import com.intellij.util.xml.stubs.DomStub;
import com.intellij.util.xml.stubs.ElementStubSerializer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementStub
extends DomStub {
    private final List<DomStub> myChildren;
    private final int myIndex;
    private final boolean myCustom;
    @Nullable
    private final StringRef myElementClass;
    private final String myValue;

    public ElementStub(@Nullable ElementStub parent, @NotNull StringRef name, @Nullable StringRef namespace, int index, boolean custom, @Nullable StringRef elementClass, @NotNull String value2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/xml/stubs/ElementStub", "<init>"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/util/xml/stubs/ElementStub", "<init>"));
        }
        super(parent, name, namespace);
        this.myChildren = new SmartList();
        this.myIndex = index;
        this.myCustom = custom;
        this.myElementClass = elementClass;
        this.myValue = value2;
    }

    void addChild(DomStub child) {
        this.myChildren.add(child);
    }

    @Override
    @NotNull
    public List<DomStub> getChildrenStubs() {
        List<DomStub> list2 = this.myChildren;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/ElementStub", "getChildrenStubs"));
        }
        return list2;
    }

    public ObjectStubSerializer getStubType() {
        return ElementStubSerializer.INSTANCE;
    }

    public String toString() {
        String key = this.getNamespaceKey();
        return (StringUtil.isEmpty((String)key) ? this.getName() : key + ":" + this.getName()) + (StringUtil.isEmpty((String)this.getValue()) ? "" : ":" + this.getValue());
    }

    @Override
    public boolean isCustom() {
        return this.myCustom;
    }

    @Override
    public int getIndex() {
        return this.myIndex;
    }

    @Nullable
    String getElementClass() {
        return this.myElementClass == null ? null : this.myElementClass.getString();
    }

    @NotNull
    public String getValue() {
        String string2 = this.myValue;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/stubs/ElementStub", "getValue"));
        }
        return string2;
    }
}

