/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.tree.AbstractDomElementNode;
import com.intellij.util.xml.tree.BaseDomElementNode;
import com.intellij.util.xml.tree.DomModelTreeView;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class DomElementsToggleAction
extends ToggleAction {
    private final DomModelTreeView myTreeView;
    private final Class myClass;
    private final Icon myIcon;
    private final String myText;

    public DomElementsToggleAction(DomModelTreeView treeView, Class aClass) {
        this.myTreeView = treeView;
        this.myClass = aClass;
        Icon myIcon = ElementPresentationManager.getIcon((Object)this.myClass);
        if (myIcon == null) {
            myIcon = AllIcons.Nodes.Pointcut;
        }
        this.myIcon = myIcon;
        this.myText = TypePresentationService.getService().getTypePresentableName(this.myClass);
        if (this.getHiders() == null) {
            DomUtil.getFile((DomElement)this.myTreeView.getRootElement()).putUserData(AbstractDomElementNode.TREE_NODES_HIDERS_KEY, new HashMap());
        }
        this.getHiders().putIfAbsent(this.myClass, true);
    }

    public void update(AnActionEvent e2) {
        super.update(e2);
        e2.getPresentation().setIcon(this.myIcon);
        e2.getPresentation().setText((this.getHiders().get(this.myClass) != false ? "Hide " : "Show ") + this.myText);
        e2.getPresentation().setEnabled(this.getHiders() != null && this.getHiders().get(this.myClass) != null);
    }

    public boolean isSelected(AnActionEvent e2) {
        return this.getHiders().get(this.myClass);
    }

    private Map<Class, Boolean> getHiders() {
        return (Map)DomUtil.getFile((DomElement)this.myTreeView.getRootElement()).getUserData(BaseDomElementNode.TREE_NODES_HIDERS_KEY);
    }

    public void setSelected(AnActionEvent e2, boolean state) {
        this.getHiders().put(this.myClass, state);
        this.myTreeView.getBuilder().updateFromRoot();
    }
}

