/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;

public class VcsLocaleHelper {
    private static final String DEFAULT_EXECUTABLE_LOCALE_VALUE = "en_US.UTF-8";
    private static final String REGISTRY_KEY_SUFFIX = ".executable.locale";

    @NotNull
    public static String getDefaultLocaleFromRegistry(@NotNull String prefix) {
        String string2;
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/vcs/VcsLocaleHelper", "getDefaultLocaleFromRegistry"));
        }
        String registryKey = prefix + REGISTRY_KEY_SUFFIX;
        try {
            string2 = Registry.stringValue((String)registryKey);
        }
        catch (MissingResourceException e2) {
            if (DEFAULT_EXECUTABLE_LOCALE_VALUE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/VcsLocaleHelper", "getDefaultLocaleFromRegistry"));
            }
            return DEFAULT_EXECUTABLE_LOCALE_VALUE;
        }
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/VcsLocaleHelper", "getDefaultLocaleFromRegistry"));
        }
        return string2;
    }

    @NotNull
    public static Map<String, String> getDefaultLocaleEnvironmentVars(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/vcs/VcsLocaleHelper", "getDefaultLocaleEnvironmentVars"));
        }
        LinkedHashMap envMap = ContainerUtil.newLinkedHashMap();
        String defaultLocale = VcsLocaleHelper.getDefaultLocaleFromRegistry(prefix);
        if (defaultLocale.isEmpty()) {
            LinkedHashMap linkedHashMap = envMap;
            if (linkedHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/VcsLocaleHelper", "getDefaultLocaleEnvironmentVars"));
            }
            return linkedHashMap;
        }
        envMap.put("LANGUAGE", "");
        envMap.put("LC_ALL", defaultLocale);
        LinkedHashMap linkedHashMap = envMap;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/VcsLocaleHelper", "getDefaultLocaleEnvironmentVars"));
        }
        return linkedHashMap;
    }
}

