/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataGetter;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsCommitCache;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.data.index.IndexedDetails;
import com.intellij.vcs.log.data.index.VcsLogIndex;
import com.intellij.vcs.log.util.SequentialLimitedLifoExecutor;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntObjectHashMap;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractDataGetter<T extends VcsShortCommitDetails>
implements Disposable,
DataGetter<T> {
    private static final Logger LOG = Logger.getInstance(AbstractDataGetter.class);
    private static final int MAX_LOADING_TASKS = 10;
    @NotNull
    protected final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    @NotNull
    private final VcsCommitCache<Integer, T> myCache;
    @NotNull
    private final SequentialLimitedLifoExecutor<TaskDescriptor> myLoader;
    private long myCurrentTaskIndex;
    @NotNull
    private final Collection<Runnable> myLoadingFinishedListeners;
    @NotNull
    private VcsLogIndex myIndex;

    AbstractDataGetter(@NotNull VcsLogStorage storage2, @NotNull Map<VirtualFile, VcsLogProvider> logProviders, @NotNull VcsCommitCache<Integer, T> cache, @NotNull VcsLogIndex index, @NotNull Disposable parentDisposable) {
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/AbstractDataGetter", "<init>"));
        }
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/AbstractDataGetter", "<init>"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/vcs/log/data/AbstractDataGetter", "<init>"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/vcs/log/data/AbstractDataGetter", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/vcs/log/data/AbstractDataGetter", "<init>"));
        }
        this.myCurrentTaskIndex = 0L;
        this.myLoadingFinishedListeners = new ArrayList<Runnable>();
        this.myStorage = storage2;
        this.myLogProviders = logProviders;
        this.myCache = cache;
        this.myIndex = index;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myLoader = new SequentialLimitedLifoExecutor(this, 10, task2 -> {
            this.preLoadCommitData(((TaskDescriptor)task2).myCommits);
            this.notifyLoaded();
        });
    }

    private void notifyLoaded() {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            for (Runnable loadingFinishedListener : this.myLoadingFinishedListeners) {
                loadingFinishedListener.run();
            }
        });
    }

    public void dispose() {
        this.myLoadingFinishedListeners.clear();
    }

    @Override
    @NotNull
    public T getCommitData(@NotNull Integer hash, @NotNull Iterable<Integer> neighbourHashes) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitData"));
        }
        if (neighbourHashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "neighbourHashes", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitData"));
        }
        assert (EventQueue.isDispatchThread());
        T details = this.getFromCache(hash);
        if (details != null) {
            T t2 = details;
            if (t2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitData"));
            }
            return t2;
        }
        this.runLoadCommitsData(neighbourHashes);
        T result2 = this.myCache.get(hash);
        assert (result2 != null);
        T t3 = result2;
        if (t3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitData"));
        }
        return t3;
    }

    @Override
    public void loadCommitsData(@NotNull List<Integer> hashes, @NotNull Consumer<List<T>> consumer2, @Nullable ProgressIndicator indicator) {
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "com/intellij/vcs/log/data/AbstractDataGetter", "loadCommitsData"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/AbstractDataGetter", "loadCommitsData"));
        }
        assert (EventQueue.isDispatchThread());
        this.loadCommitsData(AbstractDataGetter.getCommitsMap(hashes), consumer2, indicator);
    }

    private void loadCommitsData(final @NotNull TIntIntHashMap commits, final @NotNull Consumer<List<T>> consumer2, @Nullable ProgressIndicator indicator) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/AbstractDataGetter", "loadCommitsData"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/AbstractDataGetter", "loadCommitsData"));
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        final TIntHashSet toLoad = new TIntHashSet();
        long taskNumber = this.myCurrentTaskIndex++;
        for (int id : commits.keys()) {
            T details = this.getFromCache(id);
            if (details == null || details instanceof LoadingDetails) {
                toLoad.add(id);
                this.cacheCommit(id, taskNumber);
                continue;
            }
            result2.add(details);
        }
        if (toLoad.isEmpty()) {
            this.sortCommitsByRow(result2, commits);
            consumer2.consume((Object)result2);
        } else {
            Task.Backgroundable task2 = new Task.Backgroundable(null, "Loading Selected Details", true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/vcs/log/data/AbstractDataGetter$1", "run"));
                    }
                    indicator.checkCanceled();
                    try {
                        TIntObjectHashMap map2 = AbstractDataGetter.this.preLoadCommitData(toLoad);
                        map2.forEachValue(value2 -> {
                            result2.add(value2);
                            return true;
                        });
                        AbstractDataGetter.this.sortCommitsByRow(result2, commits);
                        AbstractDataGetter.this.notifyLoaded();
                    }
                    catch (VcsException e2) {
                        LOG.error((Throwable)e2);
                    }
                }

                public void onSuccess() {
                    consumer2.consume((Object)result2);
                }
            };
            if (indicator != null) {
                ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, indicator);
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }
    }

    private void sortCommitsByRow(@NotNull List<T> result2, @NotNull TIntIntHashMap rowsForCommits) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/vcs/log/data/AbstractDataGetter", "sortCommitsByRow"));
        }
        if (rowsForCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowsForCommits", "com/intellij/vcs/log/data/AbstractDataGetter", "sortCommitsByRow"));
        }
        ContainerUtil.sort(result2, (details1, details2) -> {
            if (rowsForCommits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowsForCommits", "com/intellij/vcs/log/data/AbstractDataGetter", "lambda$sortCommitsByRow$2"));
            }
            int row1 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details1.getId(), details1.getRoot()));
            int row2 = rowsForCommits.get(this.myStorage.getCommitIndex((Hash)details2.getId(), details2.getRoot()));
            return Comparing.compare((int)row1, (int)row2);
        });
    }

    @Override
    @Nullable
    public T getCommitDataIfAvailable(int hash) {
        return this.getFromCache(hash);
    }

    @Nullable
    private T getFromCache(@NotNull Integer commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/data/AbstractDataGetter", "getFromCache"));
        }
        T details = this.myCache.get(commitId);
        if (details != null) {
            if (details instanceof LoadingDetails && ((LoadingDetails)details).getLoadingTaskIndex() <= this.myCurrentTaskIndex - 10L) {
                this.myCache.remove(commitId);
                return null;
            }
            return details;
        }
        return this.getFromAdditionalCache(commitId);
    }

    @Nullable
    protected abstract T getFromAdditionalCache(int var1);

    private void runLoadCommitsData(@NotNull Iterable<Integer> hashes) {
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "com/intellij/vcs/log/data/AbstractDataGetter", "runLoadCommitsData"));
        }
        long taskNumber = this.myCurrentTaskIndex++;
        TIntIntHashMap commits = AbstractDataGetter.getCommitsMap(hashes);
        TIntHashSet toLoad = new TIntHashSet();
        for (int id : commits.keys()) {
            this.cacheCommit(id, taskNumber);
            toLoad.add(id);
        }
        this.myLoader.queue(new TaskDescriptor(toLoad));
    }

    private void cacheCommit(int commitId, long taskNumber) {
        if (!this.myCache.isKeyCached(commitId)) {
            IndexDataGetter dataGetter = this.myIndex.getDataGetter();
            if (dataGetter != null) {
                this.myCache.put(commitId, new IndexedDetails(dataGetter, this.myStorage, commitId, taskNumber));
            } else {
                this.myCache.put(commitId, new LoadingDetails((Computable<CommitId>)((Computable)() -> this.myStorage.getCommitId(commitId)), taskNumber));
            }
        }
    }

    @NotNull
    private static TIntIntHashMap getCommitsMap(@NotNull Iterable<Integer> hashes) {
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitsMap"));
        }
        TIntIntHashMap commits = new TIntIntHashMap();
        int row = 0;
        for (Integer commitId : hashes) {
            commits.put(commitId.intValue(), row);
            ++row;
        }
        TIntIntHashMap tIntIntHashMap = commits;
        if (tIntIntHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/AbstractDataGetter", "getCommitsMap"));
        }
        return tIntIntHashMap;
    }

    @NotNull
    public TIntObjectHashMap<T> preLoadCommitData(@NotNull TIntHashSet commits) throws VcsException {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/AbstractDataGetter", "preLoadCommitData"));
        }
        TIntObjectHashMap result2 = new TIntObjectHashMap();
        MultiMap rootsAndHashes = MultiMap.create();
        commits.forEach(commit -> {
            CommitId commitId = this.myStorage.getCommitId(commit);
            if (commitId != null) {
                rootsAndHashes.putValue((Object)commitId.getRoot(), (Object)commitId.getHash().asString());
            }
            return true;
        });
        for (Map.Entry entry : rootsAndHashes.entrySet()) {
            VcsLogProvider logProvider = this.myLogProviders.get(entry.getKey());
            if (logProvider != null) {
                List<T> details = this.readDetails(logProvider, (VirtualFile)entry.getKey(), ContainerUtil.newArrayList((Iterable)((Iterable)entry.getValue())));
                for (VcsShortCommitDetails data : details) {
                    int index = this.myStorage.getCommitIndex((Hash)data.getId(), data.getRoot());
                    result2.put(index, (Object)data);
                }
                this.saveInCache(result2);
                continue;
            }
            LOG.error("No log provider for root " + ((VirtualFile)entry.getKey()).getPath() + ". All known log providers " + this.myLogProviders);
        }
        TIntObjectHashMap tIntObjectHashMap = result2;
        if (tIntObjectHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/AbstractDataGetter", "preLoadCommitData"));
        }
        return tIntObjectHashMap;
    }

    public void saveInCache(@NotNull TIntObjectHashMap<T> details) {
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/data/AbstractDataGetter", "saveInCache"));
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (details == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/vcs/log/data/AbstractDataGetter", "lambda$saveInCache$6"));
            }
            details.forEachEntry((key, value2) -> {
                this.myCache.put(key, (VcsShortCommitDetails)value2);
                return true;
            });
        });
    }

    @NotNull
    protected abstract List<? extends T> readDetails(@NotNull VcsLogProvider var1, @NotNull VirtualFile var2, @NotNull List<String> var3) throws VcsException;

    public void addDetailsLoadedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/data/AbstractDataGetter", "addDetailsLoadedListener"));
        }
        this.myLoadingFinishedListeners.add(runnable2);
    }

    public void removeDetailsLoadedListener(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/data/AbstractDataGetter", "removeDetailsLoadedListener"));
        }
        this.myLoadingFinishedListeners.remove(runnable2);
    }

    private static class TaskDescriptor {
        @NotNull
        private final TIntHashSet myCommits;

        private TaskDescriptor(@NotNull TIntHashSet commits) {
            if (commits == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/AbstractDataGetter$TaskDescriptor", "<init>"));
            }
            this.myCommits = commits;
        }
    }
}

