/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.EmptyPermanentGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.VcsLogStorageImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.util.StopWatch;
import gnu.trove.TIntHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DataPack
extends DataPackBase {
    public static final DataPack EMPTY = DataPack.createEmptyInstance();
    @NotNull
    private final PermanentGraph<Integer> myPermanentGraph;

    DataPack(@NotNull RefsModel refsModel, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers, boolean full) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/data/DataPack", "<init>"));
        }
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/data/DataPack", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/DataPack", "<init>"));
        }
        super(providers, refsModel, full);
        this.myPermanentGraph = permanentGraph;
    }

    @NotNull
    public static DataPack build(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogStorage storage2, boolean full) {
        PermanentGraph<Integer> permanentGraph;
        RefsModel refsModel;
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (commits.isEmpty()) {
            refsModel = new RefsModel(refs, ContainerUtil.newHashSet(), storage2, providers);
            permanentGraph = EmptyPermanentGraph.getInstance();
        } else {
            refsModel = new RefsModel(refs, DataPack.getHeads(commits), storage2, providers);
            Function<Integer, Hash> hashGetter = VcsLogStorageImpl.createHashGetter(storage2);
            GraphColorManagerImpl colorManager = new GraphColorManagerImpl(refsModel, hashGetter, DataPack.getRefManagerMap(providers));
            Set<Integer> branches = DataPack.getBranchCommitHashIndexes(refsModel.getBranches(), storage2);
            StopWatch sw = StopWatch.start("building graph");
            permanentGraph = PermanentGraphImpl.newInstance(commits, colorManager, branches);
            sw.report();
        }
        DataPack dataPack = new DataPack(refsModel, permanentGraph, providers, full);
        if (dataPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        return dataPack;
    }

    @NotNull
    private static Set<Integer> getHeads(@NotNull List<? extends GraphCommit<Integer>> commits) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/DataPack", "getHeads"));
        }
        TIntHashSet parents = new TIntHashSet();
        for (GraphCommit<Integer> graphCommit : commits) {
            Iterator iterator2 = graphCommit.getParents().iterator();
            while (iterator2.hasNext()) {
                int parent = (Integer)iterator2.next();
                parents.add(parent);
            }
        }
        HashSet heads = ContainerUtil.newHashSet();
        for (GraphCommit<Integer> graphCommit : commits) {
            if (parents.contains(((Integer)graphCommit.getId()).intValue())) continue;
            heads.add(graphCommit.getId());
        }
        HashSet hashSet = heads;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getHeads"));
        }
        return hashSet;
    }

    @NotNull
    private static Set<Integer> getBranchCommitHashIndexes(@NotNull Collection<VcsRef> branches, @NotNull VcsLogStorage storage2) {
        if (branches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branches", "com/intellij/vcs/log/data/DataPack", "getBranchCommitHashIndexes"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/DataPack", "getBranchCommitHashIndexes"));
        }
        HashSet<Integer> result2 = new HashSet<Integer>();
        for (VcsRef vcsRef : branches) {
            result2.add(storage2.getCommitIndex(vcsRef.getCommitHash(), vcsRef.getRoot()));
        }
        HashSet<Integer> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getBranchCommitHashIndexes"));
        }
        return hashSet;
    }

    @NotNull
    public static Map<VirtualFile, VcsLogRefManager> getRefManagerMap(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/DataPack", "getRefManagerMap"));
        }
        HashMap map2 = ContainerUtil.newHashMap();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            map2.put(entry.getKey(), entry.getValue().getReferenceManager());
        }
        HashMap hashMap = map2;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getRefManagerMap"));
        }
        return hashMap;
    }

    @NotNull
    private static DataPack createEmptyInstance() {
        RefsModel emptyModel = new RefsModel(ContainerUtil.newHashMap(), ContainerUtil.newHashSet(), VcsLogStorageImpl.EMPTY, ContainerUtil.newHashMap());
        DataPack dataPack = new DataPack(emptyModel, EmptyPermanentGraph.getInstance(), Collections.emptyMap(), false);
        if (dataPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "createEmptyInstance"));
        }
        return dataPack;
    }

    @NotNull
    public PermanentGraph<Integer> getPermanentGraph() {
        PermanentGraph<Integer> permanentGraph = this.myPermanentGraph;
        if (permanentGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getPermanentGraph"));
        }
        return permanentGraph;
    }

    public String toString() {
        return "{DataPack. " + this.myPermanentGraph.getAllCommits().size() + " commits in " + this.myLogProviders.keySet().size() + " roots}";
    }
}

