/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.VcsLogStorage;
import gnu.trove.TIntObjectHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefsModel
implements VcsLogRefs {
    private static final Logger LOG = Logger.getInstance(RefsModel.class);
    @NotNull
    private final VcsLogStorage myStorage;
    @NotNull
    private final Map<VirtualFile, CompressedRefs> myRefs;
    @NotNull
    private final TIntObjectHashMap<VcsRef> myBestRefForHead;
    @NotNull
    private final TIntObjectHashMap<VirtualFile> myRootForHead;

    public RefsModel(@NotNull Map<VirtualFile, CompressedRefs> refs, @NotNull Set<Integer> heads, @NotNull VcsLogStorage storage2, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        if (heads == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heads", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        if (storage2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/RefsModel", "<init>"));
        }
        this.myRefs = refs;
        this.myStorage = storage2;
        this.myBestRefForHead = new TIntObjectHashMap();
        this.myRootForHead = new TIntObjectHashMap();
        for (int head : heads) {
            CommitId commitId = this.myStorage.getCommitId(head);
            if (commitId == null) continue;
            VirtualFile root = commitId.getRoot();
            this.myRootForHead.put(head, (Object)root);
            Optional bestRef = this.myRefs.get(root).refsToCommit(head).stream().min(providers.get(root).getReferenceManager().getBranchLayoutComparator());
            if (bestRef.isPresent()) {
                this.myBestRefForHead.put(head, bestRef.get());
                continue;
            }
            LOG.warn("No references at head " + commitId);
        }
    }

    @Nullable
    public VcsRef bestRefToHead(int headIndex) {
        return (VcsRef)this.myBestRefForHead.get(headIndex);
    }

    @NotNull
    public VirtualFile rootAtHead(int headIndex) {
        VirtualFile virtualFile = (VirtualFile)this.myRootForHead.get(headIndex);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "rootAtHead"));
        }
        return virtualFile;
    }

    @NotNull
    public Map<VirtualFile, CompressedRefs> getAllRefsByRoot() {
        Map<VirtualFile, CompressedRefs> map2 = this.myRefs;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getAllRefsByRoot"));
        }
        return map2;
    }

    public Collection<VcsRef> refsToCommit(int index) {
        CommitId id = this.myStorage.getCommitId(index);
        if (id == null) {
            return Collections.emptyList();
        }
        VirtualFile root = id.getRoot();
        return this.myRefs.get(root).refsToCommit(index);
    }

    @NotNull
    public Collection<VcsRef> getBranches() {
        Collection collection = this.myRefs.values().stream().flatMap(CompressedRefs::streamBranches).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "getBranches"));
        }
        return collection;
    }

    @NotNull
    public Stream<VcsRef> stream() {
        assert (!ApplicationManager.getApplication().isDispatchThread());
        Stream<VcsRef> stream = this.myRefs.values().stream().flatMap(CompressedRefs::stream);
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/RefsModel", "stream"));
        }
        return stream;
    }
}

