/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.TrigramBuilder;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogMessagesTrigramIndex
extends VcsLogFullDetailsIndex<Void> {
    public static final String TRIGRAMS = "trigrams";

    public VcsLogMessagesTrigramIndex(@NotNull String logId, @NotNull FatalErrorHandler fatalErrorHandler, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "<init>"));
        }
        if (fatalErrorHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorHandler", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "<init>"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "<init>"));
        }
        super(logId, TRIGRAMS, VcsLogPersistentIndex.getVersion(), new TrigramMessageIndexer(), VoidDataExternalizer.INSTANCE, fatalErrorHandler, disposableParent);
    }

    @Nullable
    public TIntHashSet getCommitsForSubstring(@NotNull String string2) throws StorageException {
        if (string2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex", "getCommitsForSubstring"));
        }
        MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
        TrigramBuilder.processTrigrams((CharSequence)string2, (TrigramBuilder.TrigramProcessor)trigramProcessor);
        if (trigramProcessor.map.isEmpty()) {
            return null;
        }
        return this.getCommitsWithAllKeys(trigramProcessor.map.keySet());
    }

    private static class MyTrigramProcessor
    extends TrigramBuilder.TrigramProcessor {
        Map<Integer, Void> map;

        private MyTrigramProcessor() {
        }

        public boolean consumeTrigramsCount(int count) {
            this.map = new THashMap(count);
            return true;
        }

        public boolean execute(int value2) {
            this.map.put(value2, null);
            return true;
        }
    }

    public static class TrigramMessageIndexer
    implements DataIndexer<Integer, Void, VcsFullCommitDetails> {
        @NotNull
        public Map<Integer, Void> map(@NotNull VcsFullCommitDetails inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex$TrigramMessageIndexer", "map"));
            }
            MyTrigramProcessor trigramProcessor = new MyTrigramProcessor();
            TrigramBuilder.processTrigrams((CharSequence)inputData.getFullMessage(), (TrigramBuilder.TrigramProcessor)trigramProcessor);
            Map<Integer, Void> map2 = trigramProcessor.map;
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogMessagesTrigramIndex$TrigramMessageIndexer", "map"));
            }
            return map2;
        }
    }
}

