/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.VoidDataExternalizer;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsUserRegistryImpl;
import com.intellij.vcs.log.data.index.VcsLogFullDetailsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import gnu.trove.THashMap;
import gnu.trove.TIntHashSet;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogUserIndex
extends VcsLogFullDetailsIndex<Void> {
    private static final Logger LOG = Logger.getInstance(VcsLogUserIndex.class);
    public static final String USERS = "users";
    @NotNull
    private final VcsUserRegistryImpl myUserRegistry;

    public VcsLogUserIndex(@NotNull String logId, @NotNull VcsUserRegistryImpl userRegistry, @NotNull FatalErrorHandler consumer2, @NotNull Disposable disposableParent) throws IOException {
        if (logId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logId", "com/intellij/vcs/log/data/index/VcsLogUserIndex", "<init>"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userRegistry", "com/intellij/vcs/log/data/index/VcsLogUserIndex", "<init>"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogUserIndex", "<init>"));
        }
        if (disposableParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposableParent", "com/intellij/vcs/log/data/index/VcsLogUserIndex", "<init>"));
        }
        super(logId, USERS, VcsLogPersistentIndex.getVersion(), new UserIndexer(userRegistry), VoidDataExternalizer.INSTANCE, consumer2, disposableParent);
        this.myUserRegistry = userRegistry;
        ((UserIndexer)this.myIndexer).setFatalErrorConsumer((Consumer<Exception>)((Consumer)e2 -> {
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/data/index/VcsLogUserIndex", "lambda$new$0"));
            }
            consumer2.consume(this, (Exception)e2);
        }));
    }

    public TIntHashSet getCommitsForUsers(@NotNull Set<VcsUser> users) throws IOException, StorageException {
        if (users == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", USERS, "com/intellij/vcs/log/data/index/VcsLogUserIndex", "getCommitsForUsers"));
        }
        HashSet ids = ContainerUtil.newHashSet();
        for (VcsUser user : users) {
            ids.add(this.myUserRegistry.getUserId(user));
        }
        return this.getCommitsWithAnyKey(ids);
    }

    private static class UserIndexer
    implements DataIndexer<Integer, Void, VcsFullCommitDetails> {
        @NotNull
        private final VcsUserRegistryImpl myRegistry;
        @NotNull
        private Consumer<Exception> myFatalErrorConsumer;

        public UserIndexer(@NotNull VcsUserRegistryImpl registry) {
            if (registry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer", "<init>"));
            }
            this.myFatalErrorConsumer = arg_0 -> ((Logger)LOG).error(arg_0);
            this.myRegistry = registry;
        }

        @NotNull
        public Map<Integer, Void> map(@NotNull VcsFullCommitDetails inputData) {
            if (inputData == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer", "map"));
            }
            THashMap result2 = new THashMap();
            try {
                result2.put(this.myRegistry.getUserId(inputData.getAuthor()), null);
            }
            catch (IOException e2) {
                this.myFatalErrorConsumer.consume((Object)e2);
            }
            THashMap tHashMap = result2;
            if (tHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer", "map"));
            }
            return tHashMap;
        }

        public void setFatalErrorConsumer(@NotNull Consumer<Exception> fatalErrorConsumer) {
            if (fatalErrorConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fatalErrorConsumer", "com/intellij/vcs/log/data/index/VcsLogUserIndex$UserIndexer", "setFatalErrorConsumer"));
            }
            this.myFatalErrorConsumer = fatalErrorConsumer;
        }
    }
}

