/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.vcs.log.graph.GraphCommit;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphCommitImpl<CommitId>
extends ImmutableList<CommitId>
implements GraphCommit<CommitId> {
    @NotNull
    private final CommitId myId;
    @NotNull
    private final Object myParents;
    private final long myTimestamp;

    public GraphCommitImpl(@NotNull CommitId id, @NotNull List<CommitId> parents, long timestamp) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/graph/GraphCommitImpl", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/vcs/log/graph/GraphCommitImpl", "<init>"));
        }
        this.myId = id;
        this.myTimestamp = timestamp;
        if (parents.isEmpty()) {
            this.myParents = ArrayUtil.EMPTY_OBJECT_ARRAY;
        } else if (parents.size() == 1) {
            this.myParents = parents.get(0);
            assert (!(this.myParents instanceof Object[]));
        } else {
            this.myParents = parents.toArray();
        }
    }

    @NotNull
    public CommitId getId() {
        CommitId CommitId2 = this.myId;
        if (CommitId2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphCommitImpl", "getId"));
        }
        return CommitId2;
    }

    @NotNull
    public List<CommitId> getParents() {
        GraphCommitImpl graphCommitImpl = this;
        if (graphCommitImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/GraphCommitImpl", "getParents"));
        }
        return graphCommitImpl;
    }

    public CommitId get(int index) {
        if (this.myParents instanceof Object[]) {
            Object[] array2 = (Object[])this.myParents;
            if (index < 0 || index >= array2.length) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return (CommitId)array2[index];
        }
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return (CommitId)this.myParents;
    }

    public int size() {
        return this.myParents instanceof Object[] ? ((Object[])this.myParents).length : 1;
    }

    public long getTimestamp() {
        return this.myTimestamp;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !(o2 instanceof GraphCommit)) {
            return false;
        }
        GraphCommit commit = (GraphCommit)o2;
        return this.myId.equals(commit.getId());
    }

    public int hashCode() {
        return this.myId.hashCode();
    }
}

