/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.permanent.PermanentGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CascadeController
implements LinearGraphController {
    @Nullable
    private final CascadeController myDelegateController;
    @NotNull
    protected final PermanentGraphInfo myPermanentGraphInfo;

    protected CascadeController(@Nullable CascadeController delegateController, @NotNull PermanentGraphInfo permanentGraphInfo) {
        if (permanentGraphInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraphInfo", "com/intellij/vcs/log/graph/impl/facade/CascadeController", "<init>"));
        }
        this.myDelegateController = delegateController;
        this.myPermanentGraphInfo = permanentGraphInfo;
    }

    @Override
    @NotNull
    public LinearGraphController.LinearGraphAnswer performLinearGraphAction(@NotNull LinearGraphController.LinearGraphAction action2) {
        if (action2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/vcs/log/graph/impl/facade/CascadeController", "performLinearGraphAction"));
        }
        LinearGraphController.LinearGraphAnswer answer = this.performAction(action2);
        if (answer == null && this.myDelegateController != null) {
            answer = this.myDelegateController.performLinearGraphAction(new VisibleGraphImpl.LinearGraphActionImpl(this.convertToDelegate(action2.getAffectedElement()), action2.getType()));
            answer = this.delegateGraphChanged(answer);
        }
        if (answer != null) {
            LinearGraphController.LinearGraphAnswer linearGraphAnswer = answer;
            if (linearGraphAnswer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/CascadeController", "performLinearGraphAction"));
            }
            return linearGraphAnswer;
        }
        LinearGraphController.LinearGraphAnswer linearGraphAnswer = LinearGraphUtils.DEFAULT_GRAPH_ANSWER;
        if (linearGraphAnswer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/CascadeController", "performLinearGraphAction"));
        }
        return linearGraphAnswer;
    }

    @Nullable
    private PrintElementWithGraphElement convertToDelegate(@Nullable PrintElementWithGraphElement element) {
        if (element == null) {
            return null;
        }
        GraphElement convertedGraphElement = this.convertToDelegate(element.getGraphElement());
        if (convertedGraphElement == null) {
            return null;
        }
        return PrintElementWithGraphElement.converted(element, convertedGraphElement);
    }

    @Nullable
    protected GraphElement convertToDelegate(@NotNull GraphElement graphElement) {
        if (graphElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphElement", "com/intellij/vcs/log/graph/impl/facade/CascadeController", "convertToDelegate"));
        }
        return graphElement;
    }

    @NotNull
    protected CascadeController getDelegateController() {
        assert (this.myDelegateController != null);
        CascadeController cascadeController = this.myDelegateController;
        if (cascadeController == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/CascadeController", "getDelegateController"));
        }
        return cascadeController;
    }

    @NotNull
    public PermanentGraphInfo getPermanentGraphInfo() {
        PermanentGraphInfo permanentGraphInfo = this.myPermanentGraphInfo;
        if (permanentGraphInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/CascadeController", "getPermanentGraphInfo"));
        }
        return permanentGraphInfo;
    }

    @NotNull
    protected abstract LinearGraphController.LinearGraphAnswer delegateGraphChanged(@NotNull LinearGraphController.LinearGraphAnswer var1);

    @Nullable
    protected abstract LinearGraphController.LinearGraphAnswer performAction(@NotNull LinearGraphController.LinearGraphAction var1);
}

