/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade;

import com.intellij.util.Consumer;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.DfsUtil;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.UnsignedBitSet;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReachableNodes {
    @NotNull
    private final LiteLinearGraph myGraph;
    @NotNull
    private final Flags myTempFlags;

    public ReachableNodes(@NotNull LiteLinearGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "<init>"));
        }
        this.myGraph = graph;
        this.myTempFlags = new BitSetFlags(graph.nodesCount());
    }

    @NotNull
    public static UnsignedBitSet getReachableNodes(@NotNull LinearGraph permanentGraph, @Nullable Set<Integer> headNodeIndexes) {
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "getReachableNodes"));
        }
        if (headNodeIndexes == null) {
            UnsignedBitSet nodesVisibility = new UnsignedBitSet();
            nodesVisibility.set(0, permanentGraph.nodesCount() - 1, true);
            UnsignedBitSet unsignedBitSet = nodesVisibility;
            if (unsignedBitSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "getReachableNodes"));
            }
            return unsignedBitSet;
        }
        UnsignedBitSet result2 = new UnsignedBitSet();
        ReachableNodes getter = new ReachableNodes(LinearGraphUtils.asLiteLinearGraph(permanentGraph));
        getter.walk(headNodeIndexes, (Consumer<Integer>)((Consumer)node -> result2.set((int)node, true)));
        UnsignedBitSet unsignedBitSet = result2;
        if (unsignedBitSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "getReachableNodes"));
        }
        return unsignedBitSet;
    }

    @NotNull
    public Set<Integer> getContainingBranches(int nodeIndex, @NotNull Collection<Integer> branchNodeIndexes) {
        if (branchNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchNodeIndexes", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "getContainingBranches"));
        }
        HashSet<Integer> result2 = new HashSet<Integer>();
        this.walk(Collections.singletonList(nodeIndex), false, (Consumer<Integer>)((Consumer)node -> {
            if (branchNodeIndexes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchNodeIndexes", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "lambda$getContainingBranches$1"));
            }
            if (branchNodeIndexes.contains(node)) {
                result2.add((Integer)node);
            }
        }));
        HashSet<Integer> hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "getContainingBranches"));
        }
        return hashSet;
    }

    public void walk(@NotNull Collection<Integer> headIds, @NotNull Consumer<Integer> consumer2) {
        if (headIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headIds", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        this.walk(headIds, true, consumer2);
    }

    private void walk(@NotNull Collection<Integer> startNodes, boolean goDown, @NotNull Consumer<Integer> consumer2) {
        if (startNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startNodes", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        this.walk(startNodes, goDown, (int node) -> {
            if (consumer2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "lambda$walk$2"));
            }
            consumer2.consume((Object)node);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void walk(@NotNull Collection<Integer> startNodes, boolean goDown, @NotNull IntPredicate consumer2) {
        if (startNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startNodes", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        if (consumer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "walk"));
        }
        Flags flags = this.myTempFlags;
        synchronized (flags) {
            this.myTempFlags.setAll(false);
            for (int start2 : startNodes) {
                if (start2 < 0 || this.myTempFlags.get(start2)) continue;
                this.myTempFlags.set(start2, true);
                if (!consumer2.test(start2)) {
                    return;
                }
                DfsUtil.walk(start2, currentNode -> {
                    if (consumer2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/vcs/log/graph/impl/facade/ReachableNodes", "lambda$walk$3"));
                    }
                    for (int downNode : this.myGraph.getNodes(currentNode, goDown ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP)) {
                        if (this.myTempFlags.get(downNode)) continue;
                        this.myTempFlags.set(downNode, true);
                        if (!consumer2.test(downNode)) {
                            return -10;
                        }
                        return downNode;
                    }
                    return -1;
                });
            }
        }
    }
}

