/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DuplicateParentFixer {
    public static <CommitId> AbstractList<? extends GraphCommit<CommitId>> fixDuplicateParentCommits(final List<? extends GraphCommit<CommitId>> finalCommits) {
        return new AbstractList<GraphCommit<CommitId>>(){

            @Override
            public GraphCommit<CommitId> get(int index) {
                return DuplicateParentFixer.fixParentsDuplicate((GraphCommit)finalCommits.get(index));
            }

            @Override
            public int size() {
                return finalCommits.size();
            }
        };
    }

    @NotNull
    private static <CommitId> GraphCommit<CommitId> fixParentsDuplicate(@NotNull GraphCommit<CommitId> commit) {
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer", "fixParentsDuplicate"));
        }
        List parents = commit.getParents();
        if (parents.size() <= 1) {
            GraphCommit<CommitId> graphCommit = commit;
            if (graphCommit == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer", "fixParentsDuplicate"));
            }
            return graphCommit;
        }
        if (parents.size() == 2) {
            Object commitId0 = parents.get(0);
            if (!commitId0.equals(parents.get(1))) {
                GraphCommit<CommitId> graphCommit = commit;
                if (graphCommit == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer", "fixParentsDuplicate"));
                }
                return graphCommit;
            }
            DelegateGraphCommit delegateGraphCommit = new DelegateGraphCommit(commit, Collections.singletonList(commitId0));
            if (delegateGraphCommit == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer", "fixParentsDuplicate"));
            }
            return delegateGraphCommit;
        }
        HashSet allParents = new HashSet(parents);
        if (parents.size() == allParents.size()) {
            GraphCommit<CommitId> graphCommit = commit;
            if (graphCommit == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer", "fixParentsDuplicate"));
            }
            return graphCommit;
        }
        ArrayList correctParents = ContainerUtil.newArrayList();
        for (Object commitId : parents) {
            if (!allParents.remove(commitId)) continue;
            correctParents.add(commitId);
        }
        DelegateGraphCommit delegateGraphCommit = new DelegateGraphCommit(commit, correctParents);
        if (delegateGraphCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer", "fixParentsDuplicate"));
        }
        return delegateGraphCommit;
    }

    private static class DelegateGraphCommit<CommitId>
    implements GraphCommit<CommitId> {
        @NotNull
        private final GraphCommit<CommitId> myDelegate;
        @NotNull
        private final List<CommitId> myParents;

        private DelegateGraphCommit(@NotNull GraphCommit<CommitId> delegate2, @NotNull List<CommitId> parents) {
            if (delegate2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer$DelegateGraphCommit", "<init>"));
            }
            if (parents == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer$DelegateGraphCommit", "<init>"));
            }
            this.myDelegate = delegate2;
            this.myParents = parents;
        }

        @NotNull
        public CommitId getId() {
            Object object = this.myDelegate.getId();
            if (object == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer$DelegateGraphCommit", "getId"));
            }
            return (CommitId)object;
        }

        @NotNull
        public List<CommitId> getParents() {
            List<CommitId> list2 = this.myParents;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/DuplicateParentFixer$DelegateGraphCommit", "getParents"));
            }
            return list2;
        }

        public long getTimestamp() {
            return this.myDelegate.getTimestamp();
        }
    }
}

