/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.api.permanent.PermanentCommitsInfo;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.TimestampGetter;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import com.intellij.vcs.log.graph.utils.impl.IntTimestampGetter;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PermanentCommitsInfoImpl<CommitId>
implements PermanentCommitsInfo<CommitId> {
    private static final Logger LOG = Logger.getInstance(PermanentCommitsInfoImpl.class);
    @NotNull
    private final TimestampGetter myTimestampGetter;
    @NotNull
    private final List<CommitId> myCommitIdIndexes;
    @NotNull
    private final Map<Integer, CommitId> myNotLoadCommits;

    @NotNull
    public static <CommitId> PermanentCommitsInfoImpl<CommitId> newInstance(@NotNull List<? extends GraphCommit<CommitId>> graphCommits, @NotNull Map<Integer, CommitId> notLoadedCommits) {
        if (graphCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphCommits", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "newInstance"));
        }
        if (notLoadedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notLoadedCommits", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "newInstance"));
        }
        IntTimestampGetter timestampGetter = PermanentCommitsInfoImpl.createTimestampGetter(graphCommits);
        boolean isIntegerCase = !graphCommits.isEmpty() && graphCommits.get(0).getId().getClass() == Integer.class;
        List commitIdIndex = isIntegerCase ? PermanentCommitsInfoImpl.createCompressedIntList(graphCommits) : ContainerUtil.map(graphCommits, (Function)new Function<GraphCommit<CommitId>, CommitId>(){

            public CommitId fun(GraphCommit<CommitId> graphCommit) {
                return graphCommit.getId();
            }
        });
        PermanentCommitsInfoImpl<CommitId> permanentCommitsInfoImpl = new PermanentCommitsInfoImpl<CommitId>(timestampGetter, commitIdIndex, notLoadedCommits);
        if (permanentCommitsInfoImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "newInstance"));
        }
        return permanentCommitsInfoImpl;
    }

    @NotNull
    public static <CommitId> IntTimestampGetter createTimestampGetter(final @NotNull List<? extends GraphCommit<CommitId>> graphCommits) {
        if (graphCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphCommits", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "createTimestampGetter"));
        }
        IntTimestampGetter intTimestampGetter = IntTimestampGetter.newInstance(new TimestampGetter(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public long getTimestamp(int index) {
                return ((GraphCommit)graphCommits.get(index)).getTimestamp();
            }
        });
        if (intTimestampGetter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "createTimestampGetter"));
        }
        return intTimestampGetter;
    }

    @NotNull
    private static List<Integer> createCompressedIntList(final @NotNull List<? extends GraphCommit<Integer>> graphCommits) {
        if (graphCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphCommits", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "createCompressedIntList"));
        }
        final IntList compressedIntList = CompressedIntList.newInstance(new IntList(){

            @Override
            public int size() {
                return graphCommits.size();
            }

            @Override
            public int get(int index) {
                return (Integer)((GraphCommit)graphCommits.get(index)).getId();
            }
        }, 30);
        AbstractList<Integer> abstractList = new AbstractList<Integer>(){

            @Override
            @NotNull
            public Integer get(int index) {
                Integer n2 = compressedIntList.get(index);
                if (n2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl$4", "get"));
                }
                return n2;
            }

            @Override
            public int size() {
                return compressedIntList.size();
            }
        };
        if (abstractList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "createCompressedIntList"));
        }
        return abstractList;
    }

    public PermanentCommitsInfoImpl(@NotNull TimestampGetter timestampGetter, @NotNull List<CommitId> commitIdIndex, @NotNull Map<Integer, CommitId> notLoadCommits) {
        if (timestampGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timestampGetter", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "<init>"));
        }
        if (commitIdIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIdIndex", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "<init>"));
        }
        if (notLoadCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notLoadCommits", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "<init>"));
        }
        this.myTimestampGetter = timestampGetter;
        this.myCommitIdIndexes = commitIdIndex;
        this.myNotLoadCommits = notLoadCommits;
    }

    @Override
    @NotNull
    public CommitId getCommitId(int nodeId) {
        if (nodeId < 0) {
            CommitId CommitId2 = this.myNotLoadCommits.get(nodeId);
            if (CommitId2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "getCommitId"));
            }
            return CommitId2;
        }
        CommitId CommitId3 = this.myCommitIdIndexes.get(nodeId);
        if (CommitId3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "getCommitId"));
        }
        return CommitId3;
    }

    @Override
    public long getTimestamp(int nodeId) {
        if (nodeId < 0) {
            return 0L;
        }
        return this.myTimestampGetter.getTimestamp(nodeId);
    }

    @NotNull
    public TimestampGetter getTimestampGetter() {
        TimestampGetter timestampGetter = this.myTimestampGetter;
        if (timestampGetter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "getTimestampGetter"));
        }
        return timestampGetter;
    }

    @Override
    public int getNodeId(@NotNull CommitId commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "getNodeId"));
        }
        int indexOf = this.myCommitIdIndexes.indexOf(commitId);
        if (indexOf != -1) {
            return indexOf;
        }
        return this.getNotLoadNodeId(commitId);
    }

    private int getNotLoadNodeId(@NotNull CommitId commitId) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "getNotLoadNodeId"));
        }
        for (Map.Entry<Integer, CommitId> entry : this.myNotLoadCommits.entrySet()) {
            if (!entry.getValue().equals(commitId)) continue;
            return entry.getKey();
        }
        return -1;
    }

    @NotNull
    public List<CommitId> convertToCommitIdList(@NotNull Collection<Integer> commitIndexes) {
        if (commitIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIndexes", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "convertToCommitIdList"));
        }
        List list2 = ContainerUtil.map(commitIndexes, (Function)new Function<Integer, CommitId>(){

            public CommitId fun(Integer integer) {
                return PermanentCommitsInfoImpl.this.getCommitId(integer);
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "convertToCommitIdList"));
        }
        return list2;
    }

    @NotNull
    public Set<CommitId> convertToCommitIdSet(@NotNull Collection<Integer> commitIndexes) {
        if (commitIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIndexes", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "convertToCommitIdSet"));
        }
        Set set2 = ContainerUtil.map2Set(commitIndexes, (Function)new Function<Integer, CommitId>(){

            public CommitId fun(Integer integer) {
                return PermanentCommitsInfoImpl.this.getCommitId(integer);
            }
        });
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "convertToCommitIdSet"));
        }
        return set2;
    }

    @Override
    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<CommitId> commitIds) {
        if (commitIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIds", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "convertToNodeIds"));
        }
        Set<Integer> set2 = this.convertToNodeIds(commitIds, false);
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "convertToNodeIds"));
        }
        return set2;
    }

    @NotNull
    public Set<Integer> convertToNodeIds(@NotNull Collection<CommitId> commitIds, boolean reportNotFound) {
        Collection unmatchedIds;
        if (commitIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIds", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "convertToNodeIds"));
        }
        HashSet result2 = ContainerUtil.newHashSet();
        HashSet matchedIds = ContainerUtil.newHashSet();
        for (int i2 = 0; i2 < this.myCommitIdIndexes.size(); ++i2) {
            CommitId commitId = this.myCommitIdIndexes.get(i2);
            if (!commitIds.contains(commitId)) continue;
            result2.add(i2);
            matchedIds.add(commitId);
        }
        if (reportNotFound && !(unmatchedIds = ContainerUtil.subtract(commitIds, (Collection)matchedIds)).isEmpty()) {
            LOG.warn("Unmatched commit ids " + unmatchedIds);
        }
        for (Map.Entry<Integer, CommitId> entry : this.myNotLoadCommits.entrySet()) {
            if (!commitIds.contains(entry.getValue())) continue;
            result2.add(entry.getKey());
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/PermanentCommitsInfoImpl", "convertToNodeIds"));
        }
        return hashSet;
    }
}

