/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphController;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.awt.Cursor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinearGraphUtils {
    public static final LinearGraphController.LinearGraphAnswer DEFAULT_GRAPH_ANSWER = new LinearGraphController.LinearGraphAnswer(Cursor.getDefaultCursor(), null);

    public static boolean intEqual(@Nullable Integer value2, int number) {
        return value2 != null && value2 == number;
    }

    public static boolean isEdgeUp(@NotNull GraphEdge edge, int nodeIndex) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "isEdgeUp"));
        }
        return LinearGraphUtils.intEqual(edge.getDownNodeIndex(), nodeIndex);
    }

    public static boolean isEdgeDown(@NotNull GraphEdge edge, int nodeIndex) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "isEdgeDown"));
        }
        return LinearGraphUtils.intEqual(edge.getUpNodeIndex(), nodeIndex);
    }

    public static boolean isNormalEdge(@Nullable GraphEdge edge) {
        if (edge != null && edge.getType().isNormalEdge()) {
            assert (edge.getUpNodeIndex() != null && edge.getDownNodeIndex() != null);
            return true;
        }
        return false;
    }

    @Nullable
    public static NormalEdge asNormalEdge(@Nullable GraphEdge edge) {
        if (LinearGraphUtils.isNormalEdge(edge)) {
            assert (edge.getUpNodeIndex() != null && edge.getDownNodeIndex() != null);
            return NormalEdge.create(edge.getUpNodeIndex(), edge.getDownNodeIndex());
        }
        return null;
    }

    public static int getNotNullNodeIndex(@NotNull GraphEdge edge) {
        if (edge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edge", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getNotNullNodeIndex"));
        }
        if (edge.getUpNodeIndex() != null) {
            return edge.getUpNodeIndex();
        }
        assert (edge.getDownNodeIndex() != null);
        return edge.getDownNodeIndex();
    }

    @NotNull
    public static List<Integer> getUpNodes(@NotNull LinearGraph graph, int nodeIndex) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getUpNodes"));
        }
        List list2 = ContainerUtil.mapNotNull(graph.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_UP), (Function)new Function<GraphEdge, Integer>(){

            @Nullable
            public Integer fun(GraphEdge graphEdge) {
                return graphEdge.getUpNodeIndex();
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getUpNodes"));
        }
        return list2;
    }

    @NotNull
    public static List<Integer> getDownNodes(@NotNull LinearGraph graph, int nodeIndex) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getDownNodes"));
        }
        List list2 = ContainerUtil.mapNotNull(graph.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_DOWN), (Function)new Function<GraphEdge, Integer>(){

            @Nullable
            public Integer fun(GraphEdge graphEdge) {
                return graphEdge.getDownNodeIndex();
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getDownNodes"));
        }
        return list2;
    }

    @NotNull
    public static List<Integer> getDownNodesIncludeNotLoad(@NotNull LinearGraph graph, final int nodeIndex) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getDownNodesIncludeNotLoad"));
        }
        List list2 = ContainerUtil.mapNotNull(graph.getAdjacentEdges(nodeIndex, EdgeFilter.ALL), (Function)new Function<GraphEdge, Integer>(){

            @Nullable
            public Integer fun(GraphEdge graphEdge) {
                if (LinearGraphUtils.isEdgeDown(graphEdge, nodeIndex)) {
                    if (graphEdge.getType() == GraphEdgeType.NOT_LOAD_COMMIT) {
                        return graphEdge.getTargetId();
                    }
                    return graphEdge.getDownNodeIndex();
                }
                return null;
            }
        });
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getDownNodesIncludeNotLoad"));
        }
        return list2;
    }

    @NotNull
    public static LiteLinearGraph asLiteLinearGraph(final @NotNull LinearGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "asLiteLinearGraph"));
        }
        LiteLinearGraph liteLinearGraph = new LiteLinearGraph(){

            @Override
            public int nodesCount() {
                return graph.nodesCount();
            }

            @Override
            @NotNull
            public List<Integer> getNodes(final int nodeIndex, @NotNull LiteLinearGraph.NodeFilter filter2) {
                if (filter2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/graph/utils/LinearGraphUtils$4", "getNodes"));
                }
                List list2 = ContainerUtil.mapNotNull(graph.getAdjacentEdges(nodeIndex, filter2.edgeFilter), (Function)new Function<GraphEdge, Integer>(){

                    public Integer fun(GraphEdge edge) {
                        if (LinearGraphUtils.isEdgeUp(edge, nodeIndex)) {
                            return edge.getUpNodeIndex();
                        }
                        if (LinearGraphUtils.isEdgeDown(edge, nodeIndex)) {
                            return edge.getDownNodeIndex();
                        }
                        return null;
                    }
                });
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/LinearGraphUtils$4", "getNodes"));
                }
                return list2;
            }
        };
        if (liteLinearGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "asLiteLinearGraph"));
        }
        return liteLinearGraph;
    }

    @NotNull
    public static Cursor getCursor(boolean hand) {
        if (hand) {
            Cursor cursor = Cursor.getPredefinedCursor(12);
            if (cursor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getCursor"));
            }
            return cursor;
        }
        Cursor cursor = Cursor.getDefaultCursor();
        if (cursor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getCursor"));
        }
        return cursor;
    }

    public static LinearGraphController.LinearGraphAnswer createSelectedAnswer(@NotNull LinearGraph linearGraph, @NotNull Collection<Integer> selectedNodeIndexes) {
        if (linearGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linearGraph", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "createSelectedAnswer"));
        }
        if (selectedNodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedNodeIndexes", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "createSelectedAnswer"));
        }
        HashSet selectedIds = ContainerUtil.newHashSet();
        for (Integer nodeIndex : selectedNodeIndexes) {
            if (nodeIndex == null) continue;
            selectedIds.add(linearGraph.getNodeId(nodeIndex));
        }
        return new LinearGraphController.LinearGraphAnswer(LinearGraphUtils.getCursor(true), selectedIds);
    }

    @Nullable
    public static GraphEdge getEdge(@NotNull LinearGraph graph, int up, int down) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "getEdge"));
        }
        List<GraphEdge> edges = graph.getAdjacentEdges(up, EdgeFilter.NORMAL_DOWN);
        for (GraphEdge edge : edges) {
            if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), down)) continue;
            return edge;
        }
        return null;
    }

    @NotNull
    public static Set<Integer> convertNodeIndexesToIds(final @NotNull LinearGraph graph, @NotNull Collection<Integer> nodeIndexes) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "convertNodeIndexesToIds"));
        }
        if (nodeIndexes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeIndexes", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "convertNodeIndexesToIds"));
        }
        Set set2 = ContainerUtil.map2Set(nodeIndexes, (Function)new Function<Integer, Integer>(){

            public Integer fun(Integer nodeIndex) {
                return graph.getNodeId(nodeIndex);
            }
        });
        if (set2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "convertNodeIndexesToIds"));
        }
        return set2;
    }

    @NotNull
    public static Set<Integer> convertIdsToNodeIndexes(final @NotNull LinearGraph graph, @NotNull Collection<Integer> ids) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "convertIdsToNodeIndexes"));
        }
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "convertIdsToNodeIndexes"));
        }
        List result2 = ContainerUtil.mapNotNull(ids, (Function)new Function<Integer, Integer>(){

            public Integer fun(Integer id) {
                return graph.getNodeIndex(id);
            }
        });
        HashSet hashSet = ContainerUtil.newHashSet((Iterable)result2);
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/LinearGraphUtils", "convertIdsToNodeIndexes"));
        }
        return hashSet;
    }
}

