/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntToIntMap;

public abstract class AbstractIntToIntMap
implements IntToIntMap {
    @Override
    public int getShortIndex(int longIndex) {
        this.checkLongIndex(longIndex);
        if (this.shortSize() == 0 || this.getLongIndex(0) > longIndex) {
            return 0;
        }
        int a = 0;
        int b2 = this.shortSize() - 1;
        while (b2 > a + 1) {
            int middle = (a + b2) / 2;
            if (this.getLongIndex(middle) <= longIndex) {
                a = middle;
                continue;
            }
            b2 = middle;
        }
        return this.getLongIndex(b2) <= longIndex ? b2 : a;
    }

    protected void checkLongIndex(int longIndex) {
        if (longIndex < 0 || longIndex >= this.longSize()) {
            throw new IndexOutOfBoundsException("LongSize is: " + this.longSize() + ", but longIndex: " + longIndex);
        }
    }

    protected void checkShortIndex(int shortIndex) {
        if (shortIndex < 0 || shortIndex >= this.shortSize()) {
            throw new IndexOutOfBoundsException("ShortSize is: " + this.shortSize() + ", but shortIndex: " + shortIndex);
        }
    }

    protected void checkUpdateParameters(int startLongIndex, int endLongIndex) {
        if (startLongIndex < 0 || endLongIndex < startLongIndex || endLongIndex >= this.longSize()) {
            throw new IllegalArgumentException("ShortSize is: " + this.shortSize() + ", but updateRequest is: (" + startLongIndex + ", " + endLongIndex + ")");
        }
    }
}

