/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.ByteArrayUtils;
import org.jetbrains.annotations.NotNull;

public class SmartDeltaCompressor
implements IntList {
    private final int mySize;
    private final byte[] myDeltas;
    private final long[] myMajorBits;
    private final long[] myMinorBits;
    private final int[] myStrongIndexes;

    @NotNull
    public static SmartDeltaCompressor newInstance(@NotNull IntList deltaList) {
        if (deltaList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deltaList", "com/intellij/vcs/log/graph/utils/impl/SmartDeltaCompressor", "newInstance"));
        }
        if (deltaList.size() < 0) {
            throw new NegativeArraySizeException("size < 0: " + deltaList.size());
        }
        int bytesAfterCompression = ByteArrayUtils.countBytesAfterCompression(deltaList);
        byte[] deltas = new byte[bytesAfterCompression];
        int size = deltaList.size();
        int groundPointCount = ByteArrayUtils.groundPointCount(size, 64);
        int[] groundIndexes = new int[groundPointCount];
        long[] majorBits = new long[groundPointCount];
        long[] minorBits = new long[groundPointCount];
        int offset = 0;
        for (int main2 = 0; main2 < groundPointCount; ++main2) {
            int index;
            groundIndexes[main2] = offset;
            for (int rem = 0; rem < 64 && (index = main2 * 64 + rem) < size; ++rem) {
                int sizeOf = ByteArrayUtils.sizeOf(deltaList.get(index));
                ByteArrayUtils.writeDelta(offset, deltaList.get(index), sizeOf, deltas);
                long mask = 1L << rem;
                if (sizeOf == 3 || sizeOf == 4) {
                    int n2 = main2;
                    majorBits[n2] = majorBits[n2] | mask;
                }
                if (sizeOf == 2 || sizeOf == 4) {
                    int n3 = main2;
                    minorBits[n3] = minorBits[n3] | mask;
                }
                offset += sizeOf;
            }
        }
        SmartDeltaCompressor smartDeltaCompressor = new SmartDeltaCompressor(size, deltas, majorBits, minorBits, groundIndexes);
        if (smartDeltaCompressor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/utils/impl/SmartDeltaCompressor", "newInstance"));
        }
        return smartDeltaCompressor;
    }

    private SmartDeltaCompressor(int size, byte[] deltas, long[] majorBits, long[] minorBits, int[] strongIndexes) {
        this.mySize = size;
        this.myDeltas = deltas;
        this.myMajorBits = majorBits;
        this.myMinorBits = minorBits;
        this.myStrongIndexes = strongIndexes;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public int get(int index) {
        int main2 = index >>> 6;
        int rem = index & 0x3F;
        int shift = 63 - rem;
        long major = this.myMajorBits[main2] << shift;
        long minor = this.myMinorBits[main2] << shift;
        int sizeOf = (int)(2L * (major >>> 63) + (minor >>> 63) + 1L);
        int endIndex = this.myStrongIndexes[main2] + 2 * Long.bitCount(major) + Long.bitCount(minor) + rem + 1;
        return ByteArrayUtils.readDelta(endIndex - sizeOf, sizeOf, this.myDeltas);
    }
}

