/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsCommitMetadataImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsChangesLazilyParsedDetails
extends VcsCommitMetadataImpl
implements VcsFullCommitDetails {
    private static final Logger LOG = Logger.getInstance(VcsChangesLazilyParsedDetails.class);
    @NotNull
    protected final ThrowableComputable<Collection<Change>, ? extends Exception> myChangesGetter;

    /*
     * WARNING - void declaration
     */
    public VcsChangesLazilyParsedDetails(@NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message2, @NotNull VcsUser committer, long authorTime, @NotNull ThrowableComputable<Collection<Change>, ? extends Exception> throwableComputable) {
        void changesGetter;
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "<init>"));
        }
        if (parents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parents", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "<init>"));
        }
        if (subject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subject", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "<init>"));
        }
        if (author == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "author", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "<init>"));
        }
        if (message2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "<init>"));
        }
        if (committer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "committer", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "<init>"));
        }
        if (throwableComputable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changesGetter", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "<init>"));
        }
        super(hash, parents, commitTime, root, subject, author, message2, committer, authorTime);
        this.myChangesGetter = changesGetter;
    }

    @NotNull
    public Collection<Change> getChanges() {
        Collection collection;
        try {
            collection = (Collection)this.myChangesGetter.compute();
        }
        catch (Exception e2) {
            LOG.error("Error happened when parsing changes", (Throwable)e2);
            List<Change> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "getChanges"));
            }
            return list2;
        }
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "getChanges"));
        }
        return collection;
    }

    @NotNull
    public Collection<String> getModifiedPaths() {
        HashSet changedPaths = ContainerUtil.newHashSet();
        for (Change change : this.getChanges()) {
            if (change.getAfterRevision() != null) {
                changedPaths.add(change.getAfterRevision().getFile().getPath());
            }
            if (change.getBeforeRevision() == null) continue;
            changedPaths.add(change.getBeforeRevision().getFile().getPath());
        }
        HashSet hashSet = changedPaths;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "getModifiedPaths"));
        }
        return hashSet;
    }

    @NotNull
    public Collection<Couple<String>> getRenamedPaths() {
        HashSet renames = ContainerUtil.newHashSet();
        for (Change change : this.getChanges()) {
            if (!change.getType().equals((Object)Change.Type.MOVED) || change.getAfterRevision() == null || change.getBeforeRevision() == null) continue;
            renames.add(Couple.of((Object)change.getBeforeRevision().getFile().getPath(), (Object)change.getAfterRevision().getFile().getPath()));
        }
        HashSet hashSet = renames;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/impl/VcsChangesLazilyParsedDetails", "getRenamedPaths"));
        }
        return hashSet;
    }
}

